/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.apache.sis.coverage.grid.j2d.DeferredProperty;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Errors;

public abstract class BatchComputedImage
extends ComputedImage {
    private final Map<String, Object> properties;
    private Rasters prefetched;

    protected BatchComputedImage(SampleModel sampleModel, Map<String, Object> properties, RenderedImage ... sources) {
        super(sampleModel, sources);
        this.properties = properties != null ? Map.copyOf(properties) : Map.of();
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.properties.getOrDefault(key, Image.UndefinedProperty);
        if (value instanceof DeferredProperty) {
            value = ((DeferredProperty)value).compute(this);
        }
        return value;
    }

    @Override
    public String[] getPropertyNames() {
        int n = this.properties.size();
        return n == 0 ? null : this.properties.keySet().toArray(new String[n]);
    }

    protected abstract Raster[] computeTiles(Rectangle var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Raster computeTile(int tileX, int tileY, WritableRaster previous) throws Exception {
        BatchComputedImage batchComputedImage = this;
        synchronized (batchComputedImage) {
            Rasters r = this.prefetched;
            while (r != null) {
                int x = tileX - r.x;
                int y = tileY - r.y;
                if ((x | y) >= 0 && x < r.width && y < r.height) {
                    return r.tiles[x + y * r.width];
                }
                r = r.next;
            }
        }
        Raster[] tiles = this.computeTiles(new Rectangle(tileX, tileY, 1, 1));
        if (tiles.length == 1) {
            return tiles[0];
        }
        throw new ImagingOpException(Errors.format((short)119));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Disposable prefetch(Rectangle region) {
        Raster[] tiles;
        try {
            tiles = this.computeTiles(region);
        }
        catch (Exception e) {
            throw (ImagingOpException)new ImagingOpException(null).initCause(e);
        }
        Rasters r = new Rasters(region, tiles);
        BatchComputedImage batchComputedImage = this;
        synchronized (batchComputedImage) {
            r.next = this.prefetched;
            this.prefetched = r;
        }
        return r;
    }

    private synchronized void remove(Rasters tiles) {
        Rasters previous = null;
        Rasters r = this.prefetched;
        while (r != tiles) {
            if (r == null) {
                return;
            }
            previous = r;
            r = r.next;
        }
        r = r.next;
        if (previous != null) {
            previous.next = r;
        } else {
            this.prefetched = r;
        }
    }

    private final class Rasters
    implements Disposable {
        final int x;
        final int y;
        final int width;
        final int height;
        final Raster[] tiles;
        Rasters next;

        Rasters(Rectangle r, Raster[] tiles) {
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
            this.tiles = tiles;
        }

        public void dispose() {
            BatchComputedImage.this.remove(this);
        }
    }
}

