/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.client.ResponseTimeoutMode;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.DefaultFlagsProvider;
import com.linecorp.armeria.common.FlagsProvider;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextStorageProvider;
import com.linecorp.armeria.common.SystemPropertyFlagsProvider;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.common.util.TlsEngineType;
import com.linecorp.armeria.common.util.TransportType;
import com.linecorp.armeria.internal.common.FlagsLoaded;
import com.linecorp.armeria.internal.common.util.SslContextUtil;
import com.linecorp.armeria.internal.shaded.caffeine.cache.CaffeineSpec;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.CharMatcher;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.MultipartRemovalStrategy;
import com.linecorp.armeria.server.TransientServiceOption;
import com.linecorp.armeria.server.annotation.ExceptionVerbosity;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.ReferenceCountUtil;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Flags {
    private static final Logger logger = LoggerFactory.getLogger(Flags.class);
    private static final String PREFIX = "com.linecorp.armeria.";
    private static final List<FlagsProvider> FLAGS_PROVIDERS;
    private static final Sampler<Class<? extends Throwable>> VERBOSE_EXCEPTION_SAMPLER;
    private static final String VERBOSE_EXCEPTION_SAMPLER_SPEC;
    private static final long DEFAULT_UNLOGGED_EXCEPTIONS_REPORT_INTERVAL_MILLIS;
    private static final Predicate<InetAddress> PREFERRED_IP_V4_ADDRESSES;
    private static final boolean VERBOSE_SOCKET_EXCEPTIONS;
    private static final boolean VERBOSE_RESPONSES;
    private static final RequestContextStorageProvider REQUEST_CONTEXT_STORAGE_PROVIDER;
    private static final boolean WARN_NETTY_VERSIONS;
    private static final boolean DEFAULT_USE_EPOLL;
    private static final boolean USE_EPOLL;
    private static final Predicate<TransportType> TRANSPORT_TYPE_VALIDATOR;
    private static final TransportType TRANSPORT_TYPE;
    @Nullable
    private static TlsEngineType tlsEngineType;
    @Nullable
    private static Boolean dumpOpenSslInfo;
    private static final int MAX_NUM_CONNECTIONS;
    private static final int NUM_COMMON_WORKERS;
    private static final int NUM_COMMON_BLOCKING_TASK_THREADS;
    private static final long DEFAULT_MAX_REQUEST_LENGTH;
    private static final long DEFAULT_MAX_RESPONSE_LENGTH;
    private static final long DEFAULT_REQUEST_TIMEOUT_MILLIS;
    private static final long DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS;
    private static final long DEFAULT_WRITE_TIMEOUT_MILLIS;
    private static final long DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS;
    private static final boolean DEFAULT_SERVER_KEEP_ALIVE_ON_PING;
    private static final long DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS;
    private static final boolean DEFAULT_CLIENT_KEEP_ALIVE_ON_PING;
    private static final long DEFAULT_PING_INTERVAL_MILLIS;
    private static final int DEFAULT_MAX_SERVER_NUM_REQUESTS_PER_CONNECTION;
    private static final int DEFAULT_MAX_CLIENT_NUM_REQUESTS_PER_CONNECTION;
    private static final long DEFAULT_MAX_SERVER_CONNECTION_AGE_MILLIS;
    private static final long DEFAULT_MAX_CLIENT_CONNECTION_AGE_MILLIS;
    private static final long DEFAULT_SERVER_CONNECTION_DRAIN_DURATION_MICROS;
    private static final long DEFAULT_CLIENT_HTTP2_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS;
    private static final int DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE;
    private static final int DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE;
    private static final int DEFAULT_HTTP2_MAX_FRAME_SIZE;
    private static final long DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION;
    private static final long DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE;
    private static final int DEFAULT_SERVER_HTTP2_MAX_RESET_FRAMES_PER_MINUTE;
    private static final int DEFAULT_MAX_HTTP1_INITIAL_LINE_LENGTH;
    private static final int DEFAULT_MAX_HTTP1_HEADER_SIZE;
    private static final int DEFAULT_HTTP1_MAX_CHUNK_SIZE;
    private static final boolean DEFAULT_USE_HTTP2_PREFACE;
    private static final boolean DEFAULT_PREFER_HTTP1;
    private static final boolean DEFAULT_USE_HTTP2_WITHOUT_ALPN;
    private static final boolean DEFAULT_USE_HTTP1_PIPELINING;
    private static final String DEFAULT_BACKOFF_SPEC;
    private static final int DEFAULT_MAX_TOTAL_ATTEMPTS;
    private static final long DEFAULT_REQUEST_AUTO_ABORT_DELAY_MILLIS;
    @Nullable
    private static final String ROUTE_CACHE_SPEC;
    @Nullable
    private static final String ROUTE_DECORATOR_CACHE_SPEC;
    @Nullable
    private static final String PARSED_PATH_CACHE_SPEC;
    @Nullable
    private static final String HEADER_VALUE_CACHE_SPEC;
    private static final List<String> CACHED_HEADERS;
    @Nullable
    private static final String FILE_SERVICE_CACHE_SPEC;
    private static final String DNS_CACHE_SPEC;
    private static final String DEFAULT_ANNOTATED_SERVICE_EXCEPTION_VERBOSITY = "unhandled";
    private static final ExceptionVerbosity ANNOTATED_SERVICE_EXCEPTION_VERBOSITY;
    private static final boolean USE_JDK_DNS_RESOLVER;
    private static final boolean REPORT_BLOCKED_EVENT_LOOP;
    private static final boolean REPORT_MASKED_ROUTES;
    private static final boolean VALIDATE_HEADERS;
    private static final boolean TLS_ALLOW_UNSAFE_CIPHERS;
    private static final int DEFAULT_MAX_CLIENT_HELLO_LENGTH;
    private static final Set<TransientServiceOption> TRANSIENT_SERVICE_OPTIONS;
    private static final boolean USE_LEGACY_ROUTE_DECORATOR_ORDERING;
    private static final boolean USE_DEFAULT_SOCKET_OPTIONS;
    private static final boolean ALLOW_DOUBLE_DOTS_IN_QUERY_STRING;
    private static final boolean ALLOW_SEMICOLON_IN_PATH_COMPONENT;
    private static final Path DEFAULT_MULTIPART_UPLOADS_LOCATION;
    private static final MultipartRemovalStrategy DEFAULT_MULTIPART_REMOVAL_STRATEGY;
    private static final Sampler<? super RequestContext> REQUEST_CONTEXT_LEAK_DETECTION_SAMPLER;
    private static final MeterRegistry METER_REGISTRY;
    private static final DistributionStatisticConfig DISTRIBUTION_STATISTIC_CONFIG;
    private static final long DEFAULT_HTTP1_CONNECTION_CLOSE_DELAY_MILLIS;
    private static final ResponseTimeoutMode RESPONSE_TIMEOUT_MODE;

    private static boolean validateTransportType(TransportType transportType, String friendlyName) {
        if (transportType.isAvailable()) {
            logger.info("Using {}", (Object)friendlyName);
            return true;
        }
        Throwable cause = transportType.unavailabilityCause();
        if (cause != null) {
            logger.info("{} not available: {}", (Object)friendlyName, (Object)cause.toString());
        } else {
            logger.info("{} not available: ?", (Object)friendlyName);
        }
        return false;
    }

    public static Sampler<Class<? extends Throwable>> verboseExceptionSampler() {
        return VERBOSE_EXCEPTION_SAMPLER;
    }

    @Deprecated
    public static String verboseExceptionSamplerSpec() {
        return VERBOSE_EXCEPTION_SAMPLER_SPEC;
    }

    public static boolean verboseSocketExceptions() {
        return VERBOSE_SOCKET_EXCEPTIONS;
    }

    public static boolean verboseResponses() {
        return VERBOSE_RESPONSES;
    }

    public static RequestContextStorageProvider requestContextStorageProvider() {
        return REQUEST_CONTEXT_STORAGE_PROVIDER;
    }

    public static boolean warnNettyVersions() {
        return WARN_NETTY_VERSIONS;
    }

    @Deprecated
    public static boolean useEpoll() {
        return USE_EPOLL;
    }

    public static TransportType transportType() {
        return TRANSPORT_TYPE;
    }

    @Deprecated
    public static boolean useOpenSsl() {
        return Flags.tlsEngineType() == TlsEngineType.OPENSSL;
    }

    @UnstableApi
    public static TlsEngineType tlsEngineType() {
        if (tlsEngineType != null) {
            return tlsEngineType;
        }
        Flags.detectTlsEngineAndDumpOpenSslInfo();
        assert (tlsEngineType != null);
        return tlsEngineType;
    }

    private static void detectTlsEngineAndDumpOpenSslInfo() {
        Boolean useOpenSsl = Flags.getUserValue(FlagsProvider::useOpenSsl, "useOpenSsl", ignored -> true);
        TlsEngineType tlsEngineTypeValue = Flags.getUserValue(FlagsProvider::tlsEngineType, "tlsEngineType", ignored -> true);
        if (useOpenSsl != null && useOpenSsl != (tlsEngineTypeValue == TlsEngineType.OPENSSL)) {
            logger.warn("useOpenSsl({}) and tlsEngineType({}) are incompatible, tlsEngineType will be used", (Object)useOpenSsl, (Object)tlsEngineTypeValue);
        }
        TlsEngineType preferredTlsEngineType = null;
        if (tlsEngineTypeValue != null) {
            preferredTlsEngineType = tlsEngineTypeValue;
        } else if (useOpenSsl != null) {
            TlsEngineType tlsEngineType = preferredTlsEngineType = useOpenSsl != false ? TlsEngineType.OPENSSL : TlsEngineType.JDK;
        }
        if (preferredTlsEngineType == TlsEngineType.OPENSSL && !OpenSsl.isAvailable()) {
            Throwable cause = Exceptions.peel(OpenSsl.unavailabilityCause());
            logger.info("OpenSSL not available: {}", (Object)cause.toString());
            preferredTlsEngineType = TlsEngineType.JDK;
        }
        if (preferredTlsEngineType == null) {
            TlsEngineType tlsEngineType = preferredTlsEngineType = OpenSsl.isAvailable() ? TlsEngineType.OPENSSL : TlsEngineType.JDK;
        }
        if ((tlsEngineType = preferredTlsEngineType) != TlsEngineType.OPENSSL) {
            dumpOpenSslInfo = false;
            logger.info("Using TLS engine: {}", (Object)tlsEngineType);
            return;
        }
        logger.info("Using Tls engine: OpenSSL {}, 0x{}", (Object)OpenSsl.versionString(), (Object)Long.toHexString((long)OpenSsl.version() & 0xFFFFFFFFL));
        dumpOpenSslInfo = Flags.getValue(FlagsProvider::dumpOpenSslInfo, "dumpOpenSslInfo");
        if (dumpOpenSslInfo.booleanValue()) {
            SSLEngine engine = SslContextUtil.createSslContext(SslContextBuilder::forClient, false, tlsEngineType, false, ImmutableList.of(), null).newEngine(ByteBufAllocator.DEFAULT);
            logger.info("All available SSL protocols: {}", ImmutableList.copyOf(engine.getSupportedProtocols()));
            logger.info("Default enabled SSL protocols: {}", SslContextUtil.DEFAULT_PROTOCOLS);
            ReferenceCountUtil.release((Object)engine);
            logger.info("All available SSL ciphers: {}", (Object)OpenSsl.availableJavaCipherSuites());
            logger.info("Default enabled SSL ciphers: {}", SslContextUtil.DEFAULT_CIPHERS);
        }
    }

    public static boolean dumpOpenSslInfo() {
        if (dumpOpenSslInfo != null) {
            return dumpOpenSslInfo;
        }
        Flags.detectTlsEngineAndDumpOpenSslInfo();
        assert (dumpOpenSslInfo != null);
        return dumpOpenSslInfo;
    }

    public static int maxNumConnections() {
        return MAX_NUM_CONNECTIONS;
    }

    public static int numCommonWorkers() {
        return NUM_COMMON_WORKERS;
    }

    public static int numCommonBlockingTaskThreads() {
        return NUM_COMMON_BLOCKING_TASK_THREADS;
    }

    public static long defaultMaxRequestLength() {
        return DEFAULT_MAX_REQUEST_LENGTH;
    }

    public static long defaultMaxResponseLength() {
        return DEFAULT_MAX_RESPONSE_LENGTH;
    }

    public static long defaultRequestTimeoutMillis() {
        return DEFAULT_REQUEST_TIMEOUT_MILLIS;
    }

    public static long defaultResponseTimeoutMillis() {
        return DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    }

    public static long defaultConnectTimeoutMillis() {
        return DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    public static long defaultWriteTimeoutMillis() {
        return DEFAULT_WRITE_TIMEOUT_MILLIS;
    }

    public static long defaultServerIdleTimeoutMillis() {
        return DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS;
    }

    public static boolean defaultServerKeepAliveOnPing() {
        return DEFAULT_SERVER_KEEP_ALIVE_ON_PING;
    }

    public static long defaultClientIdleTimeoutMillis() {
        return DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS;
    }

    public static boolean defaultClientKeepAliveOnPing() {
        return DEFAULT_CLIENT_KEEP_ALIVE_ON_PING;
    }

    public static int defaultHttp1MaxInitialLineLength() {
        return DEFAULT_MAX_HTTP1_INITIAL_LINE_LENGTH;
    }

    public static int defaultHttp1MaxHeaderSize() {
        return DEFAULT_MAX_HTTP1_HEADER_SIZE;
    }

    public static int defaultHttp1MaxChunkSize() {
        return DEFAULT_HTTP1_MAX_CHUNK_SIZE;
    }

    public static boolean defaultUseHttp2Preface() {
        return DEFAULT_USE_HTTP2_PREFACE;
    }

    @UnstableApi
    public static boolean defaultPreferHttp1() {
        return DEFAULT_PREFER_HTTP1;
    }

    @UnstableApi
    public static boolean defaultUseHttp2WithoutAlpn() {
        return DEFAULT_USE_HTTP2_WITHOUT_ALPN;
    }

    public static boolean defaultUseHttp1Pipelining() {
        return DEFAULT_USE_HTTP1_PIPELINING;
    }

    public static long defaultPingIntervalMillis() {
        return DEFAULT_PING_INTERVAL_MILLIS;
    }

    public static int defaultMaxServerNumRequestsPerConnection() {
        return DEFAULT_MAX_SERVER_NUM_REQUESTS_PER_CONNECTION;
    }

    public static int defaultMaxClientNumRequestsPerConnection() {
        return DEFAULT_MAX_CLIENT_NUM_REQUESTS_PER_CONNECTION;
    }

    public static long defaultMaxServerConnectionAgeMillis() {
        return DEFAULT_MAX_SERVER_CONNECTION_AGE_MILLIS;
    }

    public static long defaultMaxClientConnectionAgeMillis() {
        return DEFAULT_MAX_CLIENT_CONNECTION_AGE_MILLIS;
    }

    public static long defaultServerConnectionDrainDurationMicros() {
        return DEFAULT_SERVER_CONNECTION_DRAIN_DURATION_MICROS;
    }

    public static long defaultClientHttp2GracefulShutdownTimeoutMillis() {
        return DEFAULT_CLIENT_HTTP2_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS;
    }

    public static int defaultHttp2InitialConnectionWindowSize() {
        return DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE;
    }

    public static int defaultHttp2InitialStreamWindowSize() {
        return DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE;
    }

    public static int defaultHttp2MaxFrameSize() {
        return DEFAULT_HTTP2_MAX_FRAME_SIZE;
    }

    public static long defaultHttp2MaxStreamsPerConnection() {
        return DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION;
    }

    public static long defaultHttp2MaxHeaderListSize() {
        return DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE;
    }

    @UnstableApi
    public static int defaultServerHttp2MaxResetFramesPerMinute() {
        return DEFAULT_SERVER_HTTP2_MAX_RESET_FRAMES_PER_MINUTE;
    }

    public static String defaultBackoffSpec() {
        return DEFAULT_BACKOFF_SPEC;
    }

    public static int defaultMaxTotalAttempts() {
        return DEFAULT_MAX_TOTAL_ATTEMPTS;
    }

    @UnstableApi
    public static long defaultRequestAutoAbortDelayMillis() {
        return DEFAULT_REQUEST_AUTO_ABORT_DELAY_MILLIS;
    }

    @Nullable
    public static String routeCacheSpec() {
        return ROUTE_CACHE_SPEC;
    }

    @Nullable
    public static String routeDecoratorCacheSpec() {
        return ROUTE_DECORATOR_CACHE_SPEC;
    }

    @Nullable
    public static String parsedPathCacheSpec() {
        return PARSED_PATH_CACHE_SPEC;
    }

    @Nullable
    public static String headerValueCacheSpec() {
        return HEADER_VALUE_CACHE_SPEC;
    }

    public static List<String> cachedHeaders() {
        return CACHED_HEADERS;
    }

    @Nullable
    public static String fileServiceCacheSpec() {
        return FILE_SERVICE_CACHE_SPEC;
    }

    public static String dnsCacheSpec() {
        return DNS_CACHE_SPEC;
    }

    @Deprecated
    public static ExceptionVerbosity annotatedServiceExceptionVerbosity() {
        return ANNOTATED_SERVICE_EXCEPTION_VERBOSITY;
    }

    public static Predicate<InetAddress> preferredIpV4Addresses() {
        return PREFERRED_IP_V4_ADDRESSES;
    }

    public static boolean useJdkDnsResolver() {
        return USE_JDK_DNS_RESOLVER;
    }

    public static boolean reportBlockedEventLoop() {
        return REPORT_BLOCKED_EVENT_LOOP;
    }

    public static boolean reportMaskedRoutes() {
        return REPORT_MASKED_ROUTES;
    }

    public static boolean validateHeaders() {
        return VALIDATE_HEADERS;
    }

    public static boolean tlsAllowUnsafeCiphers() {
        return TLS_ALLOW_UNSAFE_CIPHERS;
    }

    public static int defaultMaxClientHelloLength() {
        return DEFAULT_MAX_CLIENT_HELLO_LENGTH;
    }

    public static Set<TransientServiceOption> transientServiceOptions() {
        return TRANSIENT_SERVICE_OPTIONS;
    }

    public static boolean useDefaultSocketOptions() {
        return USE_DEFAULT_SOCKET_OPTIONS;
    }

    public static boolean useLegacyRouteDecoratorOrdering() {
        return USE_LEGACY_ROUTE_DECORATOR_ORDERING;
    }

    public static Path defaultMultipartUploadsLocation() {
        return DEFAULT_MULTIPART_UPLOADS_LOCATION;
    }

    @UnstableApi
    public static MultipartRemovalStrategy defaultMultipartRemovalStrategy() {
        return DEFAULT_MULTIPART_REMOVAL_STRATEGY;
    }

    public static boolean allowDoubleDotsInQueryString() {
        return ALLOW_DOUBLE_DOTS_IN_QUERY_STRING;
    }

    public static boolean allowSemicolonInPathComponent() {
        return ALLOW_SEMICOLON_IN_PATH_COMPONENT;
    }

    @UnstableApi
    public static Sampler<? super RequestContext> requestContextLeakDetectionSampler() {
        return REQUEST_CONTEXT_LEAK_DETECTION_SAMPLER;
    }

    @UnstableApi
    public static MeterRegistry meterRegistry() {
        return METER_REGISTRY;
    }

    @Deprecated
    public static long defaultUnhandledExceptionsReportIntervalMillis() {
        return DEFAULT_UNLOGGED_EXCEPTIONS_REPORT_INTERVAL_MILLIS;
    }

    @UnstableApi
    public static long defaultUnloggedExceptionsReportIntervalMillis() {
        return DEFAULT_UNLOGGED_EXCEPTIONS_REPORT_INTERVAL_MILLIS;
    }

    @UnstableApi
    public static DistributionStatisticConfig distributionStatisticConfig() {
        return DISTRIBUTION_STATISTIC_CONFIG;
    }

    @UnstableApi
    public static long defaultHttp1ConnectionCloseDelayMillis() {
        return DEFAULT_HTTP1_CONNECTION_CLOSE_DELAY_MILLIS;
    }

    @UnstableApi
    public static ResponseTimeoutMode responseTimeoutMode() {
        return RESPONSE_TIMEOUT_MODE;
    }

    @Nullable
    private static String nullableCaffeineSpec(Function<FlagsProvider, String> method, String flagName) {
        return Flags.caffeineSpec(method, flagName, true);
    }

    private static String nonnullCaffeineSpec(Function<FlagsProvider, String> method, String flagName) {
        String spec = Flags.caffeineSpec(method, flagName, false);
        assert (spec != null);
        return spec;
    }

    @Nullable
    private static String caffeineSpec(Function<FlagsProvider, String> method, String flagName, boolean allowOff) {
        String spec = Flags.getValue(method, flagName, value -> {
            try {
                if ("off".equals(value)) {
                    return allowOff;
                }
                CaffeineSpec.parse(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        if (!"off".equals(spec)) {
            return spec;
        }
        if (allowOff) {
            return null;
        }
        throw new Error();
    }

    private static ExceptionVerbosity exceptionLoggingMode(String name, String defaultValue) {
        String mode = Flags.getNormalized(name, defaultValue, value -> Arrays.stream(ExceptionVerbosity.values()).anyMatch(v -> v.name().equalsIgnoreCase((String)value)));
        return ExceptionVerbosity.valueOf(Ascii.toUpperCase(mode));
    }

    private static boolean getBoolean(String name, Boolean defaultValue, Predicate<Boolean> validator) {
        Predicate<String> combinedValidator = value -> {
            if ("true".equals(value)) {
                return validator.test(true);
            }
            if ("false".equals(value)) {
                return validator.test(false);
            }
            return false;
        };
        return Boolean.valueOf(Flags.getNormalized(name, defaultValue.toString(), combinedValidator));
    }

    private static String getNormalized(String name, String defaultValue, Predicate<String> validator) {
        String fullName = PREFIX + name;
        String value = System.getProperty(fullName);
        if (value != null) {
            value = Ascii.toLowerCase(value);
        }
        if (value != null) {
            if (validator.test(value)) {
                logger.info("{}: {} (sysprops)", (Object)name, (Object)value);
                return value;
            }
            logger.warn("{}: {} (sysprops, validation failed)", (Object)name, (Object)value);
        }
        logger.info("{}: {} (default)", (Object)name, (Object)defaultValue);
        return defaultValue;
    }

    private static <T> T getValue(Function<FlagsProvider, @Nullable T> method, String flagName) {
        return (T)Flags.getValue(method, flagName, unused -> true);
    }

    private static <T> T getValue(Function<FlagsProvider, @Nullable T> method, String flagName, Predicate<T> validator) {
        T t = Flags.getUserValue(method, flagName, validator);
        if (t != null) {
            return t;
        }
        return method.apply(DefaultFlagsProvider.INSTANCE);
    }

    @Nullable
    private static <T> T getUserValue(Function<FlagsProvider, @Nullable T> method, String flagName, Predicate<T> validator) {
        for (FlagsProvider provider : FLAGS_PROVIDERS) {
            try {
                T value = method.apply(provider);
                if (value == null) continue;
                if (!validator.test(value)) {
                    logger.warn("{}: {} ({}, validation failed)", new Object[]{flagName, value, provider.name()});
                    continue;
                }
                logger.info("{}: {} ({})", new Object[]{flagName, value, provider.name()});
                return value;
            }
            catch (Exception ex) {
                logger.warn("{}: ({}, {})", new Object[]{flagName, provider.name(), ex.getMessage()});
            }
        }
        return null;
    }

    private Flags() {
    }

    static {
        List flagsProviders = ImmutableList.copyOf(ServiceLoader.load(FlagsProvider.class, Flags.class.getClassLoader())).stream().sorted(Comparator.comparingInt(FlagsProvider::priority).reversed()).collect(Collectors.toList());
        flagsProviders.add(0, SystemPropertyFlagsProvider.INSTANCE);
        FLAGS_PROVIDERS = ImmutableList.copyOf(flagsProviders);
        VERBOSE_EXCEPTION_SAMPLER = Flags.getValue(FlagsProvider::verboseExceptionSampler, "verboseExceptionSampler");
        String strSpec = Flags.getNormalized("verboseExceptions", "rate-limit=10", val -> {
            try {
                Sampler.of(val);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        VERBOSE_EXCEPTION_SAMPLER_SPEC = "true".equals(strSpec) ? "always" : ("false".equals(strSpec) ? "never" : strSpec);
        Long intervalMillis = Flags.getUserValue(FlagsProvider::defaultUnloggedExceptionsReportIntervalMillis, "defaultUnloggedExceptionsReportIntervalMillis", value -> value >= 0L);
        DEFAULT_UNLOGGED_EXCEPTIONS_REPORT_INTERVAL_MILLIS = intervalMillis != null ? intervalMillis.longValue() : Flags.getValue(FlagsProvider::defaultUnhandledExceptionsReportIntervalMillis, "defaultUnhandledExceptionsReportIntervalMillis", value -> value >= 0L).longValue();
        PREFERRED_IP_V4_ADDRESSES = Flags.getValue(FlagsProvider::preferredIpV4Addresses, "preferredIpV4Addresses");
        VERBOSE_SOCKET_EXCEPTIONS = Flags.getValue(FlagsProvider::verboseSocketExceptions, "verboseSocketExceptions");
        VERBOSE_RESPONSES = Flags.getValue(FlagsProvider::verboseResponses, "verboseResponses");
        REQUEST_CONTEXT_STORAGE_PROVIDER = Flags.getValue(FlagsProvider::requestContextStorageProvider, "requestContextStorageProvider");
        WARN_NETTY_VERSIONS = Flags.getValue(FlagsProvider::warnNettyVersions, "warnNettyVersions");
        DEFAULT_USE_EPOLL = TransportType.EPOLL.isAvailable();
        USE_EPOLL = Flags.getBoolean("useEpoll", DEFAULT_USE_EPOLL, value -> TransportType.EPOLL.isAvailable() || value == false);
        TRANSPORT_TYPE_VALIDATOR = transportType -> {
            switch (transportType) {
                case IO_URING: {
                    return Flags.validateTransportType(TransportType.IO_URING, "io_uring");
                }
                case KQUEUE: {
                    return Flags.validateTransportType(TransportType.KQUEUE, "Kqueue");
                }
                case EPOLL: {
                    return Flags.validateTransportType(TransportType.EPOLL, "/dev/epoll");
                }
                case NIO: {
                    return true;
                }
            }
            return false;
        };
        TRANSPORT_TYPE = Flags.getValue(FlagsProvider::transportType, "transportType", TRANSPORT_TYPE_VALIDATOR);
        MAX_NUM_CONNECTIONS = Flags.getValue(FlagsProvider::maxNumConnections, "maxNumConnections", value -> value > 0);
        NUM_COMMON_WORKERS = Flags.getValue(provider -> provider.numCommonWorkers(TRANSPORT_TYPE), "numCommonWorkers", value -> value > 0);
        NUM_COMMON_BLOCKING_TASK_THREADS = Flags.getValue(FlagsProvider::numCommonBlockingTaskThreads, "numCommonBlockingTaskThreads", value -> value > 0);
        DEFAULT_MAX_REQUEST_LENGTH = Flags.getValue(FlagsProvider::defaultMaxRequestLength, "defaultMaxRequestLength", value -> value >= 0L);
        DEFAULT_MAX_RESPONSE_LENGTH = Flags.getValue(FlagsProvider::defaultMaxResponseLength, "defaultMaxResponseLength", value -> value >= 0L);
        DEFAULT_REQUEST_TIMEOUT_MILLIS = Flags.getValue(FlagsProvider::defaultRequestTimeoutMillis, "defaultRequestTimeoutMillis", value -> value >= 0L);
        DEFAULT_RESPONSE_TIMEOUT_MILLIS = Flags.getValue(FlagsProvider::defaultResponseTimeoutMillis, "defaultResponseTimeoutMillis", value -> value >= 0L);
        DEFAULT_CONNECT_TIMEOUT_MILLIS = Flags.getValue(FlagsProvider::defaultConnectTimeoutMillis, "defaultConnectTimeoutMillis", value -> value > 0L);
        DEFAULT_WRITE_TIMEOUT_MILLIS = Flags.getValue(FlagsProvider::defaultWriteTimeoutMillis, "defaultWriteTimeoutMillis", value -> value >= 0L);
        DEFAULT_SERVER_IDLE_TIMEOUT_MILLIS = Flags.getValue(FlagsProvider::defaultServerIdleTimeoutMillis, "defaultServerIdleTimeoutMillis", value -> value >= 0L);
        DEFAULT_SERVER_KEEP_ALIVE_ON_PING = Flags.getValue(FlagsProvider::defaultServerKeepAliveOnPing, "defaultServerKeepAliveOnPing");
        DEFAULT_CLIENT_IDLE_TIMEOUT_MILLIS = Flags.getValue(FlagsProvider::defaultClientIdleTimeoutMillis, "defaultClientIdleTimeoutMillis", value -> value >= 0L);
        DEFAULT_CLIENT_KEEP_ALIVE_ON_PING = Flags.getValue(FlagsProvider::defaultClientKeepAliveOnPing, "defaultClientKeepAliveOnPing");
        DEFAULT_PING_INTERVAL_MILLIS = Flags.getValue(FlagsProvider::defaultPingIntervalMillis, "defaultPingIntervalMillis", value -> value >= 0L);
        DEFAULT_MAX_SERVER_NUM_REQUESTS_PER_CONNECTION = Flags.getValue(FlagsProvider::defaultMaxServerNumRequestsPerConnection, "defaultMaxServerNumRequestsPerConnection", value -> value >= 0);
        DEFAULT_MAX_CLIENT_NUM_REQUESTS_PER_CONNECTION = Flags.getValue(FlagsProvider::defaultMaxClientNumRequestsPerConnection, "defaultMaxClientNumRequestsPerConnection", value -> value >= 0);
        DEFAULT_MAX_SERVER_CONNECTION_AGE_MILLIS = Flags.getValue(FlagsProvider::defaultMaxServerConnectionAgeMillis, "defaultMaxServerConnectionAgeMillis", value -> value >= 0L);
        DEFAULT_MAX_CLIENT_CONNECTION_AGE_MILLIS = Flags.getValue(FlagsProvider::defaultMaxClientConnectionAgeMillis, "defaultMaxClientConnectionAgeMillis", value -> value >= 0L);
        DEFAULT_SERVER_CONNECTION_DRAIN_DURATION_MICROS = Flags.getValue(FlagsProvider::defaultServerConnectionDrainDurationMicros, "defaultServerConnectionDrainDurationMicros", value -> value >= 0L);
        DEFAULT_CLIENT_HTTP2_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS = Flags.getValue(FlagsProvider::defaultClientHttp2GracefulShutdownTimeoutMillis, "defaultClientHttp2GracefulShutdownTimeoutMillis", value -> value >= 0L);
        DEFAULT_HTTP2_INITIAL_CONNECTION_WINDOW_SIZE = Flags.getValue(FlagsProvider::defaultHttp2InitialConnectionWindowSize, "defaultHttp2InitialConnectionWindowSize", value -> value > 0);
        DEFAULT_HTTP2_INITIAL_STREAM_WINDOW_SIZE = Flags.getValue(FlagsProvider::defaultHttp2InitialStreamWindowSize, "defaultHttp2InitialStreamWindowSize", value -> value > 0);
        DEFAULT_HTTP2_MAX_FRAME_SIZE = Flags.getValue(FlagsProvider::defaultHttp2MaxFrameSize, "defaultHttp2MaxFrameSize", value -> value >= 16384 && value <= 0xFFFFFF);
        DEFAULT_HTTP2_MAX_STREAMS_PER_CONNECTION = Flags.getValue(FlagsProvider::defaultHttp2MaxStreamsPerConnection, "defaultHttp2MaxStreamsPerConnection", value -> value > 0L && value <= 0xFFFFFFFFL);
        DEFAULT_HTTP2_MAX_HEADER_LIST_SIZE = Flags.getValue(FlagsProvider::defaultHttp2MaxHeaderListSize, "defaultHttp2MaxHeaderListSize", value -> value > 0L && value <= 0xFFFFFFFFL);
        DEFAULT_SERVER_HTTP2_MAX_RESET_FRAMES_PER_MINUTE = Flags.getValue(FlagsProvider::defaultServerHttp2MaxResetFramesPerMinute, "defaultServerHttp2MaxResetFramesPerMinute", value -> value >= 0);
        DEFAULT_MAX_HTTP1_INITIAL_LINE_LENGTH = Flags.getValue(FlagsProvider::defaultHttp1MaxInitialLineLength, "defaultHttp1MaxInitialLineLength", value -> value >= 0);
        DEFAULT_MAX_HTTP1_HEADER_SIZE = Flags.getValue(FlagsProvider::defaultHttp1MaxHeaderSize, "defaultHttp1MaxHeaderSize", value -> value >= 0);
        DEFAULT_HTTP1_MAX_CHUNK_SIZE = Flags.getValue(FlagsProvider::defaultHttp1MaxChunkSize, "defaultHttp1MaxChunkSize", value -> value >= 0);
        DEFAULT_USE_HTTP2_PREFACE = Flags.getValue(FlagsProvider::defaultUseHttp2Preface, "defaultUseHttp2Preface");
        DEFAULT_PREFER_HTTP1 = Flags.getValue(FlagsProvider::defaultPreferHttp1, "defaultPreferHttp1");
        DEFAULT_USE_HTTP2_WITHOUT_ALPN = Flags.getValue(FlagsProvider::defaultUseHttp2WithoutAlpn, "defaultUseHttp2WithoutAlpn");
        DEFAULT_USE_HTTP1_PIPELINING = Flags.getValue(FlagsProvider::defaultUseHttp1Pipelining, "defaultUseHttp1Pipelining");
        DEFAULT_BACKOFF_SPEC = Flags.getValue(FlagsProvider::defaultBackoffSpec, "defaultBackoffSpec", value -> {
            try {
                Backoff.of(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        DEFAULT_MAX_TOTAL_ATTEMPTS = Flags.getValue(FlagsProvider::defaultMaxTotalAttempts, "defaultMaxTotalAttempts", value -> value > 0);
        DEFAULT_REQUEST_AUTO_ABORT_DELAY_MILLIS = Flags.getValue(FlagsProvider::defaultRequestAutoAbortDelayMillis, "defaultRequestAutoAbortDelayMillis");
        ROUTE_CACHE_SPEC = Flags.nullableCaffeineSpec(FlagsProvider::routeCacheSpec, "routeCacheSpec");
        ROUTE_DECORATOR_CACHE_SPEC = Flags.nullableCaffeineSpec(FlagsProvider::routeDecoratorCacheSpec, "routeDecoratorCacheSpec");
        PARSED_PATH_CACHE_SPEC = Flags.nullableCaffeineSpec(FlagsProvider::parsedPathCacheSpec, "parsedPathCacheSpec");
        HEADER_VALUE_CACHE_SPEC = Flags.nullableCaffeineSpec(FlagsProvider::headerValueCacheSpec, "headerValueCacheSpec");
        CACHED_HEADERS = Flags.getValue(FlagsProvider::cachedHeaders, "cachedHeaders", list -> list.stream().allMatch(CharMatcher.ascii()::matchesAllOf));
        FILE_SERVICE_CACHE_SPEC = Flags.nullableCaffeineSpec(FlagsProvider::fileServiceCacheSpec, "fileServiceCacheSpec");
        DNS_CACHE_SPEC = Flags.nonnullCaffeineSpec(FlagsProvider::dnsCacheSpec, "dnsCacheSpec");
        ANNOTATED_SERVICE_EXCEPTION_VERBOSITY = Flags.exceptionLoggingMode("annotatedServiceExceptionVerbosity", DEFAULT_ANNOTATED_SERVICE_EXCEPTION_VERBOSITY);
        USE_JDK_DNS_RESOLVER = Flags.getValue(FlagsProvider::useJdkDnsResolver, "useJdkDnsResolver");
        REPORT_BLOCKED_EVENT_LOOP = Flags.getValue(FlagsProvider::reportBlockedEventLoop, "reportBlockedEventLoop");
        REPORT_MASKED_ROUTES = Flags.getValue(FlagsProvider::reportMaskedRoutes, "reportMaskedRoutes");
        VALIDATE_HEADERS = Flags.getValue(FlagsProvider::validateHeaders, "validateHeaders");
        TLS_ALLOW_UNSAFE_CIPHERS = Flags.getValue(FlagsProvider::tlsAllowUnsafeCiphers, "tlsAllowUnsafeCiphers");
        DEFAULT_MAX_CLIENT_HELLO_LENGTH = Flags.getValue(FlagsProvider::defaultMaxClientHelloLength, "defaultMaxClientHelloLength", value -> value >= 0 && value <= 0x1000000);
        TRANSIENT_SERVICE_OPTIONS = Flags.getValue(FlagsProvider::transientServiceOptions, "transientServiceOptions");
        USE_LEGACY_ROUTE_DECORATOR_ORDERING = Flags.getValue(FlagsProvider::useLegacyRouteDecoratorOrdering, "useLegacyRouteDecoratorOrdering");
        USE_DEFAULT_SOCKET_OPTIONS = Flags.getValue(FlagsProvider::useDefaultSocketOptions, "useDefaultSocketOptions");
        ALLOW_DOUBLE_DOTS_IN_QUERY_STRING = Flags.getValue(FlagsProvider::allowDoubleDotsInQueryString, "allowDoubleDotsInQueryString");
        ALLOW_SEMICOLON_IN_PATH_COMPONENT = Flags.getValue(FlagsProvider::allowSemicolonInPathComponent, "allowSemicolonInPathComponent");
        DEFAULT_MULTIPART_UPLOADS_LOCATION = Flags.getValue(FlagsProvider::defaultMultipartUploadsLocation, "defaultMultipartUploadsLocation");
        DEFAULT_MULTIPART_REMOVAL_STRATEGY = Flags.getValue(FlagsProvider::defaultMultipartRemovalStrategy, "defaultMultipartRemovalStrategy");
        REQUEST_CONTEXT_LEAK_DETECTION_SAMPLER = Flags.getValue(FlagsProvider::requestContextLeakDetectionSampler, "requestContextLeakDetectionSampler");
        METER_REGISTRY = Flags.getValue(FlagsProvider::meterRegistry, "meterRegistry");
        DISTRIBUTION_STATISTIC_CONFIG = Flags.getValue(FlagsProvider::distributionStatisticConfig, "distributionStatisticConfig");
        DEFAULT_HTTP1_CONNECTION_CLOSE_DELAY_MILLIS = Flags.getValue(FlagsProvider::defaultHttp1ConnectionCloseDelayMillis, "defaultHttp1ConnectionCloseDelayMillis", value -> value >= 0L);
        RESPONSE_TIMEOUT_MODE = Flags.getValue(FlagsProvider::responseTimeoutMode, "responseTimeoutMode");
        FlagsLoaded.set();
    }
}

