/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related.dublin;

import mil.nga.geopackage.extension.related.dublin.DublinCoreType;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;

public class DublinCoreMetadata {
    public static boolean hasColumn(UserTable<?> table, DublinCoreType type) {
        boolean hasColumn = table.hasColumn(type.getName());
        if (!hasColumn) {
            String synonym;
            String[] stringArray = type.getSynonyms();
            int n = stringArray.length;
            for (int i = 0; i < n && !(hasColumn = table.hasColumn(synonym = stringArray[i])); ++i) {
            }
        }
        return hasColumn;
    }

    public static boolean hasColumn(UserCoreRow<?, ?> row, DublinCoreType type) {
        return DublinCoreMetadata.hasColumn(row.getTable(), type);
    }

    public static <T extends UserColumn> T getColumn(UserTable<T> table, DublinCoreType type) {
        T column = null;
        if (table.hasColumn(type.getName())) {
            column = table.getColumn(type.getName());
        } else {
            for (String synonym : type.getSynonyms()) {
                if (!table.hasColumn(synonym)) continue;
                column = table.getColumn(synonym);
                break;
            }
        }
        return column;
    }

    public static <T extends UserColumn> T getColumn(UserCoreRow<T, ?> row, DublinCoreType type) {
        return DublinCoreMetadata.getColumn(row.getTable(), type);
    }

    public static Object getValue(UserCoreRow<?, ?> row, DublinCoreType type) {
        Object column = DublinCoreMetadata.getColumn(row, type);
        Object value = row.getValue(((UserColumn)column).getIndex());
        return value;
    }

    public static void setValue(UserCoreRow<?, ?> row, DublinCoreType type, Object value) {
        Object column = DublinCoreMetadata.getColumn(row, type);
        row.setValue(((UserColumn)column).getIndex(), value);
    }
}

