/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.baremaps.iploc.NicObject;

public class NicUtils {
    private NicUtils() {
    }

    public static boolean isInetnum(NicObject nicObject) {
        return "inetnum".equals(nicObject.type()) || "inet6num".equals(nicObject.type());
    }

    public static void writeToFile(Path path, NicObject nicObject) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        String fileName = nicObject.type() + "-" + nicObject.id() + ".txt";
        FileOutputStream fileOutputStream = new FileOutputStream(path + "/" + fileName);
        try (DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));){
            outStream.writeUTF(nicObject.toString());
        }
    }
}

