/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.reproject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.tiles.GeoPackageTile;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileCreator;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.reproject.TileReprojectionCore;
import mil.nga.geopackage.tiles.reproject.TileReprojectionOptimize;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.geopackage.user.UserCoreDao;
import mil.nga.proj.Projection;

public class TileReprojection
extends TileReprojectionCore {
    public static TileReprojection create(GeoPackage geoPackage, String table, Projection projection) {
        return TileReprojection.create(geoPackage, table, table, projection);
    }

    public static TileReprojection create(GeoPackage geoPackage, String table, String reprojectTable, Projection projection) {
        return TileReprojection.create(geoPackage, table, geoPackage, reprojectTable, projection);
    }

    public static TileReprojection create(GeoPackage geoPackage, String table, GeoPackage reprojectGeoPackage, String reprojectTable, Projection projection) {
        return TileReprojection.create(geoPackage.getTileDao(table), reprojectGeoPackage, reprojectTable, projection);
    }

    public static TileReprojection create(TileDao tileDao, GeoPackage geoPackage, String reprojectTable, Projection projection) {
        return new TileReprojection(tileDao, geoPackage, reprojectTable, projection);
    }

    public static TileReprojection create(GeoPackage geoPackage, String table, TileDao reprojectTileDao) {
        return TileReprojection.create(geoPackage.getTileDao(table), reprojectTileDao);
    }

    public static TileReprojection create(TileDao tileDao, TileDao reprojectTileDao) {
        return new TileReprojection(tileDao, reprojectTileDao);
    }

    public static TileReprojection create(GeoPackage geoPackage, String table, GeoPackage reprojectGeoPackage, TileDao reprojectTileDao) {
        return TileReprojection.create(geoPackage.getTileDao(table), reprojectGeoPackage, reprojectTileDao);
    }

    public static TileReprojection create(TileDao tileDao, GeoPackage reprojectGeoPackage, TileDao reprojectTileDao) {
        return new TileReprojection(tileDao, reprojectGeoPackage, reprojectTileDao);
    }

    public static TileReprojection create(GeoPackage geoPackage, String table, TileReprojectionOptimize optimize) {
        return TileReprojection.create(geoPackage, table, table, optimize);
    }

    public static TileReprojection create(GeoPackage geoPackage, String table, String reprojectTable, TileReprojectionOptimize optimize) {
        return TileReprojection.create(geoPackage, table, geoPackage, reprojectTable, optimize);
    }

    public static TileReprojection create(GeoPackage geoPackage, String table, GeoPackage reprojectGeoPackage, String reprojectTable, TileReprojectionOptimize optimize) {
        return TileReprojection.create(geoPackage.getTileDao(table), reprojectGeoPackage, reprojectTable, optimize);
    }

    public static TileReprojection create(TileDao tileDao, GeoPackage reprojectGeoPackage, String reprojectTable, TileReprojectionOptimize optimize) {
        TileReprojection tileReprojection = new TileReprojection(tileDao, reprojectGeoPackage, reprojectTable, optimize.getProjection());
        tileReprojection.setOptimize(optimize);
        return tileReprojection;
    }

    public static int reproject(GeoPackage geoPackage, String table, Projection projection) {
        return TileReprojection.create(geoPackage, table, projection).reproject();
    }

    public static int reproject(GeoPackage geoPackage, String table, String reprojectTable, Projection projection) {
        return TileReprojection.create(geoPackage, table, reprojectTable, projection).reproject();
    }

    public static int reproject(GeoPackage geoPackage, String table, GeoPackage reprojectGeoPackage, String reprojectTable, Projection projection) {
        return TileReprojection.create(geoPackage, table, reprojectGeoPackage, reprojectTable, projection).reproject();
    }

    public static int reproject(TileDao tileDao, GeoPackage reprojectGeoPackage, String reprojectTable, Projection projection) {
        return TileReprojection.create(tileDao, reprojectGeoPackage, reprojectTable, projection).reproject();
    }

    public static int reproject(GeoPackage geoPackage, String table, TileDao reprojectTileDao) {
        return TileReprojection.create(geoPackage, table, reprojectTileDao).reproject();
    }

    public static int reproject(TileDao tileDao, TileDao reprojectTileDao) {
        return TileReprojection.create(tileDao, reprojectTileDao).reproject();
    }

    public static int reproject(GeoPackage geoPackage, String table, GeoPackage reprojectGeoPackage, TileDao reprojectTileDao) {
        return TileReprojection.create(geoPackage, table, reprojectGeoPackage, reprojectTileDao).reproject();
    }

    public static int reproject(TileDao tileDao, GeoPackage reprojectGeoPackage, TileDao reprojectTileDao) {
        return TileReprojection.create(tileDao, reprojectGeoPackage, reprojectTileDao).reproject();
    }

    public static int reproject(GeoPackage geoPackage, String table, TileReprojectionOptimize optimize) {
        return TileReprojection.create(geoPackage, table, optimize).reproject();
    }

    public static int reproject(GeoPackage geoPackage, String table, String reprojectTable, TileReprojectionOptimize optimize) {
        return TileReprojection.create(geoPackage, table, reprojectTable, optimize).reproject();
    }

    public static int reproject(GeoPackage geoPackage, String table, GeoPackage reprojectGeoPackage, String reprojectTable, TileReprojectionOptimize optimize) {
        return TileReprojection.create(geoPackage, table, reprojectGeoPackage, reprojectTable, optimize).reproject();
    }

    public static int reproject(TileDao tileDao, GeoPackage reprojectGeoPackage, String reprojectTable, TileReprojectionOptimize optimize) {
        return TileReprojection.create(tileDao, reprojectGeoPackage, reprojectTable, optimize).reproject();
    }

    public TileReprojection(TileDao tileDao, GeoPackage geoPackage, String table, Projection projection) {
        super((UserCoreDao)tileDao, (GeoPackageCore)geoPackage, table, projection);
    }

    public TileReprojection(TileDao tileDao, TileDao reprojectTileDao) {
        super((UserCoreDao)tileDao, (UserCoreDao)reprojectTileDao);
    }

    public TileReprojection(TileDao tileDao, GeoPackage geoPackage, TileDao reprojectTileDao) {
        super((UserCoreDao)tileDao, (GeoPackageCore)geoPackage, (UserCoreDao)reprojectTileDao);
    }

    public TileDao getTileDao() {
        return (TileDao)this.tileDao;
    }

    public GeoPackage getGeoPackage() {
        return (GeoPackage)this.geoPackage;
    }

    public TileDao getReprojectTileDao() {
        return (TileDao)this.reprojectTileDao;
    }

    protected long getOptimizeZoom() {
        TileDao tileDao = this.getTileDao();
        return tileDao.getMapZoom(tileDao.getTileMatrixAtMinZoom());
    }

    protected TileDao createReprojectTileDao(String table) {
        return this.getGeoPackage().getTileDao(table);
    }

    public TileDao getTileDao(boolean reproject) {
        TileDao tileDao = null;
        tileDao = reproject ? this.getReprojectTileDao() : this.getTileDao();
        return tileDao;
    }

    protected TileMatrixSet getTileMatrixSet(boolean reproject) {
        return this.getTileDao(reproject).getTileMatrixSet();
    }

    protected List<TileMatrix> getTileMatrices(boolean reproject) {
        return this.getTileDao(reproject).getTileMatrices();
    }

    protected TileMatrix getTileMatrix(boolean reproject, long zoom) {
        return this.getTileDao(reproject).getTileMatrix(zoom);
    }

    protected void deleteTileMatrices(boolean reproject, String table) {
        try {
            this.getTileDao(reproject).getTileMatrixDao().deleteByTableName(table);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete tile matrices for tile table. GeoPackage: " + this.reprojectTileDao.getDatabase() + ", Tile Table: " + table, (Throwable)e);
        }
    }

    protected long getMapZoom(boolean reproject, TileMatrix tileMatrix) {
        return this.getTileDao(reproject).getMapZoom(tileMatrix);
    }

    protected void createTileMatrix(TileMatrix tileMatrix) {
        try {
            this.getReprojectTileDao().getTileMatrixDao().createOrUpdate((Object)tileMatrix);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create tile matrix. GeoPackage: " + this.reprojectTileDao.getDatabase() + ", Tile Table: " + tileMatrix.getTableName(), (Throwable)e);
        }
    }

    protected int reproject(long zoom, long toZoom, BoundingBox boundingBox, long matrixWidth, long matrixHeight, long tileWidth, long tileHeight) {
        int tiles = 0;
        TileDao tileDao = this.getTileDao();
        TileDao reprojectTileDao = this.getReprojectTileDao();
        double minLongitude = boundingBox.getMinLongitude();
        double maxLatitude = boundingBox.getMaxLatitude();
        double longitudeRange = boundingBox.getLongitudeRange();
        double latitudeRange = boundingBox.getLatitudeRange();
        BoundingBox zoomBounds = tileDao.getBoundingBox(zoom, reprojectTileDao.getProjection());
        TileGrid tileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)boundingBox, (long)matrixWidth, (long)matrixHeight, (BoundingBox)zoomBounds);
        TileCreator tileCreator = new TileCreator(tileDao, (int)tileWidth, (int)tileHeight, reprojectTileDao.getProjection(), "png");
        for (long tileRow = tileGrid.getMinY(); tileRow <= tileGrid.getMaxY(); ++tileRow) {
            double tileMaxLatitude = maxLatitude - (double)tileRow / (double)matrixHeight * latitudeRange;
            double tileMinLatitude = maxLatitude - (double)(tileRow + 1L) / (double)matrixHeight * latitudeRange;
            for (long tileColumn = tileGrid.getMinX(); this.isActive() && tileColumn <= tileGrid.getMaxX(); ++tileColumn) {
                boolean insert;
                double tileMinLongitude = minLongitude + (double)tileColumn / (double)matrixWidth * longitudeRange;
                double tileMaxLongitude = minLongitude + (double)(tileColumn + 1L) / (double)matrixWidth * longitudeRange;
                BoundingBox tileBounds = new BoundingBox(tileMinLongitude, tileMinLatitude, tileMaxLongitude, tileMaxLatitude);
                GeoPackageTile tile = tileCreator.getTile(tileBounds, zoom);
                if (tile == null) continue;
                TileRow row = reprojectTileDao.queryForTile(tileColumn, tileRow, toZoom);
                boolean bl = insert = row == null;
                if (insert) {
                    row = reprojectTileDao.newRow();
                    row.setTileColumn(tileColumn);
                    row.setTileRow(tileRow);
                    row.setZoomLevel(toZoom);
                }
                try {
                    row.setTileData(tile.getImage(), "png");
                }
                catch (IOException e) {
                    throw new GeoPackageException("Failed to set tile data from image. GeoPackage: " + reprojectTileDao.getDatabase() + ", Tile Table: " + reprojectTileDao.getTableName(), (Throwable)e);
                }
                if (insert) {
                    reprojectTileDao.insert(row);
                } else {
                    reprojectTileDao.update(row);
                }
                ++tiles;
                if (this.progress == null) continue;
                this.progress.addProgress(1);
            }
        }
        return tiles;
    }
}

