/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerBuilder;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerBuilderProvider;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerFactory;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoundRobinLoadBalancers {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinLoadBalancers.class);
    private static final List<RoundRobinLoadBalancerBuilderProvider> PROVIDERS;

    private RoundRobinLoadBalancers() {
    }

    private static <ResolvedAddress, C extends LoadBalancedConnection> RoundRobinLoadBalancerBuilder<ResolvedAddress, C> applyProviders(String id, RoundRobinLoadBalancerBuilder<ResolvedAddress, C> builder) {
        for (RoundRobinLoadBalancerBuilderProvider provider : PROVIDERS) {
            builder = provider.newBuilder(id, builder);
        }
        return builder;
    }

    public static <ResolvedAddress, C extends LoadBalancedConnection> RoundRobinLoadBalancerBuilder<ResolvedAddress, C> builder(String id) {
        return RoundRobinLoadBalancers.applyProviders(id, new RoundRobinLoadBalancerFactory.Builder(id));
    }

    static {
        ClassLoader classLoader = RoundRobinLoadBalancers.class.getClassLoader();
        PROVIDERS = ServiceLoaderUtils.loadProviders(RoundRobinLoadBalancerBuilderProvider.class, (ClassLoader)classLoader, (Logger)LOGGER);
    }
}

