/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.function.Supplier;

final class BeforeSubscriberSingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final Supplier<? extends SingleSource.Subscriber<? super T>> subscriberSupplier;

    BeforeSubscriberSingle(Single<T> original, Supplier<? extends SingleSource.Subscriber<? super T>> subscriberSupplier) {
        super(original);
        this.subscriberSupplier = Objects.requireNonNull(subscriberSupplier);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new BeforeSubscriberSingleSubscriber<T>(subscriber, this.subscriberSupplier.get());
    }

    private static final class BeforeSubscriberSingleSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> original;
        private final SingleSource.Subscriber<? super T> subscriber;

        BeforeSubscriberSingleSubscriber(SingleSource.Subscriber<? super T> original, SingleSource.Subscriber<? super T> subscriber) {
            this.original = original;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(cancellable);
            this.original.onSubscribe(cancellable);
        }

        public void onSuccess(T value) {
            try {
                this.subscriber.onSuccess(value);
            }
            catch (Throwable cause) {
                this.original.onError(cause);
                return;
            }
            this.original.onSuccess(value);
        }

        public void onError(Throwable t) {
            try {
                this.subscriber.onError(t);
            }
            catch (Throwable cause) {
                this.original.onError(ThrowableUtils.addSuppressed((Throwable)t, (Throwable)cause));
                return;
            }
            this.original.onError(t);
        }
    }
}

