/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.AbstractStreamingHttpConnection;
import io.servicetalk.http.netty.H2ParentConnectionContext;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.H2ToStH1ClientDuplexHandler;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.KeepAliveManager;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpClient;
import io.servicetalk.http.netty.NettyHttp2ExceptionUtils;
import io.servicetalk.http.netty.NonPipelinedStreamingHttpConnection;
import io.servicetalk.http.netty.ReservableRequestConcurrencyControllers;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.IoThreadFactory;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.ChannelSet;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyConnection;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import io.servicetalk.transport.netty.internal.NettyPipelineSslUtils;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class H2ClientParentConnectionContext
extends H2ParentConnectionContext {
    static final ConsumableEvent<Integer> DEFAULT_H2_MAX_CONCURRENCY_EVENT = new ReservableRequestConcurrencyControllers.IgnoreConsumedEvent<Integer>(100);

    private H2ClientParentConnectionContext(Channel channel, HttpExecutionContext executionContext, FlushStrategy flushStrategy, long idleTimeoutMs, @Nullable SslConfig sslConfig, KeepAliveManager keepAliveManager) {
        super(channel, executionContext, flushStrategy, idleTimeoutMs, sslConfig, keepAliveManager);
    }

    static Single<H2ClientParentConnection> initChannel(final Channel channel, final HttpExecutionContext executionContext, final H2ProtocolConfig config, final StreamingHttpRequestResponseFactory reqRespFactory, final FlushStrategy parentFlushStrategy, final long idleTimeoutMs, final @Nullable SslConfig sslConfig, final ChannelInitializer initializer, final ConnectionObserver observer, final boolean allowDropTrailersReadFromTransport) {
        return HttpDebugUtils.showPipeline(new SubscribableSingle<H2ClientParentConnection>(){

            protected void handleSubscribe(SingleSource.Subscriber<? super H2ClientParentConnection> subscriber) {
                DefaultH2ClientParentConnection parentChannelInitializer;
                ChannelPipeline pipeline;
                DelayedCancellable delayedCancellable;
                try {
                    delayedCancellable = new DelayedCancellable();
                    KeepAliveManager keepAliveManager = new KeepAliveManager(channel, config.keepAlivePolicy());
                    H2ClientParentConnectionContext connection = new H2ClientParentConnectionContext(channel, executionContext, parentFlushStrategy, idleTimeoutMs, sslConfig, keepAliveManager);
                    channel.attr(ChannelSet.CHANNEL_CLOSEABLE_KEY).set((Object)connection);
                    initializer.init(channel);
                    pipeline = channel.pipeline();
                    parentChannelInitializer = new DefaultH2ClientParentConnection(connection, subscriber, delayedCancellable, NettyPipelineSslUtils.isSslEnabled((ChannelPipeline)pipeline), allowDropTrailersReadFromTransport, config.headersFactory(), reqRespFactory, observer);
                }
                catch (Throwable cause) {
                    ChannelCloseUtils.close((Channel)channel, (Throwable)cause);
                    SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)cause);
                    return;
                }
                subscriber.onSubscribe((Cancellable)delayedCancellable);
                pipeline.addLast(new ChannelHandler[]{parentChannelInitializer});
            }
        }, (ConnectionInfo.Protocol)HttpProtocolVersion.HTTP_2_0, channel);
    }

    static final class StacklessCancellationException
    extends CancellationException {
        private static final long serialVersionUID = 3235852873427231209L;

        private StacklessCancellationException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        static StacklessCancellationException newInstance(String message, Class<?> clazz, String method) {
            return (StacklessCancellationException)io.servicetalk.concurrent.internal.ThrowableUtils.unknownStackTrace((Throwable)new StacklessCancellationException(message), clazz, (String)method);
        }
    }

    private static final class MaxConcurrencyConsumableEvent
    implements ConsumableEvent<Integer> {
        private static final AtomicIntegerFieldUpdater<MaxConcurrencyConsumableEvent> completedUpdater = AtomicIntegerFieldUpdater.newUpdater(MaxConcurrencyConsumableEvent.class, "completed");
        private volatile int completed;
        private final int maxConcurrentStreams;
        private final Channel channel;

        MaxConcurrencyConsumableEvent(int maxConcurrentStreams, Channel channel) {
            this.maxConcurrentStreams = maxConcurrentStreams;
            this.channel = channel;
        }

        public Integer event() {
            return this.maxConcurrentStreams;
        }

        public void eventConsumed() {
            if (completedUpdater.compareAndSet(this, 0, 1)) {
                this.channel.writeAndFlush((Object)Http2SettingsAckFrame.INSTANCE);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{maxConcurrentStreams=" + this.maxConcurrentStreams + ", completed=" + this.completed + '}';
        }
    }

    private static final class DefaultH2ClientParentConnection
    extends H2ParentConnectionContext.AbstractH2ParentConnection
    implements H2ClientParentConnection {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultH2ClientParentConnection.class);
        private final Http2StreamChannelBootstrap bs;
        private final HttpHeadersFactory headersFactory;
        private final StreamingHttpRequestResponseFactory reqRespFactory;
        private final PublisherSource.Processor<ConsumableEvent<Integer>, ConsumableEvent<Integer>> maxConcurrencyProcessor = Processors.newPublisherProcessorDropHeadOnOverflow((int)16);
        private final Publisher<ConsumableEvent<Integer>> maxConcurrencyPublisher;
        private final boolean allowDropTrailersReadFromTransport;
        @Nullable
        private SingleSource.Subscriber<? super H2ClientParentConnection> subscriber;
        private ConnectionObserver.MultiplexedObserver multiplexedObserver = NoopTransportObserver.NoopMultiplexedObserver.INSTANCE;

        DefaultH2ClientParentConnection(H2ClientParentConnectionContext connection, SingleSource.Subscriber<? super H2ClientParentConnection> subscriber, DelayedCancellable delayedCancellable, boolean waitForSslHandshake, boolean allowDropTrailersReadFromTransport, HttpHeadersFactory headersFactory, StreamingHttpRequestResponseFactory reqRespFactory, ConnectionObserver observer) {
            super(connection, delayedCancellable, waitForSslHandshake, observer);
            this.subscriber = Objects.requireNonNull(subscriber);
            this.headersFactory = Objects.requireNonNull(headersFactory);
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
            this.allowDropTrailersReadFromTransport = allowDropTrailersReadFromTransport;
            this.maxConcurrencyProcessor.onNext(DEFAULT_H2_MAX_CONCURRENCY_EVENT);
            this.bs = new Http2StreamChannelBootstrap(connection.channel());
            this.maxConcurrencyPublisher = SourceAdapters.fromSource(this.maxConcurrencyProcessor).multicast(1);
        }

        @Override
        boolean hasSubscriber() {
            return this.subscriber != null;
        }

        @Override
        void tryCompleteSubscriber() {
            if (this.subscriber != null) {
                SingleSource.Subscriber<? super H2ClientParentConnection> subscriberCopy = this.subscriber;
                this.subscriber = null;
                this.multiplexedObserver = this.observer.multiplexedConnectionEstablished((ConnectionInfo)this);
                subscriberCopy.onSuccess((Object)this);
            }
        }

        @Override
        void tryFailSubscriber(Throwable cause) {
            if (this.subscriber != null) {
                ChannelCloseUtils.close((Channel)this.parentContext.nettyChannel(), (Throwable)cause);
                SingleSource.Subscriber<? super H2ClientParentConnection> subscriberCopy = this.subscriber;
                this.subscriber = null;
                subscriberCopy.onError(cause);
            }
        }

        @Override
        boolean ackSettings(ChannelHandlerContext ctx, Http2SettingsFrame settingsFrame) {
            Long maxConcurrentStreams = settingsFrame.settings().maxConcurrentStreams();
            if (maxConcurrentStreams == null) {
                return true;
            }
            this.maxConcurrencyProcessor.onNext((Object)new MaxConcurrencyConsumableEvent(maxConcurrentStreams.intValue(), ctx.channel()));
            return false;
        }

        public HttpConnectionContext connectionContext() {
            return this.parentContext;
        }

        public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
            if (eventKey == AbstractStreamingHttpConnection.MAX_CONCURRENCY_NO_OFFLOADING) {
                return this.maxConcurrencyPublisher;
            }
            if (eventKey == HttpEventKey.MAX_CONCURRENCY) {
                return this.maxConcurrencyPublisher.publishOn((Executor)(this.executionContext().executionStrategy().isEventOffloaded() ? this.executionContext().executor() : Executors.immediate()), IoThreadFactory.IoThread::currentThreadIsIoThread);
            }
            return Publisher.failed((Throwable)new IllegalArgumentException("Unknown key: " + eventKey));
        }

        public Single<StreamingHttpResponse> request(final StreamingHttpRequest request) {
            return new SubscribableSingle<StreamingHttpResponse>(){

                protected void handleSubscribe(SingleSource.Subscriber<? super StreamingHttpResponse> subscriber) {
                    SequentialCancellable sequentialCancellable;
                    Promise promise;
                    ConnectionObserver.StreamObserver observer = multiplexedObserver.onNewStream();
                    LoadBalancedStreamingHttpClient.OnStreamClosedRunnable ownedRunnable = null;
                    try {
                        EventLoop e = parentContext.nettyChannel().eventLoop();
                        promise = e.newPromise();
                        LoadBalancedStreamingHttpClient.OnStreamClosedRunnable runnable = (LoadBalancedStreamingHttpClient.OnStreamClosedRunnable)request.context().get(LoadBalancedStreamingHttpClient.OnStreamClosedRunnable.KEY);
                        if (runnable != null) {
                            if (runnable.own()) {
                                ownedRunnable = runnable;
                            } else {
                                StacklessCancellationException cause = StacklessCancellationException.newInstance("The request was cancelled", ((Object)((Object)this)).getClass(), "handleSubscribe");
                                observer.streamClosed((Throwable)cause);
                                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)cause);
                                return;
                            }
                        }
                        bs.open(promise);
                        sequentialCancellable = new SequentialCancellable(() -> promise.cancel(true));
                    }
                    catch (Throwable cause) {
                        DefaultH2ClientParentConnection.cleanupWhenError(cause, observer, ownedRunnable);
                        SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)cause);
                        return;
                    }
                    try {
                        subscriber.onSubscribe((Cancellable)sequentialCancellable);
                    }
                    catch (Throwable cause) {
                        DefaultH2ClientParentConnection.cleanupErrorBeforeOpen(cause, (Promise<Http2StreamChannel>)promise, observer, ownedRunnable);
                        SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)cause);
                        return;
                    }
                    LoadBalancedStreamingHttpClient.OnStreamClosedRunnable onCloseRunnable = ownedRunnable;
                    if (promise.isDone()) {
                        this.childChannelActive((Future<Http2StreamChannel>)((Future)promise), (SingleSource.Subscriber<? super StreamingHttpResponse>)subscriber, sequentialCancellable, request, observer, allowDropTrailersReadFromTransport, onCloseRunnable);
                    } else {
                        promise.addListener((GenericFutureListener)((FutureListener)future -> this.childChannelActive((Future<Http2StreamChannel>)future, (SingleSource.Subscriber<? super StreamingHttpResponse>)subscriber, sequentialCancellable, request, observer, allowDropTrailersReadFromTransport, onCloseRunnable)));
                    }
                }
            };
        }

        private static void cleanupErrorBeforeOpen(Throwable cause, Promise<Http2StreamChannel> promise, ConnectionObserver.StreamObserver observer, @Nullable Runnable ownedRunnable) {
            promise.addListener((GenericFutureListener)((FutureListener)future -> {
                if (future.cause() == null) {
                    ((Http2StreamChannel)future.getNow()).close().addListener(__ -> DefaultH2ClientParentConnection.cleanupWhenError(cause, observer, ownedRunnable));
                } else {
                    DefaultH2ClientParentConnection.cleanupWhenError(cause, observer, ownedRunnable);
                }
            }));
        }

        private static void cleanupWhenError(Throwable cause, ConnectionObserver.StreamObserver observer, @Nullable Runnable ownedRunnable) {
            observer.streamClosed(cause);
            if (ownedRunnable != null) {
                ownedRunnable.run();
            }
        }

        private void childChannelActive(Future<Http2StreamChannel> future, final SingleSource.Subscriber<? super StreamingHttpResponse> subscriber, final SequentialCancellable sequentialCancellable, StreamingHttpRequest request, ConnectionObserver.StreamObserver streamObserver, boolean allowDropTrailersReadFromTransport, @Nullable Runnable onCloseRunnable) {
            Throwable futureCause = future.cause();
            if (futureCause == null) {
                SingleSource responseSingle;
                Http2StreamChannel streamChannel = null;
                try {
                    streamChannel = (Http2StreamChannel)future.getNow();
                    if (onCloseRunnable != null) {
                        streamChannel.closeFuture().addListener(f -> onCloseRunnable.run());
                    }
                    this.parentContext.trackActiveStream((Channel)streamChannel);
                    CloseHandler closeHandler = CloseHandler.forNonPipelined((boolean)true, (ChannelConfig)streamChannel.config());
                    streamChannel.pipeline().addLast(new ChannelHandler[]{new H2ToStH1ClientDuplexHandler(this.waitForSslHandshake, this.parentContext.executionContext().bufferAllocator(), this.headersFactory, closeHandler, streamObserver)});
                    DefaultNettyConnection nettyConnection = DefaultNettyConnection.initChildChannel((Channel)streamChannel, (ConnectionContext)this.parentContext, (CloseHandler)closeHandler, (FlushStrategy)this.parentContext.defaultFlushStrategy(), (long)this.parentContext.idleTimeoutMs, (ConnectionInfo.Protocol)HttpProtocolVersion.HTTP_2_0, (ChannelConfig)this.parentContext.nettyChannel().config(), (ConnectionObserver.StreamObserver)streamObserver, (boolean)true, HeaderUtils.OBJ_EXPECT_CONTINUE, NettyHttp2ExceptionUtils::wrapIfNecessary);
                    responseSingle = SourceAdapters.toSource(new NonPipelinedStreamingHttpConnection((NettyConnection<Object, Object>)nettyConnection, this.reqRespFactory, this.headersFactory, allowDropTrailersReadFromTransport).request(request));
                }
                catch (Throwable cause) {
                    if (streamChannel != null) {
                        try {
                            ChannelCloseUtils.close((Channel)streamChannel, (Throwable)cause);
                        }
                        catch (Throwable unexpected) {
                            ThrowableUtils.addSuppressed((Throwable)unexpected, (Throwable)cause);
                            LOGGER.warn("Unexpected exception while handling the original cause", unexpected);
                        }
                    } else {
                        DefaultH2ClientParentConnection.cleanupWhenError(cause, streamObserver, onCloseRunnable);
                    }
                    subscriber.onError(cause);
                    return;
                }
                responseSingle.subscribe((SingleSource.Subscriber)new SingleSource.Subscriber<StreamingHttpResponse>(){

                    public void onSubscribe(Cancellable cancellable) {
                        sequentialCancellable.nextCancellable(cancellable);
                    }

                    public void onSuccess(@Nullable StreamingHttpResponse result) {
                        subscriber.onSuccess((Object)result);
                    }

                    public void onError(Throwable t) {
                        subscriber.onError(t);
                    }
                });
            } else {
                DefaultH2ClientParentConnection.cleanupWhenError(futureCause, streamObserver, onCloseRunnable);
                subscriber.onError(futureCause);
            }
        }

        public SocketAddress localAddress() {
            return this.parentContext.localAddress();
        }

        public SocketAddress remoteAddress() {
            return this.parentContext.remoteAddress();
        }

        @Nullable
        public SslConfig sslConfig() {
            return this.parentContext.sslConfig();
        }

        @Nullable
        public SSLSession sslSession() {
            return this.parentContext.sslSession();
        }

        public HttpExecutionContext executionContext() {
            return this.parentContext.executionContext();
        }

        @Nullable
        public <T> T socketOption(SocketOption<T> option) {
            return this.parentContext.socketOption(option);
        }

        public HttpProtocolVersion protocol() {
            return this.parentContext.protocol();
        }

        @Nullable
        public ConnectionContext parent() {
            return this.parentContext.parent();
        }

        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        public Completable onClose() {
            return this.parentContext.onClose();
        }

        public Completable onClosing() {
            return this.parentContext.onClosing();
        }

        public Completable closeAsync() {
            return Completable.defer(() -> {
                this.maxConcurrencyProcessor.onNext(AbstractStreamingHttpConnection.ZERO_MAX_CONCURRENCY_EVENT);
                this.maxConcurrencyProcessor.onComplete();
                return this.parentContext.closeAsync().shareContextOnSubscribe();
            });
        }

        public Completable closeAsyncGracefully() {
            return Completable.defer(() -> {
                this.maxConcurrencyProcessor.onNext(AbstractStreamingHttpConnection.ZERO_MAX_CONCURRENCY_EVENT);
                this.maxConcurrencyProcessor.onComplete();
                return this.parentContext.closeAsyncGracefully().shareContextOnSubscribe();
            });
        }

        public Channel nettyChannel() {
            return this.parentContext.nettyChannel();
        }

        public String toString() {
            return this.parentContext.toString();
        }

        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }

        public Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
            return this.parentContext.updateFlushStrategy(strategyProvider);
        }

        public FlushStrategy defaultFlushStrategy() {
            return this.parentContext.defaultFlushStrategy();
        }

        public Single<Throwable> transportError() {
            return this.parentContext.transportError();
        }
    }

    static interface H2ClientParentConnection
    extends FilterableStreamingHttpConnection,
    NettyConnectionContext {
    }
}

