/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Singleton
@Path(value="/")
public class ClassPathResource {
    private final String directory;
    private final String index;

    @Inject
    public ClassPathResource(@Named(value="directory") String directory, @Named(value="index") String index) {
        this.directory = directory;
        this.index = index;
    }

    @GET
    @Path(value="{path:.*}")
    public Response get(@PathParam(value="path") String path) {
        Response response;
        block9: {
            if (((String)path).isEmpty() || ((String)path).endsWith("/")) {
                path = (String)path + this.index;
            }
            path = String.format("%s/%s", this.directory, path);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream((String)path);
            try {
                response = Response.ok().entity((Object)inputStream.readAllBytes()).build();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    return Response.status((int)404).build();
                }
            }
            inputStream.close();
        }
        return response;
    }
}

