/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.apache.baremaps.config.ConfigReader;
import org.jvnet.hk2.annotations.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/")
public class ChangeResource {
    private static final Logger logger = LoggerFactory.getLogger(ChangeResource.class);
    private final ConfigReader configReader = new ConfigReader();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final java.nio.file.Path tileset;
    private final java.nio.file.Path style;
    private final SseBroadcaster sseBroadcaster;
    private final OutboundSseEvent.Builder sseEventBuilder;

    @Inject
    public ChangeResource(@Named(value="tileset") @Optional java.nio.file.Path tileset, @Named(value="style") @Optional java.nio.file.Path style, Sse sse) {
        this.tileset = tileset;
        this.style = style;
        this.sseBroadcaster = sse.newBroadcaster();
        this.sseEventBuilder = sse.newEventBuilder();
        ChangeListener changeListener = new ChangeListener();
        new Thread(changeListener).start();
    }

    @GET
    @Path(value="changes")
    @Produces(value={"text/event-stream"})
    public void changes(@Context SseEventSink sseEventSink) {
        this.sseBroadcaster.register(sseEventSink);
    }

    class ChangeListener
    implements Runnable {
        ChangeListener() {
        }

        @Override
        public void run() {
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                WatchKey key;
                if (ChangeResource.this.tileset != null && Files.exists(ChangeResource.this.tileset, new LinkOption[0])) {
                    ChangeResource.this.tileset.toAbsolutePath().getParent().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                if (ChangeResource.this.style != null && Files.exists(ChangeResource.this.style, new LinkOption[0])) {
                    ChangeResource.this.style.toAbsolutePath().getParent().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                while ((key = watchService.take()) != null) {
                    java.nio.file.Path dir = (java.nio.file.Path)key.watchable();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        java.nio.file.Path path = dir.resolve((java.nio.file.Path)event.context()).toAbsolutePath();
                        logger.info("Change detected in {}", (Object)path);
                        if (ChangeResource.this.style == null) continue;
                        String value = ChangeResource.this.configReader.read(ChangeResource.this.style);
                        ObjectNode styleObjectNode = (ObjectNode)ChangeResource.this.objectMapper.readValue(value, ObjectNode.class);
                        if (ChangeResource.this.tileset != null && path.endsWith(ChangeResource.this.tileset.getFileName())) {
                            styleObjectNode.put("reload", true);
                        }
                        ChangeResource.this.sseBroadcaster.broadcast(ChangeResource.this.sseEventBuilder.data((Object)styleObjectNode.toString()).build());
                    }
                    key.reset();
                }
            }
            catch (IOException | InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }
}

