/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.TileMatrix;
import org.apache.baremaps.ogcapi.model.TileSetBoundingBox;
import org.apache.baremaps.ogcapi.model.TileSetCrs;

@ApiModel(description="A definition of a tile matrix set following the Tile Matrix Set standard. For tileSet metadata, such a description (in `tileMatrixSet` property) is only required for offline use, as an alternative to a link with a `http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme` relation type.")
@JsonTypeName(value="tileMatrixSet")
public class TileMatrixSet {
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private List<String> keywords = null;
    @Valid
    private String id;
    @Valid
    private URI uri;
    @Valid
    private List<String> orderedAxes = null;
    @Valid
    private TileSetCrs crs;
    @Valid
    private URI wellKnownScaleSet;
    @Valid
    private TileSetBoundingBox boundingBox;
    @Valid
    private List<TileMatrix> tileMatrices = new ArrayList<TileMatrix>();

    public TileMatrixSet title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Title of this tile matrix set, normally used for display to a human")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public TileMatrixSet description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Brief narrative description of this tile matrix set, normally available for display to a human")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TileMatrixSet keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    @ApiModelProperty(value="Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this tile matrix set")
    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public TileMatrixSet addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    public TileMatrixSet removeKeywordsItem(String keywordsItem) {
        if (keywordsItem != null && this.keywords != null) {
            this.keywords.remove(keywordsItem);
        }
        return this;
    }

    public TileMatrixSet id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Tile matrix set identifier. Implementation of 'identifier'")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public TileMatrixSet uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="Reference to an official source for this tileMatrixSet")
    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    public void setUri(URI uri) {
        this.uri = uri;
    }

    public TileMatrixSet orderedAxes(List<String> orderedAxes) {
        this.orderedAxes = orderedAxes;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="orderedAxes")
    @Size(min=1)
    public @Size(min=1) List<String> getOrderedAxes() {
        return this.orderedAxes;
    }

    @JsonProperty(value="orderedAxes")
    public void setOrderedAxes(List<String> orderedAxes) {
        this.orderedAxes = orderedAxes;
    }

    public TileMatrixSet addOrderedAxesItem(String orderedAxesItem) {
        if (this.orderedAxes == null) {
            this.orderedAxes = new ArrayList<String>();
        }
        this.orderedAxes.add(orderedAxesItem);
        return this;
    }

    public TileMatrixSet removeOrderedAxesItem(String orderedAxesItem) {
        if (orderedAxesItem != null && this.orderedAxes != null) {
            this.orderedAxes.remove(orderedAxesItem);
        }
        return this;
    }

    public TileMatrixSet crs(TileSetCrs crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="crs")
    @NotNull
    public TileSetCrs getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(TileSetCrs crs) {
        this.crs = crs;
    }

    public TileMatrixSet wellKnownScaleSet(URI wellKnownScaleSet) {
        this.wellKnownScaleSet = wellKnownScaleSet;
        return this;
    }

    @ApiModelProperty(value="Reference to a well-known scale set")
    @JsonProperty(value="wellKnownScaleSet")
    public URI getWellKnownScaleSet() {
        return this.wellKnownScaleSet;
    }

    @JsonProperty(value="wellKnownScaleSet")
    public void setWellKnownScaleSet(URI wellKnownScaleSet) {
        this.wellKnownScaleSet = wellKnownScaleSet;
    }

    public TileMatrixSet boundingBox(TileSetBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="boundingBox")
    public TileSetBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @JsonProperty(value="boundingBox")
    public void setBoundingBox(TileSetBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public TileMatrixSet tileMatrices(List<TileMatrix> tileMatrices) {
        this.tileMatrices = tileMatrices;
        return this;
    }

    @ApiModelProperty(required=true, value="Describes scale levels and its tile matrices")
    @JsonProperty(value="tileMatrices")
    @NotNull
    public List<TileMatrix> getTileMatrices() {
        return this.tileMatrices;
    }

    @JsonProperty(value="tileMatrices")
    public void setTileMatrices(List<TileMatrix> tileMatrices) {
        this.tileMatrices = tileMatrices;
    }

    public TileMatrixSet addTileMatricesItem(TileMatrix tileMatricesItem) {
        if (this.tileMatrices == null) {
            this.tileMatrices = new ArrayList<TileMatrix>();
        }
        this.tileMatrices.add(tileMatricesItem);
        return this;
    }

    public TileMatrixSet removeTileMatricesItem(TileMatrix tileMatricesItem) {
        if (tileMatricesItem != null && this.tileMatrices != null) {
            this.tileMatrices.remove(tileMatricesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileMatrixSet tileMatrixSet = (TileMatrixSet)o;
        return Objects.equals(this.title, tileMatrixSet.title) && Objects.equals(this.description, tileMatrixSet.description) && Objects.equals(this.keywords, tileMatrixSet.keywords) && Objects.equals(this.id, tileMatrixSet.id) && Objects.equals(this.uri, tileMatrixSet.uri) && Objects.equals(this.orderedAxes, tileMatrixSet.orderedAxes) && Objects.equals(this.crs, tileMatrixSet.crs) && Objects.equals(this.wellKnownScaleSet, tileMatrixSet.wellKnownScaleSet) && Objects.equals(this.boundingBox, tileMatrixSet.boundingBox) && Objects.equals(this.tileMatrices, tileMatrixSet.tileMatrices);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.keywords, this.id, this.uri, this.orderedAxes, this.crs, this.wellKnownScaleSet, this.boundingBox, this.tileMatrices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TileMatrixSet {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    orderedAxes: ").append(this.toIndentedString(this.orderedAxes)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    wellKnownScaleSet: ").append(this.toIndentedString(this.wellKnownScaleSet)).append("\n");
        sb.append("    boundingBox: ").append(this.toIndentedString(this.boundingBox)).append("\n");
        sb.append("    tileMatrices: ").append(this.toIndentedString(this.tileMatrices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

