/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.LayersArray;
import org.apache.baremaps.ogcapi.model.MbStyleSources;

@JsonTypeName(value="mb-style")
public class MbStyle {
    @Valid
    private BigDecimal version;
    @Valid
    private String name;
    @Valid
    private MbStyleSources sources;
    @Valid
    private String sprite;
    @Valid
    private String glyphs;
    @Valid
    private List<LayersArray> layers = new ArrayList<LayersArray>();

    public MbStyle version(BigDecimal version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="version")
    @NotNull
    public BigDecimal getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    public MbStyle name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public MbStyle sources(MbStyleSources sources) {
        this.sources = sources;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sources")
    @NotNull
    public MbStyleSources getSources() {
        return this.sources;
    }

    @JsonProperty(value="sources")
    public void setSources(MbStyleSources sources) {
        this.sources = sources;
    }

    public MbStyle sprite(String sprite) {
        this.sprite = sprite;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="sprite")
    public String getSprite() {
        return this.sprite;
    }

    @JsonProperty(value="sprite")
    public void setSprite(String sprite) {
        this.sprite = sprite;
    }

    public MbStyle glyphs(String glyphs) {
        this.glyphs = glyphs;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="glyphs")
    public String getGlyphs() {
        return this.glyphs;
    }

    @JsonProperty(value="glyphs")
    public void setGlyphs(String glyphs) {
        this.glyphs = glyphs;
    }

    public MbStyle layers(List<LayersArray> layers) {
        this.layers = layers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="layers")
    @NotNull
    public List<LayersArray> getLayers() {
        return this.layers;
    }

    @JsonProperty(value="layers")
    public void setLayers(List<LayersArray> layers) {
        this.layers = layers;
    }

    public MbStyle addLayersItem(LayersArray layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<LayersArray>();
        }
        this.layers.add(layersItem);
        return this;
    }

    public MbStyle removeLayersItem(LayersArray layersItem) {
        if (layersItem != null && this.layers != null) {
            this.layers.remove(layersItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MbStyle mbStyle = (MbStyle)o;
        return Objects.equals(this.version, mbStyle.version) && Objects.equals(this.name, mbStyle.name) && Objects.equals(this.sources, mbStyle.sources) && Objects.equals(this.sprite, mbStyle.sprite) && Objects.equals(this.glyphs, mbStyle.glyphs) && Objects.equals(this.layers, mbStyle.layers);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.name, this.sources, this.sprite, this.glyphs, this.layers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MbStyle {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    sprite: ").append(this.toIndentedString(this.sprite)).append("\n");
        sb.append("    glyphs: ").append(this.toIndentedString(this.glyphs)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

