/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.stream.ProgressLogger;
import org.apache.baremaps.stream.StreamUtils;
import org.apache.baremaps.tilestore.TileChannel;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.tilestore.file.FileTileStore;
import org.apache.baremaps.tilestore.mbtiles.MBTilesStore;
import org.apache.baremaps.tilestore.postgres.PostgresTileStore;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.utils.SqliteUtils;
import org.apache.baremaps.vectortile.tileset.Tileset;
import org.apache.baremaps.vectortile.tileset.TilesetQuery;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ExportVectorTiles(Path tileset, Path repository, int batchArraySize, int batchArrayIndex, Format format) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ExportVectorTiles.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        ConfigReader configReader = new ConfigReader();
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        Tileset tileset = (Tileset)objectMapper.readValue(configReader.read(this.tileset), Tileset.class);
        DataSource datasource = context.getDataSource(tileset.getDatabase());
        TileStore sourceTileStore = this.sourceTileStore(tileset, datasource);
        TileStore targetTileStore = this.targetTileStore(tileset);
        Envelope envelope = tileset.getBounds().size() == 4 ? new Envelope(tileset.getBounds().get(0).doubleValue(), tileset.getBounds().get(2).doubleValue(), tileset.getBounds().get(1).doubleValue(), tileset.getBounds().get(3).doubleValue()) : new Envelope(-180.0, 180.0, -85.0511, 85.0511);
        long count = TileCoord.count(envelope, tileset.getMinzoom(), tileset.getMaxzoom());
        Stream<TileCoord> stream = StreamUtils.stream(TileCoord.iterator(envelope, tileset.getMinzoom(), tileset.getMaxzoom())).peek(new ProgressLogger(count, 5000));
        StreamUtils.batch(stream).forEach(new TileChannel(sourceTileStore, targetTileStore));
    }

    private TileStore sourceTileStore(Tileset tileset, DataSource datasource) {
        return new PostgresTileStore(datasource, tileset);
    }

    private TileStore targetTileStore(Tileset source) throws TileStoreException, IOException {
        switch (this.format) {
            case file: {
                return new FileTileStore(this.repository);
            }
            case mbtiles: {
                Files.deleteIfExists(this.repository);
                DataSource dataSource = SqliteUtils.createDataSource(this.repository, false);
                MBTilesStore tilesStore = new MBTilesStore(dataSource);
                tilesStore.initializeDatabase();
                tilesStore.writeMetadata(this.metadata(source));
                return tilesStore;
            }
        }
        throw new IllegalArgumentException("Unsupported format");
    }

    private Map<String, String> metadata(Tileset tileset) throws JsonProcessingException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", tileset.getName());
        metadata.put("version", tileset.getVersion());
        metadata.put("description", tileset.getDescription());
        metadata.put("attribution", tileset.getAttribution());
        metadata.put("type", "baselayer");
        metadata.put("format", "pbf");
        metadata.put("center", tileset.getCenter().stream().map(Object::toString).collect(Collectors.joining(", ")));
        metadata.put("bounds", tileset.getBounds().stream().map(Object::toString).collect(Collectors.joining(", ")));
        metadata.put("minzoom", Double.toString(tileset.getMinzoom().intValue()));
        metadata.put("maxzoom", Double.toString(tileset.getMaxzoom().intValue()));
        List<Map> layers = tileset.getVectorLayers().stream().map(layer -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", layer.getId());
            map.put("description", layer.getDescription());
            map.put("minzoom", layer.getQueries().stream().mapToInt(TilesetQuery::getMinzoom).min().getAsInt());
            map.put("maxzoom", layer.getQueries().stream().mapToInt(TilesetQuery::getMaxzoom).max().getAsInt());
            return map;
        }).toList();
        metadata.put("json", new ObjectMapper().writeValueAsString(layers));
        return metadata;
    }

    public static enum Format {
        file,
        mbtiles;

    }
}

