/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class PointDataType
implements DataType<Point> {
    private final GeometryFactory geometryFactory;

    public PointDataType() {
        this(new GeometryFactory());
    }

    public PointDataType(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    @Override
    public int size(Point value) {
        return 16;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return 16;
    }

    @Override
    public void write(ByteBuffer buffer, int position, Point value) {
        if (value.isEmpty()) {
            buffer.putDouble(position, Double.NaN);
            buffer.putDouble(position + 8, Double.NaN);
        } else {
            buffer.putDouble(position, value.getX());
            buffer.putDouble(position + 8, value.getY());
        }
    }

    @Override
    public Point read(ByteBuffer buffer, int position) {
        double x = buffer.getDouble(position);
        double y = buffer.getDouble(position + 8);
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return this.geometryFactory.createPoint();
        }
        return this.geometryFactory.createPoint(new Coordinate(x, y));
    }
}

