/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.schema;

import java.util.List;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowType;

public record DataRowImpl(DataRowType rowType, List values) implements DataRow
{
    @Override
    public Object get(String column) {
        List<DataColumn> columns = this.rowType.columns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).name().equals(column)) continue;
            return this.values.get(i);
        }
        throw new IllegalArgumentException("Column " + column + " not found.");
    }

    @Override
    public Object get(int index) {
        return this.values.get(index);
    }

    @Override
    public void set(String column, Object value) {
        for (int i = 0; i < this.rowType.columns().size(); ++i) {
            if (!this.rowType.columns().get(i).name().equals(column)) continue;
            this.values.set(i, value);
            return;
        }
        throw new IllegalArgumentException("Column " + column + " not found.");
    }

    @Override
    public void set(int index, Object value) {
        this.values.set(index, value);
    }
}

