package org.apache.baremaps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.baremaps.model.ExtentSpatial;
import org.apache.baremaps.model.ExtentTemporal;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The extent of the resources in the collection. Only spatial and temporal extents are specified. Additional API standards may add members to represent other extents, for example, thermal or pressure ranges.
 **/
@ApiModel(description = "The extent of the resources in the collection. Only spatial and temporal extents are specified. Additional API standards may add members to represent other extents, for example, thermal or pressure ranges.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public class Extent   {
  
  private @Valid ExtentSpatial spatial;
  private @Valid ExtentTemporal temporal;

  /**
   **/
  public Extent spatial(ExtentSpatial spatial) {
    this.spatial = spatial;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("spatial")
  public ExtentSpatial getSpatial() {
    return spatial;
  }

  public void setSpatial(ExtentSpatial spatial) {
    this.spatial = spatial;
  }/**
   **/
  public Extent temporal(ExtentTemporal temporal) {
    this.temporal = temporal;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("temporal")
  public ExtentTemporal getTemporal() {
    return temporal;
  }

  public void setTemporal(ExtentTemporal temporal) {
    this.temporal = temporal;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Extent extent = (Extent) o;
    return Objects.equals(this.spatial, extent.spatial) &&
        Objects.equals(this.temporal, extent.temporal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(spatial, temporal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Extent {\n");
    
    sb.append("    spatial: ").append(toIndentedString(spatial)).append("\n");
    sb.append("    temporal: ").append(toIndentedString(temporal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

