package org.apache.baremaps.api;

import org.apache.baremaps.model.Collection;
import org.apache.baremaps.model.Collections;
import org.apache.baremaps.model.Exception;
import java.util.UUID;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/collections")
@Api(description = "the collections API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public interface CollectionsApi {

    @POST
    @Consumes({ "application/json" })
    @ApiOperation(value = "adds a new collection", notes = "Adds a collection to the collection repository.  In case, a new collection is created, the following rules apply.  If the collection submitted in the request body includes an identifier, that identifier will be used. If a collection with that identifier already exists, an error is returned.  If no identifier can be determined from the submitted collection, the server will assign a new identifier to the collection.  The URI of the new collection is returned in the header `Location`.", tags={ "Collections" })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "collection created", response = Void.class),
        @ApiResponse(code = 409, message = "a collection with that id already exists", response = Void.class) })
    Response addCollection(@Valid Collection collection);

    @DELETE
    @Path("/{collectionId}")
    @ApiOperation(value = "delete a collection", notes = "Delete an existing collection with the id `collectionId`. If no such style exists, an error is returned.  Deletes any data/itmes associated to this collection.", tags={ "Collections" })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "collection deleted", response = Void.class),
        @ApiResponse(code = 404, message = "collection not found", response = Void.class) })
    Response deleteCollection(@PathParam("collectionId") @ApiParam("local identifier of a collection") UUID collectionId);

    @GET
    @Path("/{collectionId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "fetch a collection by id", notes = "Fetches the collection with identifier `collectionId`. The set of available collections can be retrieved at `/collections`.", tags={ "Collections" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The style", response = Collection.class),
        @ApiResponse(code = 404, message = "collection not found", response = Void.class) })
    Response getCollection(@PathParam("collectionId") @ApiParam("local identifier of a collection") UUID collectionId);

    @GET
    @Produces({ "application/json" })
    @ApiOperation(value = "the collections in the dataset", notes = "A list of all collections available in this dataset.", tags={ "Collections" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The collections (geospatial data resources) shared by this API. This response can be references directly for every service that wants only essential information at the collections level. /collections/collectionId might return more information. The dataset is organized as one or more collections. This resource provides information about and how to access the collections. The response contains the list of collections. For each collection, a link to other resources present (e.g. the items in the collection, path `/collections/{collectionId}/items`, link relation `items`, a map created with data from  collection, path `/collections/{collectionId}/map`, link relation `map`) as well as key information about the collection. This information includes, but is not limited to: * A local identifier for the collection that is unique for the dataset; * A list of coordinate reference systems (CRS) in which geometries may be returned by the server. The first CRS is the default coordinate reference system (the default is always WGS84 with axis order longitude/latitude); * An optional title and description for the collection; * An optional extent that can be used to provide an indication of the spatial and temporal extent of the collection - typically derived from the data;", response = Collections.class),
        @ApiResponse(code = 500, message = "A server error occurred", response = Exception.class) })
    Response getCollections();

    @PUT
    @Path("/{collectionId}")
    @Consumes({ "application/json" })
    @ApiOperation(value = "replace a collection or add a new collection", notes = "Replace an existing collection with the id `collectionId`. If no such collection exists, a new collection with that id is added.", tags={ "Collections" })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "collection updated or created successfully", response = Void.class) })
    Response updateCollection(@PathParam("collectionId") @ApiParam("local identifier of a collection") UUID collectionId,@Valid Collection collection);
}
