/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.LineString;
import mil.nga.sf.geojson.GeometryType;
import mil.nga.sf.geojson.Position;

public class MultiLineString
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 2L;
    private List<mil.nga.sf.geojson.LineString> lineStrings = null;

    public static MultiLineString fromCoordinates(List<List<Position>> coordinates) {
        MultiLineString multiLineString = new MultiLineString();
        multiLineString.setCoordinates(coordinates);
        return multiLineString;
    }

    public MultiLineString() {
    }

    public MultiLineString(List<mil.nga.sf.geojson.LineString> lineStrings) {
        this.lineStrings = lineStrings;
    }

    public MultiLineString(mil.nga.sf.MultiLineString multiLineString) {
        this.setMultiLineString(multiLineString);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.MULTILINESTRING;
    }

    @Override
    public Geometry getGeometry() {
        return this.getMultiLineString();
    }

    public List<List<Position>> getCoordinates() {
        ArrayList<List<Position>> coordinates = new ArrayList<List<Position>>();
        for (mil.nga.sf.geojson.LineString lineString : this.lineStrings) {
            coordinates.add(lineString.getCoordinates());
        }
        return coordinates;
    }

    public void setCoordinates(List<List<Position>> coordinates) {
        this.lineStrings = new ArrayList<mil.nga.sf.geojson.LineString>();
        for (List<Position> positions : coordinates) {
            this.lineStrings.add(mil.nga.sf.geojson.LineString.fromCoordinates(positions));
        }
    }

    @JsonIgnore
    public List<mil.nga.sf.geojson.LineString> getLineStrings() {
        return this.lineStrings;
    }

    public void setLineStrings(List<mil.nga.sf.geojson.LineString> lineStrings) {
        this.lineStrings = lineStrings;
    }

    @JsonIgnore
    public mil.nga.sf.MultiLineString getMultiLineString() {
        ArrayList<LineString> simpleLineStrings = new ArrayList<LineString>();
        for (mil.nga.sf.geojson.LineString lineString : this.lineStrings) {
            simpleLineStrings.add(lineString.getLineString());
        }
        return new mil.nga.sf.MultiLineString(simpleLineStrings);
    }

    public void setMultiLineString(mil.nga.sf.MultiLineString multiLineString) {
        this.lineStrings = new ArrayList<mil.nga.sf.geojson.LineString>();
        for (LineString lineString : multiLineString.getLineStrings()) {
            this.lineStrings.add(new mil.nga.sf.geojson.LineString(lineString));
        }
    }
}

