/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractAsynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class PublisherConcatWithCompletable<T>
extends AbstractAsynchronousPublisherOperator<T, T> {
    private final Completable next;

    PublisherConcatWithCompletable(Publisher<T> original, Completable next) {
        super(original);
        this.next = Objects.requireNonNull(next);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new ConcatSubscriber<T>(subscriber, this.next);
    }

    private static final class ConcatSubscriber<T>
    implements CompletableSource.Subscriber,
    PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final Cancellable CANCELLED = () -> {};
        private static final AtomicReferenceFieldUpdater<ConcatSubscriber, Cancellable> cancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcatSubscriber.class, Cancellable.class, "cancellable");
        private final PublisherSource.Subscriber<? super T> target;
        private final Completable next;
        private boolean nextSubscribed;
        private volatile Cancellable cancellable = IGNORE_CANCEL;

        ConcatSubscriber(PublisherSource.Subscriber<? super T> target, Completable next) {
            this.target = target;
            this.next = next;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            this.cancellable = s;
            this.target.onSubscribe((PublisherSource.Subscription)this);
        }

        public void onNext(T t) {
            this.target.onNext(t);
        }

        public void onError(Throwable t) {
            this.target.onError(t);
        }

        public void onSubscribe(Cancellable cancellable) {
            Cancellable c;
            do {
                if ((c = this.cancellable) != CANCELLED) continue;
                cancellable.cancel();
                break;
            } while (!cancellableUpdater.compareAndSet(this, c, cancellable));
        }

        public void onComplete() {
            if (this.nextSubscribed) {
                this.target.onComplete();
            } else {
                this.nextSubscribed = true;
                this.next.subscribeInternal(this);
            }
        }

        public void request(long n) {
            Cancellable currCancellable = this.cancellable;
            if (currCancellable instanceof PublisherSource.Subscription) {
                ((PublisherSource.Subscription)currCancellable).request(n);
            }
        }

        public void cancel() {
            cancellableUpdater.getAndSet(this, CANCELLED).cancel();
        }
    }
}

