/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.client.api.RequestConcurrencyController;
import io.servicetalk.client.api.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.LatestValueSubscriber;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ReservableRequestConcurrencyControllers {
    private ReservableRequestConcurrencyControllers() {
    }

    static ReservableRequestConcurrencyController newController(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing, int initialMaxConcurrency) {
        return new ReservableRequestConcurrencyControllerMulti(maxConcurrency, onClosing, initialMaxConcurrency);
    }

    private static final class ReservableRequestConcurrencyControllerMulti
    extends AbstractReservableRequestConcurrencyController {
        private final int maxRequests;

        ReservableRequestConcurrencyControllerMulti(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing, int maxRequests) {
            super(maxConcurrency, onClosing);
            this.maxRequests = maxRequests;
        }

        public RequestConcurrencyController.Result tryRequest() {
            int currentPending;
            int maxConcurrency = this.lastSeenMaxValue(this.maxRequests);
            do {
                if ((currentPending = this.pendingRequests()) < 0) {
                    return RequestConcurrencyController.Result.RejectedPermanently;
                }
                if (currentPending < maxConcurrency) continue;
                return RequestConcurrencyController.Result.RejectedTemporary;
            } while (!this.casPendingRequests(currentPending, currentPending + 1));
            return RequestConcurrencyController.Result.Accepted;
        }
    }

    private static abstract class AbstractReservableRequestConcurrencyController
    implements ReservableRequestConcurrencyController {
        private static final AtomicIntegerFieldUpdater<AbstractReservableRequestConcurrencyController> pendingRequestsUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReservableRequestConcurrencyController.class, "pendingRequests");
        private static final int STATE_QUIT = -2;
        private static final int STATE_RESERVED = -1;
        private static final int STATE_IDLE = 0;
        private volatile int pendingRequests;
        private final LatestValueSubscriber<Integer> maxConcurrencyHolder = new LatestValueSubscriber();

        AbstractReservableRequestConcurrencyController(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing) {
            SourceAdapters.toSource((Completable)onClosing).subscribe(new CompletableSource.Subscriber(){

                public void onSubscribe(Cancellable cancellable) {
                }

                public void onComplete() {
                    assert (pendingRequests != -2);
                    pendingRequests = -2;
                }

                public void onError(Throwable ignored) {
                    assert (pendingRequests != -2);
                    pendingRequests = -2;
                }
            });
            SourceAdapters.toSource((Publisher)maxConcurrency.afterOnNext(ConsumableEvent::eventConsumed).map(ConsumableEvent::event)).subscribe(this.maxConcurrencyHolder);
        }

        public final void requestFinished() {
            pendingRequestsUpdater.decrementAndGet(this);
        }

        public boolean tryReserve() {
            return pendingRequestsUpdater.compareAndSet(this, 0, -1);
        }

        public Completable releaseAsync() {
            return new SubscribableCompletable(){

                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    try {
                        subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
                    }
                    catch (Throwable cause) {
                        SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)cause);
                        return;
                    }
                    if (pendingRequestsUpdater.compareAndSet(this, -1, 0)) {
                        subscriber.onComplete();
                    } else {
                        subscriber.onError((Throwable)new IllegalStateException("Resource " + (Object)((Object)this) + (pendingRequests == -2 ? " is closed." : " was not reserved.")));
                    }
                }
            };
        }

        final int lastSeenMaxValue(int defaultValue) {
            return (Integer)this.maxConcurrencyHolder.lastSeenValue((Object)defaultValue);
        }

        final int pendingRequests() {
            return this.pendingRequests;
        }

        final boolean casPendingRequests(int oldValue, int newValue) {
            return pendingRequestsUpdater.compareAndSet(this, oldValue, newValue);
        }
    }

    static final class IgnoreConsumedEvent<T>
    implements ConsumableEvent<T> {
        private final T event;

        IgnoreConsumedEvent(T event) {
            this.event = Objects.requireNonNull(event);
        }

        public T event() {
            return this.event;
        }

        public void eventConsumed() {
        }
    }
}

