/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class Link {
    @Valid
    private String href;
    @Valid
    private String rel;
    @Valid
    private String type;
    @Valid
    private String hreflang;
    @Valid
    private String title;
    @Valid
    private Integer length;

    public Link href(String href) {
        this.href = href;
        return this;
    }

    @ApiModelProperty(example="http://data.example.com/buildings/123", required=true, value="")
    @JsonProperty(value="href")
    @NotNull
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Link rel(String rel) {
        this.rel = rel;
        return this;
    }

    @ApiModelProperty(example="alternate", value="")
    @JsonProperty(value="rel")
    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public Link type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="application/geo+json", value="")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Link hreflang(String hreflang) {
        this.hreflang = hreflang;
        return this;
    }

    @ApiModelProperty(example="en", value="")
    @JsonProperty(value="hreflang")
    public String getHreflang() {
        return this.hreflang;
    }

    public void setHreflang(String hreflang) {
        this.hreflang = hreflang;
    }

    public Link title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="Trierer Strasse 70, 53115 Bonn", value="")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Link length(Integer length) {
        this.length = length;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="length")
    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.href, link.href) && Objects.equals(this.rel, link.rel) && Objects.equals(this.type, link.type) && Objects.equals(this.hreflang, link.hreflang) && Objects.equals(this.title, link.title) && Objects.equals(this.length, link.length);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.rel, this.type, this.hreflang, this.title, this.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    rel: ").append(this.toIndentedString(this.rel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    hreflang: ").append(this.toIndentedString(this.hreflang)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

