/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class CorsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private final String ORIGIN = "Origin";
    private final String VARY = "Vary";

    public void filter(ContainerRequestContext requestContext) {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null) {
            return;
        }
        if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
            this.preflight(origin, requestContext);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String origin = requestContext.getHeaderString("Origin");
        if (origin == null || requestContext.getMethod().equalsIgnoreCase("OPTIONS") || requestContext.getProperty("cors.failure") != null) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Origin", (Object)origin);
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD");
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization");
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Credentials", (Object)"true");
        responseContext.getHeaders().putSingle((Object)"Access-Control-Expose-Headers", (Object)"Location");
        responseContext.getHeaders().putSingle((Object)"Vary", (Object)"Origin");
    }

    protected void preflight(String origin, ContainerRequestContext requestContext) {
        Response.ResponseBuilder builder = Response.noContent();
        builder.header("Access-Control-Allow-Origin", (Object)origin);
        builder.header("Vary", (Object)"Origin");
        builder.header("Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD");
        builder.header("Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization");
        builder.header("Access-Control-Allow-Credentials", (Object)"true");
        builder.header("Access-Control-Expose-Headers", (Object)"Location");
        requestContext.abortWith(builder.build());
    }
}

