/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class ConfigReader {
    public String read(Path path) throws IOException {
        String extension;
        String config = switch (extension = com.google.common.io.Files.getFileExtension((String)path.toString())) {
            case "js" -> this.eval(path);
            default -> Files.readString(path);
        };
        return config;
    }

    private String eval(Path path) throws IOException {
        String string;
        block8: {
            Context context = Context.newBuilder((String[])new String[]{"js"}).option("js.esm-eval-returns-exports", "true").option("js.scripting", "true").allowExperimentalOptions(true).allowIO(true).build();
            try {
                String script = String.format("import config from '%s';\nexport default JSON.stringify(config);\n", path.toAbsolutePath());
                Source source = Source.newBuilder((String)"js", (Reader)new StringReader(script), (String)"script.js").mimeType("application/javascript+module").build();
                Value value = context.eval(source);
                string = value.getMember("default").toString();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            context.close();
        }
        return string;
    }

    static {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
    }
}

