/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.collection.AppendOnlyBuffer;
import org.apache.baremaps.collection.algorithm.UnionStream;
import org.apache.baremaps.collection.memory.MemoryMappedFile;
import org.apache.baremaps.feature.FeatureType;
import org.apache.baremaps.feature.PropertyType;
import org.apache.baremaps.feature.ReadableFeatureStream;
import org.apache.baremaps.mvt.expression.Expressions;
import org.apache.baremaps.storage.postgres.PostgresDatabase;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.tasks.Entity;
import org.apache.baremaps.workflow.tasks.EntityDataType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record TransformEntityCollection(Path collection, String database, Recipe recipe) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(TransformEntityCollection.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Transform {} with {}", (Object)this.collection, (Object)this.recipe);
        FeatureType featureType = new FeatureType(this.recipe.name, this.propertyTypes());
        Map<Map, List<Entity>> groups = new AppendOnlyBuffer<Entity>(new EntityDataType(), new MemoryMappedFile(this.collection)).stream().filter(this::filter).collect(Collectors.groupingBy(this::propertyValues));
        Stream featureStream = groups.entrySet().stream().flatMap(entry -> {
            Map group = (Map)entry.getKey();
            List entities = (List)entry.getValue();
            Stream<Geometry> geometries = this.simplify(entities.stream().map(Entity::getGeometry));
            return geometries.map(geometry -> new Entity(0L, group, (Geometry)geometry));
        });
        ReadableFeatureStream featureSet = new ReadableFeatureStream(featureType, featureStream);
        DataSource dataSource = context.getDataSource(this.database);
        PostgresDatabase postgresDatabase = new PostgresDatabase(dataSource);
        postgresDatabase.write(featureSet);
    }

    private Stream<Geometry> simplify(Stream<Geometry> geometries) {
        return switch (this.recipe.operation()) {
            default -> throw new IncompatibleClassChangeError();
            case Operation.union -> this.union(geometries);
            case Operation.merge -> this.merge(geometries);
            case Operation.none -> geometries;
        };
    }

    private List<String> groupBy() {
        return this.recipe.groupBy() == null ? List.of() : this.recipe.groupBy();
    }

    private Map<String, PropertyType> propertyTypes() {
        HashMap<String, PropertyType> map = new HashMap<String, PropertyType>();
        for (String property : this.groupBy()) {
            map.put(property, new PropertyType<String>(property, String.class));
        }
        map.put("geometry", new PropertyType<Geometry>("geometry", Geometry.class));
        return map;
    }

    private Map<String, String> propertyValues(Entity entity) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String property : this.groupBy()) {
            map.put(property, entity.getProperty(property).toString());
        }
        return map;
    }

    private Stream<Geometry> union(Stream<Geometry> geometries) {
        ArrayList filtered = geometries.filter(Polygon.class::isInstance).map(Polygon.class::cast).map(GeometryFixer::fix).filter(Geometry::isValid).collect(Collectors.toCollection(ArrayList::new));
        return new UnionStream(filtered).union();
    }

    private Stream<Geometry> merge(Stream<Geometry> geometries) {
        List<Geometry> filtered = geometries.filter(LineString.class::isInstance).map(LineString.class::cast).map(GeometryFixer::fix).toList();
        LineMerger lineMerger = new LineMerger();
        lineMerger.add(filtered);
        Collection mergedGeometries = lineMerger.getMergedLineStrings();
        return mergedGeometries.stream();
    }

    private boolean filter(Entity entity) {
        return this.recipe.filter.evaluate(entity);
    }

    record Recipe(String name, Expressions.Expression<Boolean> filter, List<String> groupBy, Operation operation) {
    }

    static enum Operation {
        union,
        merge,
        none;

    }
}

