/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.database.tile.FileTileStore;
import org.apache.baremaps.database.tile.MBTiles;
import org.apache.baremaps.database.tile.PostgresTileStore;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.database.tile.TileChannel;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.database.tile.TileStoreException;
import org.apache.baremaps.mvt.tileset.Tileset;
import org.apache.baremaps.mvt.tileset.TilesetQuery;
import org.apache.baremaps.openstreetmap.utils.StreamProgress;
import org.apache.baremaps.stream.StreamUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteDataSource;

public record ExportVectorTiles(String database, Path tileset, Path repository, int batchArraySize, int batchArrayIndex, boolean mbtiles) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ExportVectorTiles.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Exporting vector tiles from {} to {}", (Object)this.database, (Object)this.repository);
        DataSource datasource = context.getDataSource(this.database);
        ObjectMapper mapper = new ObjectMapper().configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        Tileset source = (Tileset)mapper.readValue(Files.readAllBytes(this.tileset), Tileset.class);
        TileStore tileSource = this.sourceTileStore(source, datasource);
        TileStore tileTarget = this.targetTileStore(source);
        Envelope envelope = new Envelope(source.getBounds().get(0).doubleValue(), source.getBounds().get(2).doubleValue(), source.getBounds().get(1).doubleValue(), source.getBounds().get(3).doubleValue());
        long count = Tile.count(envelope, source.getMinzoom(), source.getMaxzoom());
        Stream<Tile> stream = StreamUtils.stream(Tile.iterator(envelope, source.getMinzoom(), source.getMaxzoom())).peek(new StreamProgress(count, 5000));
        StreamUtils.batch(stream, 10).forEach(new TileChannel(tileSource, tileTarget));
        logger.info("Finished exporting vector tiles from {} to {}", (Object)this.database, (Object)this.repository);
    }

    private TileStore sourceTileStore(Tileset tileset, DataSource datasource) {
        return new PostgresTileStore(datasource, tileset);
    }

    private TileStore targetTileStore(Tileset source) throws TileStoreException, IOException {
        if (this.mbtiles) {
            SQLiteDataSource dataSource = new SQLiteDataSource();
            dataSource.setUrl("jdbc:sqlite:" + this.repository);
            MBTiles tilesStore = new MBTiles(dataSource);
            tilesStore.initializeDatabase();
            tilesStore.writeMetadata(this.metadata(source));
            return tilesStore;
        }
        return new FileTileStore(this.repository);
    }

    private Map<String, String> metadata(Tileset tileset) throws JsonProcessingException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", tileset.getName());
        metadata.put("version", tileset.getVersion());
        metadata.put("description", tileset.getDescription());
        metadata.put("attribution", tileset.getAttribution());
        metadata.put("type", "baselayer");
        metadata.put("format", "pbf");
        metadata.put("center", tileset.getCenter().stream().map(Object::toString).collect(Collectors.joining(", ")));
        metadata.put("bounds", tileset.getBounds().stream().map(Object::toString).collect(Collectors.joining(", ")));
        metadata.put("minzoom", Double.toString(tileset.getMinzoom().intValue()));
        metadata.put("maxzoom", Double.toString(tileset.getMaxzoom().intValue()));
        List<Map> layers = tileset.getVectorLayers().stream().map(layer -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", layer.getId());
            map.put("description", layer.getDescription());
            map.put("minzoom", layer.getQueries().stream().mapToInt(TilesetQuery::getMinzoom).min().getAsInt());
            map.put("maxzoom", layer.getQueries().stream().mapToInt(TilesetQuery::getMaxzoom).max().getAsInt());
            return map;
        }).toList();
        metadata.put("json", new ObjectMapper().writeValueAsString(layers));
        return metadata;
    }
}

