/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.baremaps.collection.AppendOnlyBuffer;
import org.apache.baremaps.collection.MemoryAlignedDataList;
import org.apache.baremaps.collection.MonotonicDataMap;
import org.apache.baremaps.collection.memory.MemoryMappedFile;
import org.apache.baremaps.collection.type.LonLatDataType;
import org.apache.baremaps.collection.type.LongDataType;
import org.apache.baremaps.collection.type.LongListDataType;
import org.apache.baremaps.collection.type.PairDataType;
import org.apache.baremaps.collection.utils.FileUtils;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.pbf.PbfEntityReader;
import org.apache.baremaps.openstreetmap.utils.ProjectionTransformer;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.tasks.Entity;
import org.apache.baremaps.workflow.tasks.EntityDataType;
import org.apache.baremaps.workflow.tasks.ImportOpenStreetMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CreateEntityCollection(Path file, Path collection, Integer srid) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ImportOpenStreetMap.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Importing {} into {}", (Object)this.file, (Object)this.collection);
        Path path = this.file.toAbsolutePath();
        Path cacheDir = Files.createTempDirectory(Paths.get(".", new String[0]), "cache_", new FileAttribute[0]);
        Path coordinatesKeysFile = Files.createFile(cacheDir.resolve("coordinates_keys"), new FileAttribute[0]);
        Path coordinatesValsFile = Files.createFile(cacheDir.resolve("coordinates_vals"), new FileAttribute[0]);
        MonotonicDataMap<Coordinate> coordinateMap = new MonotonicDataMap<Coordinate>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedFile(coordinatesKeysFile)), new AppendOnlyBuffer<Coordinate>(new LonLatDataType(), new MemoryMappedFile(coordinatesValsFile)));
        Path referencesKeysFile = Files.createFile(cacheDir.resolve("references_keys"), new FileAttribute[0]);
        Path referencesValuesFile = Files.createFile(cacheDir.resolve("references_vals"), new FileAttribute[0]);
        MonotonicDataMap<List<Long>> referenceMap = new MonotonicDataMap<List<Long>>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedFile(referencesKeysFile)), new AppendOnlyBuffer<List<Long>>(new LongListDataType(), new MemoryMappedFile(referencesValuesFile)));
        Files.deleteIfExists(this.collection);
        AppendOnlyBuffer<Entity> entityCollection = new AppendOnlyBuffer<Entity>(new EntityDataType(), new MemoryMappedFile(this.collection));
        ProjectionTransformer projectionTransformer = new ProjectionTransformer(4326, this.srid);
        ((PbfEntityReader)((PbfEntityReader)new PbfEntityReader().geometries(true).coordinateMap(coordinateMap)).referenceMap(referenceMap)).stream(Files.newInputStream(path, new OpenOption[0])).filter(Element.class::isInstance).map(Element.class::cast).filter(element -> !element.getTags().isEmpty()).filter(element -> element.getGeometry() != null).map(element -> {
            Geometry geometry = element.getGeometry();
            geometry = projectionTransformer.transform(geometry);
            HashMap<String, String> tags = new HashMap<String, String>();
            for (Map.Entry<String, Object> tag : element.getTags().entrySet()) {
                tags.put(tag.getKey(), tag.getValue().toString());
            }
            return new Entity(element.id(), tags, geometry);
        }).collect(Collectors.toCollection(() -> entityCollection));
        entityCollection.close();
        FileUtils.deleteRecursively(cacheDir);
        logger.info("Finished importing {} into {}", (Object)this.file, (Object)this.collection);
    }
}

