/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.baremaps.workflow.Step;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.Workflow;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;

public class WorkflowExecutor
implements AutoCloseable {
    private final ExecutorService executorService;
    private final WorkflowContext context;
    private final Map<String, Step> steps;
    private final Map<String, CompletableFuture<Void>> futures;
    private final Graph<String> graph;

    public WorkflowExecutor(Workflow workflow) {
        this(workflow, Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    public WorkflowExecutor(Workflow workflow, ExecutorService executorService) {
        this.executorService = executorService;
        this.context = new WorkflowContext();
        this.steps = workflow.getSteps().stream().collect(Collectors.toMap(s -> s.getId(), s -> s));
        this.futures = new ConcurrentSkipListMap<String, CompletableFuture<Void>>();
        ImmutableGraph.Builder graphBuilder = GraphBuilder.directed().immutable();
        for (String id : this.steps.keySet()) {
            graphBuilder.addNode((Object)id);
        }
        for (Step step : this.steps.values()) {
            if (step.getNeeds() == null) continue;
            for (String stepNeeded : step.getNeeds()) {
                graphBuilder.putEdge((Object)stepNeeded, (Object)step.getId());
            }
        }
        this.graph = graphBuilder.build();
        if (Graphs.hasCycle(this.graph)) {
            throw new WorkflowException("The workflow must be a directed acyclic graph");
        }
    }

    public CompletableFuture<Void> execute() {
        CompletableFuture[] endSteps = (CompletableFuture[])this.graph.nodes().stream().filter(this::isEndStep).map(this::getStep).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(endSteps);
    }

    private CompletableFuture<Void> getStep(String step) {
        return this.futures.computeIfAbsent(step, this::initStep);
    }

    private CompletableFuture<Void> initStep(String stepId) {
        CompletionStage<Void> future = this.previousSteps(stepId);
        for (Task task : this.steps.get(stepId).getTasks()) {
            future = future.thenRunAsync(() -> {
                try {
                    task.execute(this.context);
                }
                catch (Exception e) {
                    throw new WorkflowException(e);
                }
            }, this.executorService);
        }
        return future;
    }

    private CompletableFuture<Void> previousSteps(String stepId) {
        List predecessors = this.graph.predecessors((Object)stepId).stream().toList();
        if (predecessors.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (predecessors.size() == 1) {
            return this.getStep((String)predecessors.get(0));
        }
        return CompletableFuture.allOf((CompletableFuture[])predecessors.stream().map(this::getStep).toArray(CompletableFuture[]::new));
    }

    private boolean isEndStep(String stepId) {
        return this.graph.successors((Object)stepId).isEmpty();
    }

    @Override
    public void close() throws Exception {
        this.executorService.shutdown();
    }
}

