/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.utils;

import java.util.stream.Stream;
import org.apache.baremaps.openstreetmap.utils.GeometryUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.ProjCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionTransformer
extends GeometryTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ProjectionTransformer.class);
    private final int sourceSrid;
    private final int targetSrid;
    private final CoordinateTransform transform;
    private ProjCoordinate min;
    private ProjCoordinate max;

    public ProjectionTransformer(int sourceSrid, int targetSrid) {
        this.sourceSrid = sourceSrid;
        this.targetSrid = targetSrid;
        this.transform = GeometryUtils.coordinateTransform(sourceSrid, targetSrid);
        CoordinateReferenceSystem targetCRS = new CRSFactory().createFromName(String.format("EPSG:%s", targetSrid));
        CoordinateTransform lonlatTranform = GeometryUtils.coordinateTransform(4326, sourceSrid);
        this.min = lonlatTranform.transform(new ProjCoordinate(Math.toDegrees(targetCRS.getProjection().getMinLongitude()), Math.toDegrees(targetCRS.getProjection().getMinLatitude())), new ProjCoordinate());
        this.max = lonlatTranform.transform(new ProjCoordinate(Math.toDegrees(targetCRS.getProjection().getMaxLongitude()), Math.toDegrees(targetCRS.getProjection().getMaxLatitude())), new ProjCoordinate());
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateSequence, Geometry parent) {
        Coordinate[] coordinateArray = (Coordinate[])Stream.of(coordinateSequence.toCoordinateArray()).map(this::transformCoordinate).toArray(Coordinate[]::new);
        return new CoordinateArraySequence(coordinateArray);
    }

    private Coordinate transformCoordinate(Coordinate coordinate) {
        if (this.sourceSrid == this.targetSrid) {
            return coordinate;
        }
        double x = Math.max(Math.min(coordinate.x, this.max.x), this.min.x);
        double y = Math.max(Math.min(coordinate.y, this.max.y), this.min.y);
        ProjCoordinate c1 = new ProjCoordinate(x, y);
        ProjCoordinate c2 = this.transform.transform(c1, new ProjCoordinate());
        return new Coordinate(c2.x, c2.y);
    }

    protected Geometry transformPoint(Point geom, Geometry parent) {
        try {
            Geometry geometry = super.transformPoint(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("Point cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    protected Geometry transformMultiPoint(MultiPoint geom, Geometry parent) {
        try {
            Geometry geometry = super.transformMultiPoint(geom, parent);
            if (geometry instanceof Point) {
                Point point = (Point)geometry;
                geometry = this.factory.createMultiPoint(new Point[]{point});
            }
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("MultiPoint cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    protected Geometry transformLinearRing(LinearRing geom, Geometry parent) {
        try {
            Geometry geometry = super.transformLinearRing(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("LinearRing cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    protected Geometry transformLineString(LineString geom, Geometry parent) {
        try {
            Geometry geometry = super.transformLineString(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("LineString cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    protected Geometry transformMultiLineString(MultiLineString geom, Geometry parent) {
        try {
            Geometry geometry = super.transformMultiLineString(geom, parent);
            if (geometry instanceof LineString) {
                LineString lineString = (LineString)geometry;
                geometry = this.factory.createMultiLineString(new LineString[]{lineString});
            }
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("MultiLineString cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    protected Geometry transformPolygon(Polygon geom, Geometry parent) {
        try {
            Geometry geometry = super.transformPolygon(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("Polygon cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
        try {
            Geometry geometry = super.transformMultiPolygon(geom, parent);
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                geometry = this.factory.createMultiPolygon(new Polygon[]{polygon});
            }
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("MultiPolygon cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    protected Geometry transformGeometryCollection(GeometryCollection geom, Geometry parent) {
        try {
            Geometry geometry = super.transformGeometryCollection(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            logger.error("GeometryCollection cannot be reprojected", (Throwable)e);
            return parent.getFactory().createEmpty(0);
        }
    }

    private Geometry withTargetSRID(Geometry outputGeom) {
        outputGeom.setSRID(this.targetSrid);
        return outputGeom;
    }
}

