/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.tile;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.database.tile.TileStoreException;

public class TileChannel
implements Consumer<Tile> {
    public final TileStore source;
    public final TileStore target;
    public final boolean deleteEmptyTiles;

    public TileChannel(TileStore source, TileStore target) {
        this(source, target, false);
    }

    public TileChannel(TileStore source, TileStore target, boolean deleteEmptyTiles) {
        this.source = source;
        this.target = target;
        this.deleteEmptyTiles = deleteEmptyTiles;
    }

    @Override
    public void accept(Tile tile) {
        try {
            ByteBuffer blob = this.source.read(tile);
            if (blob != null) {
                this.target.write(tile, blob);
            } else if (this.deleteEmptyTiles) {
                this.target.delete(tile);
            }
        }
        catch (TileStoreException ex) {
            throw new RuntimeException("An error occurred while creating the tiles", ex);
        }
    }
}

