/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.tile;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.baremaps.database.tile.TileIterator;
import org.locationtech.jts.geom.Envelope;

public final class Tile
implements Comparable<Tile> {
    private static final double EPSILON = 1.0E-7;
    private static final int[] sides = IntStream.range(0, 30).map(i -> IntMath.pow((int)2, (int)i)).toArray();
    private static final long[] squares = LongStream.range(0L, 30L).map(i -> LongMath.pow((long)IntMath.pow((int)2, (int)((int)i)), (int)2)).toArray();
    private static final long[] offsets = LongStream.range(0L, 30L).map(i -> LongStream.range(0L, i).map(j -> LongMath.pow((long)IntMath.pow((int)2, (int)((int)j)), (int)2)).sum()).toArray();
    private final int x;
    private final int y;
    private final int z;

    public Tile(int index) {
        int zoom = 0;
        long offset = 0L;
        long count = 1L;
        while ((long)index >= offset + count) {
            offset += count;
            count = squares[++zoom];
        }
        long position = (long)index - offset;
        this.x = (int)position % sides[zoom];
        this.y = (int)position / sides[zoom];
        this.z = zoom;
    }

    public Tile(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Iterator<Tile> iterator(Envelope envelope, int minzoom, int maxzoom) {
        return new TileIterator(envelope, minzoom, maxzoom);
    }

    public static List<Tile> list(Envelope envelope, int minzoom, int maxzoom) {
        return ImmutableList.copyOf(Tile.iterator(envelope, minzoom, maxzoom));
    }

    public static long count(Envelope envelope, int minzoom, int maxzoom) {
        int count = 0;
        for (int zoom = minzoom; zoom <= maxzoom; ++zoom) {
            Tile min = Tile.min(envelope, zoom);
            Tile max = Tile.max(envelope, zoom);
            count += (max.x() - min.x() + 1) * (max.y() - min.y() + 1);
        }
        return count;
    }

    public static Tile fromLonLat(double lon, double lat, int z) {
        int x = (int)((lon + 180.0) / 360.0 * (double)(1 << z));
        int y = (int)((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << z));
        return new Tile(x, y, z);
    }

    public long index() {
        long x = this.x;
        long y = this.y;
        long offset = offsets[this.z];
        long position = x + y * (long)sides[this.z];
        return offset + position;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Tile parent() {
        return new Tile(this.x / 2, this.y / 2, this.z - 1);
    }

    public Envelope envelope() {
        double x1 = Tile.tile2lon(this.x, this.z);
        double x2 = Tile.tile2lon(this.x + 1, this.z);
        double y1 = Tile.tile2lat(this.y + 1, this.z);
        double y2 = Tile.tile2lat(this.y, this.z);
        return new Envelope(x1, x2, y1, y2);
    }

    protected static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    protected static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    protected static Tile min(Envelope envelope, int zoom) {
        return Tile.fromLonLat(envelope.getMinX(), envelope.getMaxY(), zoom);
    }

    protected static Tile max(Envelope envelope, int zoom) {
        return Tile.fromLonLat(envelope.getMaxX() - 1.0E-7, envelope.getMinY() + 1.0E-7, zoom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tile that = (Tile)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.z});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).toString();
    }

    @Override
    public int compareTo(Tile that) {
        return Long.compare(this.index(), that.index());
    }
}

