/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.tile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.database.tile.TileStoreException;
import org.sqlite.SQLiteDataSource;

public class MBTiles
implements TileStore {
    private static final String CREATE_TABLE_METADATA = "CREATE TABLE IF NOT EXISTS metadata (name TEXT, value TEXT, PRIMARY KEY (name))";
    private static final String CREATE_TABLE_TILES = "CREATE TABLE IF NOT EXISTS tiles (zoom_level INTEGER, tile_column INTEGER, tile_row INTEGER, tile_data BLOB, PRIMARY KEY (zoom_level, tile_column, tile_row))";
    private static final String CREATE_INDEX_TILES = "CREATE UNIQUE INDEX tile_index on tiles (zoom_level, tile_column, tile_row)";
    private static final String SELECT_METADATA = "SELECT name, value FROM metadata";
    private static final String SELECT_TILE = "SELECT tile_data FROM tiles WHERE zoom_level = ? AND tile_column = ? AND tile_row = ?";
    private static final String INSERT_METADATA = "INSERT INTO metadata (name, value) VALUES (?, ?)";
    private static final String INSERT_TILE = "INSERT INTO tiles (zoom_level, tile_column, tile_row, tile_data) VALUES (?, ?, ?, ?)";
    private static final String DELETE_TILE = "DELETE FROM tiles WHERE zoom_level = ? AND tile_column = ? AND tile_row = ?";
    private static final String DELETE_METADATA = "DELETE FROM metadata";
    private final SQLiteDataSource dataSource;

    public MBTiles(SQLiteDataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer read(Tile tile) throws TileStoreException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(SELECT_TILE);){
            statement.setInt(1, tile.z());
            statement.setInt(2, tile.x());
            statement.setInt(3, MBTiles.reverseY(tile.y(), tile.z()));
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) throw new SQLException("The tile does not exist");
                ByteBuffer byteBuffer = ByteBuffer.wrap(resultSet.getBytes("tile_data"));
                return byteBuffer;
            }
        }
        catch (SQLException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void write(Tile tile, ByteBuffer blob) throws TileStoreException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(INSERT_TILE);){
            statement.setInt(1, tile.z());
            statement.setInt(2, tile.x());
            statement.setInt(3, MBTiles.reverseY(tile.y(), tile.z()));
            statement.setBytes(4, blob.array());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void delete(Tile tile) throws TileStoreException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(DELETE_TILE);){
            statement.setInt(1, tile.z());
            statement.setInt(2, tile.x());
            statement.setInt(3, MBTiles.reverseY(tile.y(), tile.z()));
            statement.execute();
        }
        catch (SQLException e) {
            throw new TileStoreException(e);
        }
    }

    public void initializeDatabase() throws TileStoreException {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(CREATE_TABLE_METADATA);
            statement.execute(CREATE_TABLE_TILES);
            statement.execute(CREATE_INDEX_TILES);
        }
        catch (SQLException ex) {
            throw new TileStoreException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    public Map<String, String> readMetadata() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeMetadata(Map<String, String> metadata) throws IOException {
        try (Connection connection = this.dataSource.getConnection();){
            try (Statement statement = connection.createStatement();){
                statement.execute(DELETE_METADATA);
            }
            statement = connection.prepareStatement(INSERT_METADATA);
            try {
                for (Map.Entry<String, String> entry : metadata.entrySet()) {
                    statement.setString(1, entry.getKey());
                    statement.setString(2, entry.getValue());
                    statement.executeUpdate();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    private static int reverseY(int y, int z) {
        return (int)(Math.pow(2.0, z) - 1.0 - (double)y);
    }
}

