/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.baremaps.database.metadata.ColumnResult;
import org.apache.baremaps.database.metadata.PrimaryKeyResult;
import org.apache.baremaps.database.metadata.TableMetaData;
import org.apache.baremaps.database.metadata.TableResult;

public class DatabaseMetadata {
    private final DataSource dataSource;

    public DatabaseMetadata(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public List<TableMetaData> getTableMetaData() {
        return this.getTableMetaData(null, null, null, null);
    }

    public List<TableMetaData> getTableMetaData(String catalog, String schema, String tableNamePattern, String[] types) {
        Map descriptions = this.getTables(catalog, schema, tableNamePattern, types).stream().collect(Collectors.toMap(TableResult::tableName, Function.identity()));
        Map<String, List<ColumnResult>> columns = this.getColumns(catalog, schema, tableNamePattern, null).stream().collect(Collectors.groupingBy(ColumnResult::tableName));
        Map<String, List<PrimaryKeyResult>> primaryKeys = this.getPrimaryKeys(catalog, schema, tableNamePattern).stream().collect(Collectors.groupingBy(PrimaryKeyResult::tableName));
        return descriptions.entrySet().stream().map(entry -> new TableMetaData((TableResult)entry.getValue(), primaryKeys.getOrDefault(entry.getKey(), List.of()), columns.getOrDefault(entry.getKey(), List.of()))).toList();
    }

    private List<TableResult> getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        ArrayList<TableResult> tableDescriptions = new ArrayList<TableResult>();
        try (Connection connection = this.dataSource.getConnection();
             ResultSet resultSet = connection.getMetaData().getTables(catalog, schemaPattern, tableNamePattern, types);){
            while (resultSet.next()) {
                tableDescriptions.add(new TableResult(resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME"), resultSet.getString("TABLE_TYPE"), resultSet.getString("REMARKS"), resultSet.getString("TYPE_CAT"), resultSet.getString("TYPE_SCHEM"), resultSet.getString("TYPE_NAME"), resultSet.getString("SELF_REFERENCING_COL_NAME"), resultSet.getString("REF_GENERATION")));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tableDescriptions;
    }

    private List<ColumnResult> getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        ArrayList<ColumnResult> tableColumns = new ArrayList<ColumnResult>();
        try (Connection connection = this.dataSource.getConnection();
             ResultSet resultSet = connection.getMetaData().getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);){
            while (resultSet.next()) {
                tableColumns.add(new ColumnResult(resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME"), resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE"), resultSet.getString("TYPE_NAME"), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), resultSet.getInt("NUM_PREC_RADIX"), resultSet.getInt("NULLABLE"), resultSet.getString("REMARKS"), resultSet.getString("COLUMN_DEF"), resultSet.getInt("SQL_DATA_TYPE"), resultSet.getInt("SQL_DATETIME_SUB"), resultSet.getInt("CHAR_OCTET_LENGTH"), resultSet.getInt("ORDINAL_POSITION"), resultSet.getString("IS_NULLABLE"), resultSet.getString("SCOPE_CATALOG"), resultSet.getString("SCOPE_SCHEMA"), resultSet.getString("SCOPE_TABLE"), resultSet.getShort("SOURCE_DATA_TYPE"), resultSet.getString("IS_AUTOINCREMENT"), resultSet.getString("IS_GENERATEDCOLUMN")));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tableColumns;
    }

    private List<PrimaryKeyResult> getPrimaryKeys(String catalog, String schemaPattern, String table) {
        ArrayList<PrimaryKeyResult> tablePrimaryKeyColumns = new ArrayList<PrimaryKeyResult>();
        try (Connection connection = this.dataSource.getConnection();
             ResultSet resultSet = connection.getMetaData().getPrimaryKeys(catalog, schemaPattern, table);){
            while (resultSet.next()) {
                tablePrimaryKeyColumns.add(new PrimaryKeyResult(resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME"), resultSet.getString("COLUMN_NAME"), resultSet.getShort("KEY_SEQ"), resultSet.getString("PK_NAME")));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tablePrimaryKeyColumns;
    }
}

