/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection;

import java.util.Iterator;
import java.util.Map;
import org.apache.baremaps.collection.DataList;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.collection.MemoryAlignedDataList;
import org.apache.baremaps.collection.type.LongDataType;
import org.apache.baremaps.collection.type.PairDataType;

public class MonotonicPairedDataMap<E>
extends DataMap<E> {
    private final DataList<Long> offsets;
    private final MemoryAlignedDataList<PairDataType.Pair<Long, E>> values;
    private long lastChunk = -1L;

    public MonotonicPairedDataMap(MemoryAlignedDataList<PairDataType.Pair<Long, E>> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), values);
    }

    public MonotonicPairedDataMap(DataList<Long> offsets, MemoryAlignedDataList<PairDataType.Pair<Long, E>> values) {
        this.offsets = offsets;
        this.values = values;
    }

    @Override
    public E put(Long key, E value) {
        long index = this.values.sizeAsLong();
        long chunk = key >>> 8;
        if (chunk != this.lastChunk) {
            while (this.offsets.sizeAsLong() <= chunk) {
                this.offsets.add(index);
            }
            this.lastChunk = chunk;
        }
        this.values.add(new PairDataType.Pair<Long, E>(key, value));
        return null;
    }

    @Override
    public E get(Object keyObject) {
        long key = (Long)keyObject;
        long chunk = key >>> 8;
        if (chunk >= this.offsets.sizeAsLong()) {
            return null;
        }
        long lo = this.offsets.get(chunk);
        long hi = Math.min(this.values.sizeAsLong(), chunk >= this.offsets.sizeAsLong() - 1L ? this.values.sizeAsLong() : this.offsets.get(chunk + 1L).longValue()) - 1L;
        while (lo <= hi) {
            long index = lo + hi >>> 1;
            PairDataType.Pair<Long, E> pair = this.values.get(index);
            long value = pair.left();
            if (value < key) {
                lo = index + 1L;
                continue;
            }
            if (value > key) {
                hi = index - 1L;
                continue;
            }
            return pair.right();
        }
        return null;
    }

    @Override
    protected Iterator<Long> keyIterator() {
        return this.values.stream().map(PairDataType.Pair::left).iterator();
    }

    @Override
    protected Iterator<E> valueIterator() {
        return this.values.stream().map(PairDataType.Pair::right).iterator();
    }

    @Override
    protected Iterator<Map.Entry<Long, E>> entryIterator() {
        return this.values.stream().map(p -> Map.entry((Long)p.left(), p.right())).iterator();
    }

    @Override
    public long sizeAsLong() {
        return this.values.sizeAsLong();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.stream().anyMatch(p -> p.right().equals(value));
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.values.clear();
    }
}

