/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.ReferenceCounted;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelSet;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutors;
import io.servicetalk.transport.netty.internal.InfluencerConnectionAcceptor;
import io.servicetalk.transport.netty.internal.NettyServerContext;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpServerBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpServerBinder.class);

    private TcpServerBinder() {
    }

    public static <CC extends ConnectionContext> Single<ServerContext> bind(SocketAddress listenAddress, final ReadOnlyTcpServerConfig config, boolean autoRead, final ExecutionContext<?> executionContext, final @Nullable InfluencerConnectionAcceptor connectionAcceptor, final BiFunction<Channel, ConnectionObserver, Single<CC>> connectionFunction, final Consumer<CC> connectionConsumer) {
        Objects.requireNonNull(connectionFunction);
        Objects.requireNonNull(connectionConsumer);
        listenAddress = BuilderUtils.toNettyAddress((Object)listenAddress);
        EventLoopAwareNettyIoExecutor nettyIoExecutor = EventLoopAwareNettyIoExecutors.toEventLoopAwareNettyIoExecutor((IoExecutor)executionContext.ioExecutor());
        ServerBootstrap bs = new ServerBootstrap();
        TcpServerBinder.configure(config, autoRead, bs, nettyIoExecutor.eventLoopGroup(), listenAddress.getClass());
        final ChannelSet channelSet = new ChannelSet(executionContext.executionStrategy().isCloseOffloaded() ? executionContext.executor() : Executors.immediate());
        bs.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (msg instanceof ReferenceCounted) {
                    try {
                        throw new IllegalArgumentException("Unexpected ReferenceCounted msg in 'accept' pipeline: " + msg);
                    }
                    catch (Throwable throwable) {
                        ((ReferenceCounted)msg).release();
                        throw throwable;
                    }
                }
                if (msg instanceof Channel) {
                    Channel channel = (Channel)msg;
                    if (!channel.isActive()) {
                        channel.close();
                        LOGGER.debug("Channel ({}) is accepted, but was already inactive", msg);
                        return;
                    }
                    if (!channelSet.addIfAbsent(channel)) {
                        LOGGER.warn("Channel ({}) not added to ChannelSet", msg);
                        return;
                    }
                }
                ctx.fireChannelRead(msg);
            }
        });
        bs.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                Single connectionSingle = (Single)connectionFunction.apply(channel, config.transportObserver().onNewConnection((Object)channel.localAddress(), (Object)channel.remoteAddress()));
                if (connectionAcceptor != null) {
                    connectionSingle = connectionSingle.flatMap(conn -> Single.defer(() -> connectionAcceptor.accept(conn).concat(Single.succeeded((Object)conn))).subscribeOn((Executor)(connectionAcceptor.requiredOffloads().isConnectOffloaded() ? executionContext.executor() : Executors.immediate())));
                }
                connectionSingle.beforeOnError(cause -> {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Failed to create a connection for remote address {}", (Object)channel.remoteAddress(), cause);
                    }
                    ChannelCloseUtils.close((Channel)channel, (Throwable)cause);
                }).subscribe(connectionConsumer);
            }
        });
        final ChannelFuture future = bs.bind(listenAddress);
        return new SubscribableSingle<ServerContext>(){

            protected void handleSubscribe(SingleSource.Subscriber<? super ServerContext> subscriber) {
                subscriber.onSubscribe(() -> future.cancel(true));
                future.addListener(f -> {
                    Channel channel = f.channel();
                    Throwable cause = f.cause();
                    if (cause == null) {
                        subscriber.onSuccess((Object)NettyServerContext.wrap((Channel)channel, (ListenableAsyncCloseable)channelSet, (AsyncCloseable)connectionAcceptor, (ExecutionContext)executionContext));
                    } else {
                        ChannelCloseUtils.close((Channel)channel, (Throwable)f.cause());
                        subscriber.onError(f.cause());
                    }
                });
            }
        };
    }

    private static void configure(ReadOnlyTcpServerConfig config, boolean autoRead, ServerBootstrap bs, @Nullable EventLoopGroup eventLoopGroup, Class<? extends SocketAddress> bindAddressClass) {
        ChannelOption option;
        if (eventLoopGroup == null) {
            throw new IllegalStateException("IoExecutor must be specified before building");
        }
        bs.group(eventLoopGroup);
        bs.channel(BuilderUtils.serverChannel((EventLoopGroup)eventLoopGroup, bindAddressClass));
        for (Map.Entry<ChannelOption, Object> opt : config.options().entrySet()) {
            option = opt.getKey();
            bs.childOption(option, opt.getValue());
        }
        for (Map.Entry<ChannelOption, Object> opt : config.listenOptions().entrySet()) {
            option = opt.getKey();
            bs.option(option, opt.getValue());
        }
        bs.childOption(ChannelOption.AUTO_READ, (Object)autoRead);
        PooledByteBufAllocator byteBufAllocator = CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR;
        bs.option(ChannelOption.ALLOCATOR, (Object)byteBufAllocator);
        bs.childOption(ChannelOption.ALLOCATOR, (Object)byteBufAllocator);
    }
}

