/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import io.servicetalk.logging.slf4j.internal.Slf4jFixedLevelLoggers;
import io.servicetalk.transport.netty.internal.CloseHandler;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class LoggingCloseHandler
extends CloseHandler {
    private final CloseHandler delegate;
    private final FixedLevelLogger logger;

    LoggingCloseHandler(CloseHandler delegate, String loggerName, LogLevel logLevel) {
        this.delegate = delegate;
        this.logger = Slf4jFixedLevelLoggers.newLogger((String)loggerName, (LogLevel)logLevel);
    }

    @Override
    public void protocolPayloadBeginInbound(ChannelHandlerContext ctx) {
        this.logger.log("{} protocolPayloadBeginInbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.protocolPayloadBeginInbound(ctx);
    }

    @Override
    public void protocolPayloadEndInbound(ChannelHandlerContext ctx) {
        this.logger.log("{} protocolPayloadEndInbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.protocolPayloadEndInbound(ctx);
    }

    @Override
    public void protocolPayloadBeginOutbound(ChannelHandlerContext ctx) {
        this.logger.log("{} protocolPayloadBeginOutbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.protocolPayloadBeginOutbound(ctx);
    }

    @Override
    public void protocolPayloadEndOutbound(ChannelHandlerContext ctx, @Nullable ChannelPromise promise) {
        this.logger.log("{} protocolPayloadEndOutbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.protocolPayloadEndOutbound(ctx, promise);
    }

    @Override
    public void protocolClosingInbound(ChannelHandlerContext ctx) {
        this.logger.log("{} protocolClosingInbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.protocolClosingInbound(ctx);
    }

    @Override
    public void protocolClosingOutbound(ChannelHandlerContext ctx) {
        this.logger.log("{} protocolClosingOutbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.protocolClosingOutbound(ctx);
    }

    @Override
    void registerEventHandler(Channel channel, Consumer<CloseHandler.CloseEvent> eventHandler) {
        this.logger.log("{} registerEventHandler {}", (Object)channel, (Object)this.delegate);
        this.delegate.registerEventHandler(channel, eventHandler);
    }

    @Override
    void channelClosedInbound(ChannelHandlerContext ctx) {
        this.logger.log("{} channelClosedInbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.channelClosedInbound(ctx);
    }

    @Override
    void channelClosedOutbound(ChannelHandlerContext ctx) {
        this.logger.log("{} channelClosedOutbound {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.channelClosedOutbound(ctx);
    }

    @Override
    void channelCloseNotify(ChannelHandlerContext ctx) {
        this.logger.log("{} channelCloseNotify {}", (Object)ctx.channel(), (Object)this.delegate);
        this.delegate.channelCloseNotify(ctx);
    }

    @Override
    void closeChannelInbound(Channel channel) {
        this.logger.log("{} closeChannelInbound {}", (Object)channel, (Object)this.delegate);
        this.delegate.closeChannelInbound(channel);
    }

    @Override
    void closeChannelOutbound(Channel channel) {
        this.logger.log("{} closeChannelOutbound {}", (Object)channel, (Object)this.delegate);
        this.delegate.closeChannelOutbound(channel);
    }

    @Override
    void gracefulUserClosing(Channel channel) {
        this.logger.log("{} gracefulUserClosing {}", (Object)channel, (Object)this.delegate);
        this.delegate.gracefulUserClosing(channel);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.delegate + ")";
    }
}

