/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelId;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.transport.netty.internal.PrivilegedListenableAsyncCloseable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class ChannelSet
implements ListenableAsyncCloseable {
    private static final AtomicIntegerFieldUpdater<ChannelSet> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ChannelSet.class, "state");
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            boolean wasRemoved;
            boolean bl = wasRemoved = ChannelSet.this.channelMap.remove(future.channel().id()) != null;
            if (wasRemoved && ChannelSet.this.state != 0 && ChannelSet.this.channelMap.isEmpty()) {
                ChannelSet.this.onCloseProcessor.onComplete();
            }
        }
    };
    public static final AttributeKey<PrivilegedListenableAsyncCloseable> CHANNEL_CLOSEABLE_KEY = AttributeKey.newInstance((String)"closeable");
    private final Map<ChannelId, Channel> channelMap = new ConcurrentHashMap<ChannelId, Channel>();
    private final CompletableSource.Processor onCloseProcessor = Processors.newCompletableProcessor();
    private final Completable onClose;
    private volatile int state;

    public ChannelSet(io.servicetalk.concurrent.api.Executor offloadingExecutor) {
        this.onClose = SourceAdapters.fromSource((CompletableSource)this.onCloseProcessor).publishOn((Executor)offloadingExecutor);
    }

    public boolean addIfAbsent(Channel channel) {
        boolean added;
        boolean bl = added = this.channelMap.putIfAbsent(channel.id(), channel) == null;
        if (this.state != 0) {
            if (added) {
                this.channelMap.remove(channel.id(), channel);
                channel.close();
                return false;
            }
        } else if (added) {
            channel.closeFuture().addListener((GenericFutureListener)this.remover);
        }
        return added;
    }

    public Completable closeAsync() {
        return new SubscribableCompletable(){

            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                SourceAdapters.toSource((Completable)ChannelSet.this.onClose).subscribe(subscriber);
                if (stateUpdater.getAndSet(ChannelSet.this, 2) == 2) {
                    return;
                }
                if (ChannelSet.this.channelMap.isEmpty()) {
                    ChannelSet.this.onCloseProcessor.onComplete();
                    return;
                }
                for (Channel channel : ChannelSet.this.channelMap.values()) {
                    channel.close();
                }
            }
        };
    }

    public Completable closeAsyncGracefully() {
        return new SubscribableCompletable(){

            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                if (!stateUpdater.compareAndSet(ChannelSet.this, 0, 1)) {
                    SourceAdapters.toSource((Completable)ChannelSet.this.onClose).subscribe(subscriber);
                    return;
                }
                if (ChannelSet.this.channelMap.isEmpty()) {
                    SourceAdapters.toSource((Completable)ChannelSet.this.onClose).subscribe(subscriber);
                    ChannelSet.this.onCloseProcessor.onComplete();
                    return;
                }
                CompositeCloseable closeable = AsyncCloseables.newCompositeCloseable();
                for (Channel channel : ChannelSet.this.channelMap.values()) {
                    Attribute closeableAttribute = channel.attr(CHANNEL_CLOSEABLE_KEY);
                    final PrivilegedListenableAsyncCloseable channelCloseable = (PrivilegedListenableAsyncCloseable)closeableAttribute.getAndSet(null);
                    if (null != channelCloseable) {
                        closeable.merge(new AsyncCloseable(){

                            public Completable closeAsync() {
                                return channelCloseable.closeAsyncNoOffload();
                            }

                            public Completable closeAsyncGracefully() {
                                return channelCloseable.closeAsyncGracefullyNoOffload();
                            }
                        });
                        continue;
                    }
                    channel.close();
                }
                closeable.append(() -> ChannelSet.this.onClose);
                SourceAdapters.toSource((Completable)closeable.closeAsyncGracefully()).subscribe(subscriber);
            }
        };
    }

    public Completable onClose() {
        return this.onClose;
    }
}

