/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.hive.LegacyHiveClasses;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogLockContext;
import org.apache.paimon.catalog.CatalogLockFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveCatalogFactory;
import org.apache.paimon.hive.HiveCatalogLock;
import org.apache.paimon.hive.HiveCatalogLockContext;
import org.apache.paimon.hive.HiveCatalogLockFactory;
import org.apache.paimon.hive.HiveCatalogOptions;
import org.apache.paimon.hive.HiveMetastoreClient;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.LocationHelper;
import org.apache.paimon.hive.RetryingMetaStoreClientFactory;
import org.apache.paimon.hive.SerializableHiveConf;
import org.apache.paimon.hive.StorageLocationHelper;
import org.apache.paimon.hive.TBPropertiesLocationHelper;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.privilege.FileBasedPrivilegeManager;
import org.apache.paimon.privilege.PrivilegedCatalog;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.TableType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    public static final String COMMENT_PROP = "comment";
    public static final String TABLE_TYPE_PROP = "table_type";
    public static final String PAIMON_TABLE_TYPE_VALUE = "paimon";
    private static final String INPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonInputFormat";
    private static final String OUTPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonOutputFormat";
    private static final String SERDE_CLASS_NAME = "org.apache.paimon.hive.PaimonSerDe";
    private static final String STORAGE_HANDLER_CLASS_NAME = "org.apache.paimon.hive.PaimonStorageHandler";
    private static final String HIVE_PREFIX = "hive.";
    public static final String HIVE_SITE_FILE = "hive-site.xml";
    private final HiveConf hiveConf;
    private final String clientClassName;
    private final IMetaStoreClient client;
    private final String warehouse;
    private final LocationHelper locationHelper;

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName, String warehouse) {
        this(fileIO, hiveConf, clientClassName, new Options(), warehouse);
    }

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName, Options options, String warehouse) {
        super(fileIO, options);
        this.hiveConf = hiveConf;
        this.clientClassName = clientClassName;
        this.warehouse = warehouse;
        boolean needLocationInProperties = hiveConf.getBoolean(HiveCatalogOptions.LOCATION_IN_PROPERTIES.key(), HiveCatalogOptions.LOCATION_IN_PROPERTIES.defaultValue().booleanValue());
        if (needLocationInProperties) {
            this.locationHelper = new TBPropertiesLocationHelper();
        } else {
            hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, warehouse);
            this.locationHelper = new StorageLocationHelper();
        }
        this.client = HiveCatalog.createClient(hiveConf, clientClassName);
    }

    @Override
    public Optional<CatalogLockFactory> defaultLockFactory() {
        return Optional.of(new HiveCatalogLockFactory());
    }

    @Override
    public Optional<CatalogLockContext> lockContext() {
        return Optional.of(new HiveCatalogLockContext(new SerializableHiveConf(this.hiveConf), this.clientClassName, this.catalogOptions));
    }

    @Override
    public Optional<MetastoreClient.Factory> metastoreClientFactory(Identifier identifier) {
        try {
            return Optional.of(new HiveMetastoreClient.Factory(identifier, this.getDataTableSchema(identifier), this.hiveConf, this.clientClassName));
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException("Table " + identifier + " does not exist. This is unexpected.", e);
        }
    }

    @Override
    public Path getDataTableLocation(Identifier identifier) {
        try {
            String databaseName = identifier.getDatabaseName();
            String tableName = identifier.getObjectName();
            if (this.client.tableExists(databaseName, tableName)) {
                String location = this.locationHelper.getTableLocation(this.client.getTable(databaseName, tableName));
                if (location != null) {
                    return new Path(location);
                }
            } else {
                String dbLocation = this.locationHelper.getDatabaseLocation(this.client.getDatabase(databaseName));
                if (dbLocation != null) {
                    return new Path(dbLocation, tableName);
                }
            }
            return super.getDataTableLocation(identifier);
        }
        catch (TException e) {
            throw new RuntimeException("Can not get table " + identifier + " from metastore.", e);
        }
    }

    @Override
    public List<String> listDatabases() {
        try {
            return this.client.getAllDatabases();
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all databases", e);
        }
    }

    @Override
    protected boolean databaseExistsImpl(String databaseName) {
        try {
            this.client.getDatabase(databaseName);
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to determine if database " + databaseName + " exists", e);
        }
    }

    @Override
    protected void createDatabaseImpl(String name, Map<String, String> properties) {
        try {
            Database database = this.convertToHiveDatabase(name, properties);
            Path databasePath = database.getLocationUri() == null ? this.newDatabasePath(name) : new Path(database.getLocationUri());
            this.locationHelper.createPathIfRequired(databasePath, this.fileIO);
            this.locationHelper.specifyDatabaseLocation(databasePath, database);
            this.client.createDatabase(database);
        }
        catch (IOException | TException e) {
            throw new RuntimeException("Failed to create database " + name, e);
        }
    }

    private Database convertToHiveDatabase(String name, Map<String, String> properties) {
        Database database = new Database();
        database.setName(name);
        HashMap parameter = new HashMap();
        properties.forEach((key, value) -> {
            if (key.equals(COMMENT_PROP)) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (value != null) {
                parameter.put(key, value);
            }
        });
        database.setParameters(parameter);
        return database;
    }

    @Override
    public Map<String, String> loadDatabasePropertiesImpl(String name) {
        try {
            return this.convertToProperties(this.client.getDatabase(name));
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Failed to get database %s properties", name), e);
        }
    }

    private Map<String, String> convertToProperties(Database database) {
        HashMap<String, String> properties = new HashMap<String, String>(database.getParameters());
        if (database.getLocationUri() != null) {
            properties.put("location", database.getLocationUri());
        }
        if (database.getDescription() != null) {
            properties.put(COMMENT_PROP, database.getDescription());
        }
        return properties;
    }

    @Override
    protected void dropDatabaseImpl(String name) {
        try {
            Database database = this.client.getDatabase(name);
            String location = this.locationHelper.getDatabaseLocation(database);
            this.locationHelper.dropPathIfRequired(new Path(location), this.fileIO);
            this.client.dropDatabase(name, true, false, true);
        }
        catch (IOException | TException e) {
            throw new RuntimeException("Failed to drop database " + name, e);
        }
    }

    @Override
    protected List<String> listTablesImpl(String databaseName) {
        try {
            return this.client.getAllTables(databaseName).stream().filter(tableName -> {
                Identifier identifier = new Identifier(databaseName, (String)tableName);
                return this.tableExists(identifier);
            }).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables in database " + databaseName, e);
        }
    }

    @Override
    public boolean tableExists(Identifier identifier) {
        Table table;
        if (this.isSystemTable(identifier)) {
            return super.tableExists(identifier);
        }
        try {
            table = this.client.getTable(identifier.getDatabaseName(), identifier.getObjectName());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Cannot determine if table " + identifier.getFullName() + " is a paimon table.", e);
        }
        return HiveCatalog.isPaimonTable(table) || LegacyHiveClasses.isPaimonTable(table);
    }

    private static boolean isPaimonTable(Table table) {
        return INPUT_FORMAT_CLASS_NAME.equals(table.getSd().getInputFormat()) && OUTPUT_FORMAT_CLASS_NAME.equals(table.getSd().getOutputFormat());
    }

    @Override
    public TableSchema getDataTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        if (!this.tableExists(identifier)) {
            throw new Catalog.TableNotExistException(identifier);
        }
        Path tableLocation = this.getDataTableLocation(identifier);
        return new SchemaManager(this.fileIO, tableLocation).latest().orElseThrow(() -> new RuntimeException("There is no paimon table in " + tableLocation));
    }

    private boolean usingExternalTable() {
        TableType tableType = OptionsUtils.convertToEnum(this.hiveConf.get(CatalogOptions.TABLE_TYPE.key(), TableType.MANAGED.toString()), TableType.class);
        return TableType.EXTERNAL.equals(tableType);
    }

    @Override
    protected void dropTableImpl(Identifier identifier) {
        try {
            this.client.dropTable(identifier.getDatabaseName(), identifier.getObjectName(), true, false, true);
            if (this.usingExternalTable()) {
                return;
            }
            Path path = this.getDataTableLocation(identifier);
            try {
                if (this.fileIO.exists(path)) {
                    this.fileIO.deleteDirectoryQuietly(path);
                }
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{path, identifier, ee});
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop table " + identifier.getFullName(), e);
        }
    }

    @Override
    protected void createTableImpl(Identifier identifier, Schema schema) {
        TableSchema tableSchema;
        try {
            tableSchema = this.schemaManager(identifier).createTable(schema, this.usingExternalTable());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit changes of table " + identifier.getFullName() + " to underlying files.", e);
        }
        Table table = this.newHmsTable(identifier, OptionsUtils.convertToPropertiesPrefixKey(tableSchema.options(), HIVE_PREFIX));
        try {
            this.updateHmsTable(table, identifier, tableSchema);
            this.client.createTable(table);
        }
        catch (Exception e) {
            Path path = this.getDataTableLocation(identifier);
            try {
                this.fileIO.deleteDirectoryQuietly(path);
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{path, identifier, ee});
            }
            throw new RuntimeException("Failed to create table " + identifier.getFullName(), e);
        }
    }

    @Override
    protected void renameTableImpl(Identifier fromTable, Identifier toTable) {
        block4: {
            try {
                String fromDB = fromTable.getDatabaseName();
                String fromTableName = fromTable.getObjectName();
                Table table = this.client.getTable(fromDB, fromTableName);
                table.setDbName(toTable.getDatabaseName());
                table.setTableName(toTable.getObjectName());
                this.client.alter_table(fromDB, fromTableName, table);
                Path fromPath = this.getDataTableLocation(fromTable);
                if (new SchemaManager(this.fileIO, fromPath).listAllIds().size() <= 0) break block4;
                Path toPath = this.getDataTableLocation(toTable);
                try {
                    this.fileIO.rename(fromPath, toPath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to rename changes of table " + toTable.getFullName() + " to underlying files.", e);
                }
                this.locationHelper.specifyTableLocation(table, toPath.toString());
                this.client.alter_table(toTable.getDatabaseName(), toTable.getObjectName(), table);
            }
            catch (TException e) {
                throw new RuntimeException("Failed to rename table " + fromTable.getFullName(), e);
            }
        }
    }

    @Override
    protected void alterTableImpl(Identifier identifier, List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        SchemaManager schemaManager = this.schemaManager(identifier);
        TableSchema schema = schemaManager.commitChanges(changes);
        try {
            Table table = this.client.getTable(identifier.getDatabaseName(), identifier.getObjectName());
            this.updateHmsTablePars(table, schema);
            this.updateHmsTable(table, identifier, schema);
            this.client.alter_table(identifier.getDatabaseName(), identifier.getObjectName(), table, true);
        }
        catch (Exception te) {
            schemaManager.deleteSchema(schema.id());
            throw new RuntimeException(te);
        }
    }

    @Override
    public boolean caseSensitive() {
        return false;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    @Override
    public String warehouse() {
        return this.warehouse;
    }

    private Table newHmsTable(Identifier identifier, Map<String, String> tableParameters) {
        long currentTimeMillis = System.currentTimeMillis();
        TableType tableType = OptionsUtils.convertToEnum(this.hiveConf.get(CatalogOptions.TABLE_TYPE.key(), TableType.MANAGED.toString()), TableType.class);
        Table table = new Table(identifier.getObjectName(), identifier.getDatabaseName(), System.getProperty("user.name"), (int)(currentTimeMillis / 1000L), (int)(currentTimeMillis / 1000L), Integer.MAX_VALUE, null, Collections.emptyList(), tableParameters, null, null, tableType.toString().toUpperCase(Locale.ROOT) + "_TABLE");
        table.getParameters().put(TABLE_TYPE_PROP, PAIMON_TABLE_TYPE_VALUE.toUpperCase());
        table.getParameters().put("storage_handler", STORAGE_HANDLER_CLASS_NAME);
        if (TableType.EXTERNAL.equals(tableType)) {
            table.getParameters().put("EXTERNAL", "TRUE");
        }
        return table;
    }

    private void updateHmsTable(Table table, Identifier identifier, TableSchema schema) {
        StorageDescriptor sd = table.getSd() != null ? table.getSd() : new StorageDescriptor();
        sd.setInputFormat(INPUT_FORMAT_CLASS_NAME);
        sd.setOutputFormat(OUTPUT_FORMAT_CLASS_NAME);
        SerDeInfo serDeInfo = sd.getSerdeInfo() != null ? sd.getSerdeInfo() : new SerDeInfo();
        serDeInfo.setParameters(new HashMap());
        serDeInfo.setSerializationLib(SERDE_CLASS_NAME);
        sd.setSerdeInfo(serDeInfo);
        CoreOptions options = new CoreOptions(schema.options());
        if (options.partitionedTableInMetastore() && schema.partitionKeys().size() > 0) {
            Map fieldMap = schema.fields().stream().collect(Collectors.toMap(DataField::name, Function.identity()));
            ArrayList<FieldSchema> partitionFields = new ArrayList<FieldSchema>();
            for (String partitionKey : schema.partitionKeys()) {
                partitionFields.add(this.convertToFieldSchema((DataField)fieldMap.get(partitionKey)));
            }
            table.setPartitionKeys(partitionFields);
            HashSet<String> partitionKeys = new HashSet<String>(schema.partitionKeys());
            ArrayList<FieldSchema> normalFields = new ArrayList<FieldSchema>();
            for (DataField field : schema.fields()) {
                if (partitionKeys.contains(field.name())) continue;
                normalFields.add(this.convertToFieldSchema(field));
            }
            sd.setCols(normalFields);
        } else {
            if (options.tagToPartitionField() != null) {
                Preconditions.checkArgument(schema.partitionKeys().isEmpty(), "Partition table can not use timeTravelToPartitionField.");
                table.setPartitionKeys(Collections.singletonList(this.convertToFieldSchema(new DataField(0, options.tagToPartitionField(), DataTypes.STRING()))));
            }
            sd.setCols(schema.fields().stream().map(this::convertToFieldSchema).collect(Collectors.toList()));
        }
        table.setSd(sd);
        if (schema.comment() != null) {
            table.getParameters().put(COMMENT_PROP, schema.comment());
        }
        this.locationHelper.specifyTableLocation(table, this.getDataTableLocation(identifier).toString());
    }

    private void updateHmsTablePars(Table table, TableSchema schema) {
        table.getParameters().putAll(OptionsUtils.convertToPropertiesPrefixKey(schema.options(), HIVE_PREFIX));
    }

    @VisibleForTesting
    public IMetaStoreClient getHmsClient() {
        return this.client;
    }

    private FieldSchema convertToFieldSchema(DataField dataField) {
        return new FieldSchema(dataField.name(), HiveTypeUtils.toTypeInfo(dataField.type()).getTypeName(), dataField.description());
    }

    private SchemaManager schemaManager(Identifier identifier) {
        return new SchemaManager(this.fileIO, this.getDataTableLocation(identifier)).withLock(this.lock(identifier));
    }

    private Lock lock(Identifier identifier) {
        if (!this.lockEnabled()) {
            return new Lock.EmptyLock();
        }
        HiveCatalogLock lock = new HiveCatalogLock(this.client, HiveCatalogLock.checkMaxSleep(this.hiveConf), HiveCatalogLock.acquireTimeout(this.hiveConf));
        return Lock.fromCatalog(lock, identifier);
    }

    static IMetaStoreClient createClient(HiveConf hiveConf, String clientClassName) {
        return new RetryingMetaStoreClientFactory().createClient(hiveConf, clientClassName);
    }

    public static HiveConf createHiveConf(@Nullable String hiveConfDir, @Nullable String hadoopConfDir, Configuration defaultHadoopConf) {
        if (StringUtils.isNullOrWhitespaceOnly(hiveConfDir)) {
            hiveConfDir = HiveCatalog.possibleHiveConfPath();
        }
        Configuration hadoopConf = defaultHadoopConf;
        if (!StringUtils.isNullOrWhitespaceOnly(hadoopConfDir) && (hadoopConf = HiveCatalog.getHadoopConfiguration(hadoopConfDir)) == null) {
            String possiableUsedConfFiles = "core-site.xml | hdfs-site.xml | yarn-site.xml | mapred-site.xml";
            throw new RuntimeException("Failed to load the hadoop conf from specified path:" + hadoopConfDir, new FileNotFoundException("Please check the path none of the conf files (" + possiableUsedConfFiles + ") exist in the folder."));
        }
        LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
        if (hiveConfDir != null) {
            HiveConf.setHiveSiteLocation(null);
            HiveConf.setLoadMetastoreConfig((boolean)false);
            HiveConf.setLoadHiveServer2Config((boolean)false);
            HiveConf hiveConf = new HiveConf(hadoopConf, HiveConf.class);
            org.apache.hadoop.fs.Path hiveSite = new org.apache.hadoop.fs.Path(hiveConfDir, HIVE_SITE_FILE);
            if (!hiveSite.toUri().isAbsolute()) {
                hiveSite = new org.apache.hadoop.fs.Path(new File(hiveSite.toString()).toURI());
            }
            try (FSDataInputStream inputStream = hiveSite.getFileSystem(hadoopConf).open(hiveSite);){
                hiveConf.addResource((InputStream)inputStream, hiveSite.toString());
                hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load hive-site.xml from specified path:" + hiveSite, e);
            }
            hiveConf.addResource(hiveSite);
            return hiveConf;
        }
        HiveConf hiveConf = new HiveConf(hadoopConf, HiveConf.class);
        URL hiveSite = Thread.currentThread().getContextClassLoader().getResource(HIVE_SITE_FILE);
        if (hiveSite != null) {
            LOG.info("Found {} in classpath: {}", (Object)HIVE_SITE_FILE, (Object)hiveSite);
            hiveConf.addResource(hiveSite);
        }
        return hiveConf;
    }

    public static Catalog createHiveCatalog(CatalogContext context) {
        FileIO fileIO;
        Path warehouse;
        HiveConf hiveConf = HiveCatalog.createHiveConf(context);
        Options options = context.options();
        String warehouseStr = options.get(CatalogOptions.WAREHOUSE);
        if (warehouseStr == null) {
            warehouseStr = hiveConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, HiveConf.ConfVars.METASTOREWAREHOUSE.defaultStrVal);
        }
        Path uri = (warehouse = new Path(warehouseStr)).toUri().getScheme() == null ? new Path(FileSystem.getDefaultUri((Configuration)hiveConf)) : warehouse;
        try {
            fileIO = FileIO.get(uri, context);
            fileIO.checkOrMkdirs(warehouse);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Catalog catalog = new HiveCatalog(fileIO, hiveConf, options.get(HiveCatalogFactory.METASTORE_CLIENT_CLASS), options, warehouse.toUri().toString());
        FileBasedPrivilegeManager privilegeManager = new FileBasedPrivilegeManager(warehouse.toString(), fileIO, context.options().get(PrivilegedCatalog.USER), context.options().get(PrivilegedCatalog.PASSWORD));
        if (privilegeManager.privilegeEnabled()) {
            catalog = new PrivilegedCatalog(catalog, privilegeManager);
        }
        return catalog;
    }

    public static HiveConf createHiveConf(CatalogContext context) {
        String uri = context.options().get(CatalogOptions.URI);
        String hiveConfDir = context.options().get(HiveCatalogOptions.HIVE_CONF_DIR);
        String hadoopConfDir = context.options().get(HiveCatalogOptions.HADOOP_CONF_DIR);
        HiveConf hiveConf = HiveCatalog.createHiveConf(hiveConfDir, hadoopConfDir, context.hadoopConf());
        context.options().toMap().forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        if (uri != null) {
            hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, uri);
        }
        if (hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname) == null) {
            LOG.error("Can't find hive metastore uri to connect:  either set " + CatalogOptions.URI.key() + " for paimon " + "hive" + " catalog or set hive.metastore.uris in hive-site.xml or hadoop configurations. Will use empty metastore uris, which means we may use a embedded metastore. The may cause unpredictable consensus problem.");
        }
        return hiveConf;
    }

    public static Configuration getHadoopConfiguration(String hadoopConfDir) {
        if (new File(hadoopConfDir).exists()) {
            File mapredSite;
            File yarnSite;
            File hdfsSite;
            ArrayList<File> possiableConfFiles = new ArrayList<File>();
            File coreSite = new File(hadoopConfDir, "core-site.xml");
            if (coreSite.exists()) {
                possiableConfFiles.add(coreSite);
            }
            if ((hdfsSite = new File(hadoopConfDir, "hdfs-site.xml")).exists()) {
                possiableConfFiles.add(hdfsSite);
            }
            if ((yarnSite = new File(hadoopConfDir, "yarn-site.xml")).exists()) {
                possiableConfFiles.add(yarnSite);
            }
            if ((mapredSite = new File(hadoopConfDir, "mapred-site.xml")).exists()) {
                possiableConfFiles.add(mapredSite);
            }
            if (possiableConfFiles.isEmpty()) {
                return null;
            }
            Configuration hadoopConfiguration = new Configuration();
            for (File confFile : possiableConfFiles) {
                hadoopConfiguration.addResource(new org.apache.hadoop.fs.Path(confFile.getAbsolutePath()));
            }
            return hadoopConfiguration;
        }
        return null;
    }

    public static String possibleHiveConfPath() {
        return System.getenv("HIVE_CONF_DIR");
    }
}

