/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableIdentifier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;

public class ConvertStructUtil {
    public static TableMetaBuilder newTableMetaBuilder(TableIdentifier identifier, Schema schema) {
        return new TableMetaBuilder(identifier, schema);
    }

    public static class TableMetaBuilder {
        TableMeta meta = new TableMeta();
        Schema schema;
        Map<String, String> properties = new HashMap<String, String>();
        Map<String, String> locations = new HashMap<String, String>();
        TableFormat format;

        public TableMetaBuilder(TableIdentifier identifier, Schema schema) {
            this.meta.setTableIdentifier(identifier.buildTableIdentifier());
            this.schema = schema;
        }

        public TableMetaBuilder withPrimaryKeySpec(PrimaryKeySpec keySpec) {
            if (keySpec == null) {
                return this;
            }
            org.apache.amoro.api.PrimaryKeySpec primaryKeySpec = new org.apache.amoro.api.PrimaryKeySpec();
            List<String> fields = keySpec.primaryKeyStruct().fields().stream().map(Types.NestedField::name).collect(Collectors.toList());
            primaryKeySpec.setFields(fields);
            this.meta.setKeySpec(primaryKeySpec);
            return this;
        }

        public TableMetaBuilder withTableLocation(String location) {
            this.locations.put("table", location);
            return this;
        }

        public TableMetaBuilder withBaseLocation(String baseLocation) {
            this.locations.put("base", baseLocation);
            return this;
        }

        public TableMetaBuilder withChangeLocation(String changeLocation) {
            this.locations.put("change", changeLocation);
            return this;
        }

        public TableMetaBuilder withProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public TableMetaBuilder withProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public TableMetaBuilder withFormat(TableFormat format) {
            this.format = format;
            return this;
        }

        public TableMeta build() {
            Preconditions.checkNotNull((Object)((Object)this.format), (Object)"table format must set.");
            this.meta.setLocations(this.locations);
            this.meta.setProperties(this.properties);
            this.meta.setFormat(this.format.name());
            return this.meta;
        }
    }
}

