/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table.blocker;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.amoro.AmsClient;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.NoSuchObjectException;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.blocker.Blocker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewableBlocker
implements Blocker {
    private static final Logger LOG = LoggerFactory.getLogger(RenewableBlocker.class);
    public static final String CREATE_TIME_PROPERTY = "create.time";
    public static final String EXPIRATION_TIME_PROPERTY = "expiration.time";
    public static final String BLOCKER_TIMEOUT = "blocker.timeout";
    private static volatile ScheduledExecutorService EXECUTOR;
    private final String blockerId;
    private final List<BlockableOperation> operations;
    private final long createTime;
    private long expirationTime;
    private final long blockerTimeout;
    private final Map<String, String> properties;
    private final TableIdentifier tableIdentifier;
    private final AmsClient amsClient;
    private volatile ScheduledFuture<?> renewTaskFuture;

    public RenewableBlocker(String blockerId, List<BlockableOperation> operations, long createTime, long expirationTime, long blockerTimeout, Map<String, String> properties, TableIdentifier tableIdentifier, AmsClient amsClient) {
        Preconditions.checkArgument((blockerTimeout > 0L ? 1 : 0) != 0, (Object)"blockerTimeout must > 0");
        this.blockerId = blockerId;
        this.operations = operations;
        this.createTime = createTime;
        this.expirationTime = expirationTime;
        this.blockerTimeout = blockerTimeout;
        this.properties = properties;
        this.tableIdentifier = tableIdentifier;
        this.amsClient = amsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScheduledExecutorService getExecutorService() {
        if (EXECUTOR != null) return EXECUTOR;
        Class<RenewableBlocker> clazz = RenewableBlocker.class;
        synchronized (RenewableBlocker.class) {
            if (EXECUTOR != null) return EXECUTOR;
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("renew-blocker-thread-%d").build();
            EXECUTOR = Executors.newSingleThreadScheduledExecutor(threadFactory);
            // ** MonitorExit[var0] (shouldn't be in output)
            return EXECUTOR;
        }
    }

    public void renewAsync() {
        this.cancelRenew();
        long interval = this.blockerTimeout / 5L;
        this.renewTaskFuture = RenewableBlocker.getExecutorService().scheduleAtFixedRate(this::doRenew, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void doRenew() {
        try {
            this.expirationTime = this.amsClient.renewBlocker(this.tableIdentifier.buildTableIdentifier(), this.blockerId());
            LOG.info("renew blocker {} success of {}", (Object)this.blockerId(), (Object)this.tableIdentifier);
        }
        catch (NoSuchObjectException e) {
            this.cancelRenew();
        }
        catch (Throwable t) {
            LOG.warn("failed to renew block {} of table {}, ignore", new Object[]{this.blockerId(), this.tableIdentifier, t});
        }
    }

    public void cancelRenew() {
        if (this.renewTaskFuture != null) {
            this.renewTaskFuture.cancel(true);
            LOG.info("blocker released, blocker {} of {}", (Object)this.blockerId(), (Object)this.tableIdentifier);
            this.renewTaskFuture = null;
        }
    }

    @Override
    public String blockerId() {
        return this.blockerId;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public List<BlockableOperation> operations() {
        return this.operations;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getBlockerTimeout() {
        return this.blockerTimeout;
    }

    public TableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public String toString() {
        return "BaseBlocker{blockerId='" + this.blockerId + '\'' + ", operations=" + this.operations + ", createTime=" + this.createTime + ", expirationTime=" + this.expirationTime + ", properties=" + this.properties + '}';
    }
}

