/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.mixed;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.amoro.AmsClient;
import org.apache.amoro.PooledAmsClient;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.TableTrashManagers;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.mixed.MixedTables;
import org.apache.amoro.op.CreateTableTransaction;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableBuilder;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.table.blocker.BasicTableBlockerManager;
import org.apache.amoro.table.blocker.TableBlockerManager;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;

public class BasicMixedIcebergCatalog
implements MixedFormatCatalog {
    private Catalog icebergCatalog;
    private TableMetaStore tableMetaStore;
    private Map<String, String> catalogProperties;
    private String name;
    private Pattern databaseFilterPattern;
    private AmsClient client;
    private MixedTables tables;
    private SupportsNamespaces asNamespaceCatalog;

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void initialize(String name, Map<String, String> properties, TableMetaStore metaStore) {
        Pattern databaseFilterPattern = null;
        if (properties.containsKey("database-filter")) {
            String databaseFilter = properties.get("database-filter");
            databaseFilterPattern = Pattern.compile(databaseFilter);
        }
        Catalog catalog = this.buildIcebergCatalog(name, properties, metaStore.getConfiguration());
        this.name = name;
        this.tableMetaStore = metaStore;
        this.icebergCatalog = MixedCatalogUtil.buildCacheCatalog(catalog, properties);
        if (catalog instanceof SupportsNamespaces) {
            this.asNamespaceCatalog = (SupportsNamespaces)catalog;
        }
        this.databaseFilterPattern = databaseFilterPattern;
        this.catalogProperties = properties;
        this.tables = this.newMixedTables(metaStore, properties, this.icebergCatalog());
        if (properties.containsKey("ams.uri")) {
            this.client = new PooledAmsClient(properties.get("ams.uri"));
        }
    }

    @Override
    public List<String> listDatabases() {
        List databases = this.tableMetaStore.doAs(() -> this.asNamespaceCatalog().listNamespaces(Namespace.empty()).stream().map(namespace -> namespace.level(0)).distinct().collect(Collectors.toList()));
        if (this.databaseFilterPattern == null) {
            return databases;
        }
        return databases.stream().filter(database -> this.databaseFilterPattern.matcher((CharSequence)database).matches()).collect(Collectors.toList());
    }

    @Override
    public void createDatabase(String database) {
        this.asNamespaceCatalog().createNamespace(Namespace.of((String[])new String[]{database}));
    }

    @Override
    public void dropDatabase(String databaseName) {
        this.asNamespaceCatalog().dropNamespace(Namespace.of((String[])new String[]{databaseName}));
    }

    @Override
    public List<org.apache.amoro.table.TableIdentifier> listTables(String database) {
        List icebergTableList = this.tableMetaStore.doAs(() -> this.icebergCatalog().listTables(Namespace.of((String[])new String[]{database})));
        ArrayList mixedTables = Lists.newArrayList();
        HashSet visited = Sets.newHashSet();
        for (TableIdentifier identifier : icebergTableList) {
            Table table;
            if (visited.contains(identifier) || !this.tables.isBaseStore(table = this.tableMetaStore.doAs(() -> this.icebergCatalog().loadTable(identifier)))) continue;
            mixedTables.add(org.apache.amoro.table.TableIdentifier.of(this.name(), database, identifier.name()));
            visited.add(identifier);
            PrimaryKeySpec keySpec = TablePropertyUtil.parsePrimaryKeySpec(table.schema(), table.properties());
            if (!keySpec.primaryKeyExisted()) continue;
            visited.add(this.tables.parseChangeIdentifier(table));
        }
        return mixedTables;
    }

    @Override
    public MixedTable loadTable(org.apache.amoro.table.TableIdentifier tableIdentifier) {
        Table base = this.tableMetaStore.doAs(() -> this.icebergCatalog().loadTable(this.toIcebergTableIdentifier(tableIdentifier)));
        if (!this.tables.isBaseStore(base)) {
            throw new NoSuchTableException("table " + base.name() + " is not a mixed iceberg table", new Object[0]);
        }
        return this.tables.loadTable(base, tableIdentifier);
    }

    @Override
    public void renameTable(org.apache.amoro.table.TableIdentifier from, String newTableName) {
        throw new UnsupportedOperationException("rename table is not supported");
    }

    @Override
    public boolean dropTable(org.apache.amoro.table.TableIdentifier tableIdentifier, boolean purge) {
        MixedTable table;
        try {
            table = this.loadTable(tableIdentifier);
        }
        catch (NoSuchTableException e) {
            return false;
        }
        String customTrashLocation = table.properties().get("table-trash.custom-root-location");
        AuthenticatedFileIO io = table.io();
        if (customTrashLocation != null) {
            String trashParentLocation = TableTrashManagers.getTrashParentLocation(tableIdentifier, customTrashLocation);
            if (io.supportFileSystemOperations() && io.exists(trashParentLocation)) {
                io.asPrefixFileIO().deletePrefix(trashParentLocation);
            }
        }
        return this.tables.dropTable(table, purge);
    }

    @Override
    public TableBuilder newTableBuilder(org.apache.amoro.table.TableIdentifier identifier, Schema schema) {
        return new MixedIcebergTableBuilder(identifier, schema);
    }

    @Override
    public TableBlockerManager getTableBlockerManager(org.apache.amoro.table.TableIdentifier tableIdentifier) {
        if (this.client == null) {
            throw new UnsupportedOperationException("AMSClient is not initialized");
        }
        return BasicTableBlockerManager.build(tableIdentifier, this.client);
    }

    @Override
    public Map<String, String> properties() {
        return Maps.newHashMap(this.catalogProperties);
    }

    protected Catalog icebergCatalog() {
        return this.icebergCatalog;
    }

    protected Catalog buildIcebergCatalog(String name, Map<String, String> properties, Configuration hadoopConf) {
        return CatalogUtil.buildIcebergCatalog((String)name, properties, (Object)hadoopConf);
    }

    protected MixedTables newMixedTables(TableMetaStore metaStore, Map<String, String> catalogProperties, Catalog icebergCatalog) {
        return new MixedTables(metaStore, catalogProperties, icebergCatalog);
    }

    private TableIdentifier toIcebergTableIdentifier(org.apache.amoro.table.TableIdentifier identifier) {
        return TableIdentifier.of((String[])new String[]{identifier.getDatabase(), identifier.getTableName()});
    }

    private SupportsNamespaces asNamespaceCatalog() {
        if (this.asNamespaceCatalog == null) {
            throw new UnsupportedOperationException(String.format("Iceberg catalog: %s doesn't implement SupportsNamespaces", this.icebergCatalog().getClass().getName()));
        }
        return this.asNamespaceCatalog;
    }

    private class MixedIcebergTableBuilder
    implements TableBuilder {
        private final org.apache.amoro.table.TableIdentifier identifier;
        private final Schema schema;
        private PartitionSpec partitionSpec;
        private Map<String, String> properties;
        private PrimaryKeySpec primaryKeySpec;

        public MixedIcebergTableBuilder(org.apache.amoro.table.TableIdentifier identifier, Schema schema) {
            this.identifier = identifier;
            this.schema = schema;
            this.partitionSpec = PartitionSpec.unpartitioned();
            this.properties = Maps.newHashMap();
            this.primaryKeySpec = PrimaryKeySpec.noPrimaryKey();
        }

        @Override
        public TableBuilder withPartitionSpec(PartitionSpec partitionSpec) {
            this.partitionSpec = partitionSpec;
            return this;
        }

        @Override
        public TableBuilder withSortOrder(SortOrder sortOrder) {
            if (sortOrder.isSorted()) {
                throw new UnsupportedOperationException("SortOrder is not supported by mixed-iceberg format");
            }
            return this;
        }

        @Override
        public TableBuilder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public TableBuilder withProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        @Override
        public TableBuilder withPrimaryKeySpec(PrimaryKeySpec primaryKeySpec) {
            this.primaryKeySpec = primaryKeySpec;
            return this;
        }

        @Override
        public MixedTable create() {
            return BasicMixedIcebergCatalog.this.tables.createTable(this.identifier, this.schema, this.partitionSpec, this.primaryKeySpec, this.properties);
        }

        @Override
        public Transaction createTransaction() {
            Transaction transaction = BasicMixedIcebergCatalog.this.icebergCatalog().newCreateTableTransaction(TableIdentifier.of((String[])new String[]{this.identifier.getDatabase(), this.identifier.getTableName()}), this.schema, this.partitionSpec, this.properties);
            return new CreateTableTransaction(transaction, this::create, () -> BasicMixedIcebergCatalog.this.dropTable(this.identifier, true));
        }
    }
}

