/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public class TableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PAIMON_07_VERSION = 1;
    public static final int CURRENT_VERSION = 2;
    private final int version;
    private final long id;
    private final List<DataField> fields;
    private final int highestFieldId;
    private final List<String> partitionKeys;
    private final List<String> primaryKeys;
    private final Map<String, String> options;
    @Nullable
    private final String comment;
    private final long timeMillis;

    public TableSchema(long id, List<DataField> fields, int highestFieldId, List<String> partitionKeys, List<String> primaryKeys, Map<String, String> options, @Nullable String comment) {
        this(2, id, fields, highestFieldId, partitionKeys, primaryKeys, options, comment, System.currentTimeMillis());
    }

    public TableSchema(int version, long id, List<DataField> fields, int highestFieldId, List<String> partitionKeys, List<String> primaryKeys, Map<String, String> options, @Nullable String comment, long timeMillis) {
        this.version = version;
        this.id = id;
        this.fields = fields;
        this.highestFieldId = highestFieldId;
        this.partitionKeys = partitionKeys;
        this.primaryKeys = primaryKeys;
        this.options = Collections.unmodifiableMap(options);
        this.comment = comment;
        this.timeMillis = timeMillis;
        this.trimmedPrimaryKeys();
        this.originalBucketKeys();
    }

    public int version() {
        return this.version;
    }

    public long id() {
        return this.id;
    }

    public List<DataField> fields() {
        return this.fields;
    }

    public List<String> fieldNames() {
        return this.fields.stream().map(DataField::name).collect(Collectors.toList());
    }

    public int highestFieldId() {
        return this.highestFieldId;
    }

    public List<String> partitionKeys() {
        return this.partitionKeys;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public List<String> trimmedPrimaryKeys() {
        if (this.primaryKeys.size() > 0) {
            List<String> adjusted = this.primaryKeys.stream().filter(pk -> !this.partitionKeys.contains(pk)).collect(Collectors.toList());
            Preconditions.checkState(adjusted.size() > 0, String.format("Primary key constraint %s should not be same with partition fields %s, this will result in only one record in a partition", this.primaryKeys, this.partitionKeys));
            return adjusted;
        }
        return this.primaryKeys;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public List<String> bucketKeys() {
        List<String> bucketKeys = this.originalBucketKeys();
        if (bucketKeys.isEmpty()) {
            bucketKeys = this.trimmedPrimaryKeys();
        }
        if (bucketKeys.isEmpty()) {
            bucketKeys = this.fieldNames();
        }
        return bucketKeys;
    }

    public boolean crossPartitionUpdate() {
        if (this.primaryKeys.isEmpty() || this.partitionKeys.isEmpty()) {
            return false;
        }
        return !this.primaryKeys.containsAll(this.partitionKeys);
    }

    private List<String> originalBucketKeys() {
        String key = this.options.get(CoreOptions.BUCKET_KEY.key());
        if (StringUtils.isNullOrWhitespaceOnly(key)) {
            return Collections.emptyList();
        }
        List<String> bucketKeys = Arrays.asList(key.split(","));
        if (!this.containsAll(this.fieldNames(), bucketKeys)) {
            throw new RuntimeException(String.format("Field names %s should contains all bucket keys %s.", this.fieldNames(), bucketKeys));
        }
        if (bucketKeys.stream().anyMatch(this.partitionKeys::contains)) {
            throw new RuntimeException(String.format("Bucket keys %s should not in partition keys %s.", bucketKeys, this.partitionKeys));
        }
        if (this.primaryKeys.size() > 0 && !this.containsAll(this.primaryKeys, bucketKeys)) {
            throw new RuntimeException(String.format("Primary keys %s should contains all bucket keys %s.", this.primaryKeys, bucketKeys));
        }
        return bucketKeys;
    }

    private boolean containsAll(List<String> all, List<String> contains) {
        return new HashSet<String>(all).containsAll(new HashSet<String>(contains));
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public long timeMillis() {
        return this.timeMillis;
    }

    public RowType logicalRowType() {
        return new RowType(this.fields);
    }

    public RowType logicalPartitionType() {
        return this.projectedLogicalRowType(this.partitionKeys);
    }

    public RowType logicalBucketKeyType() {
        return this.projectedLogicalRowType(this.bucketKeys());
    }

    public RowType logicalTrimmedPrimaryKeysType() {
        return this.projectedLogicalRowType(this.trimmedPrimaryKeys());
    }

    public RowType logicalPrimaryKeysType() {
        return this.projectedLogicalRowType(this.primaryKeys());
    }

    public List<DataField> primaryKeysFields() {
        return this.projectedDataFields(this.primaryKeys());
    }

    public List<DataField> trimmedPrimaryKeysFields() {
        return this.projectedDataFields(this.trimmedPrimaryKeys());
    }

    public int[] projection(List<String> projectedFieldNames) {
        List<String> fieldNames = this.fieldNames();
        return projectedFieldNames.stream().mapToInt(fieldNames::indexOf).toArray();
    }

    private List<DataField> projectedDataFields(List<String> projectedFieldNames) {
        List<String> fieldNames = this.fieldNames();
        return projectedFieldNames.stream().map(k -> this.fields.get(fieldNames.indexOf(k))).collect(Collectors.toList());
    }

    public RowType projectedLogicalRowType(List<String> projectedFieldNames) {
        return new RowType(this.projectedDataFields(projectedFieldNames));
    }

    public TableSchema copy(Map<String, String> newOptions) {
        return new TableSchema(this.version, this.id, this.fields, this.highestFieldId, this.partitionKeys, this.primaryKeys, newOptions, this.comment, this.timeMillis);
    }

    public static TableSchema fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, TableSchema.class);
    }

    public String toString() {
        return JsonSerdeUtil.toJson(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema tableSchema = (TableSchema)o;
        return this.version == tableSchema.version && Objects.equals(this.fields, tableSchema.fields) && Objects.equals(this.partitionKeys, tableSchema.partitionKeys) && Objects.equals(this.primaryKeys, tableSchema.primaryKeys) && Objects.equals(this.options, tableSchema.options) && Objects.equals(this.comment, tableSchema.comment) && this.timeMillis == tableSchema.timeMillis;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.fields, this.partitionKeys, this.primaryKeys, this.options, this.comment, this.timeMillis);
    }

    public static List<DataField> newFields(RowType rowType) {
        return rowType.getFields();
    }
}

