/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.mergetree.DropDeleteReader;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.MergeTreeReaders;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.AbstractCompactRewriter;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.ReducerMergeFunctionWrapper;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.utils.FieldsComparator;

public class MergeTreeCompactRewriter
extends AbstractCompactRewriter {
    protected final FileReaderFactory<KeyValue> readerFactory;
    protected final KeyValueFileWriterFactory writerFactory;
    protected final Comparator<InternalRow> keyComparator;
    @Nullable
    protected final FieldsComparator userDefinedSeqComparator;
    protected final MergeFunctionFactory<KeyValue> mfFactory;
    protected final MergeSorter mergeSorter;

    public MergeTreeCompactRewriter(FileReaderFactory<KeyValue> readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter) {
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.keyComparator = keyComparator;
        this.userDefinedSeqComparator = userDefinedSeqComparator;
        this.mfFactory = mfFactory;
        this.mergeSorter = mergeSorter;
    }

    @Override
    public CompactResult rewrite(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        return this.rewriteCompaction(outputLevel, dropDelete, sections);
    }

    protected CompactResult rewriteCompaction(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        RollingFileWriter<KeyValue, DataFileMeta> writer = this.writerFactory.createRollingMergeTreeFileWriter(outputLevel);
        DropDeleteReader reader = this.readerForMergeTree(sections, new ReducerMergeFunctionWrapper(this.mfFactory.create()));
        if (dropDelete) {
            reader = new DropDeleteReader(reader);
        }
        writer.write((KeyValue)((Object)new RecordReaderIterator<KeyValue>(reader)));
        writer.close();
        List<DataFileMeta> before = MergeTreeCompactRewriter.extractFilesFromSections(sections);
        this.notifyRewriteCompactBefore(before);
        return new CompactResult(before, (List<DataFileMeta>)writer.result());
    }

    protected <T> RecordReader<T> readerForMergeTree(List<List<SortedRun>> sections, MergeFunctionWrapper<T> mergeFunctionWrapper) throws IOException {
        return MergeTreeReaders.readerForMergeTree(sections, this.readerFactory, this.keyComparator, this.userDefinedSeqComparator, mergeFunctionWrapper, this.mergeSorter);
    }

    protected void notifyRewriteCompactBefore(List<DataFileMeta> files) {
    }
}

