/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.FanoutDataWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.io.RollingDataWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.CommitMetadata;
import org.apache.iceberg.spark.FileRewriteCoordinator;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkCleanupUtil;
import org.apache.iceberg.spark.source.SparkCopyOnWriteScan;
import org.apache.iceberg.spark.source.SparkFileWriterFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.connector.write.streaming.StreamingDataWriterFactory;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SparkWrite
implements Write,
RequiresDistributionAndOrdering {
    private static final Logger LOG = LoggerFactory.getLogger(SparkWrite.class);
    private final JavaSparkContext sparkContext;
    private final SparkWriteConf writeConf;
    private final Table table;
    private final String queryId;
    private final FileFormat format;
    private final String applicationId;
    private final boolean wapEnabled;
    private final String wapId;
    private final int outputSpecId;
    private final long targetFileSize;
    private final Schema writeSchema;
    private final StructType dsSchema;
    private final Map<String, String> extraSnapshotMetadata;
    private final boolean partitionedFanoutEnabled;
    private final Distribution requiredDistribution;
    private final SortOrder[] requiredOrdering;
    private boolean cleanupOnAbort = true;

    SparkWrite(SparkSession spark, Table table, SparkWriteConf writeConf, LogicalWriteInfo writeInfo, String applicationId, Schema writeSchema, StructType dsSchema, Distribution requiredDistribution, SortOrder[] requiredOrdering) {
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.writeConf = writeConf;
        this.queryId = writeInfo.queryId();
        this.format = writeConf.dataFileFormat();
        this.applicationId = applicationId;
        this.wapEnabled = writeConf.wapEnabled();
        this.wapId = writeConf.wapId();
        this.targetFileSize = writeConf.targetDataFileSize();
        this.writeSchema = writeSchema;
        this.dsSchema = dsSchema;
        this.extraSnapshotMetadata = writeConf.extraSnapshotMetadata();
        this.partitionedFanoutEnabled = writeConf.fanoutWriterEnabled();
        this.requiredDistribution = requiredDistribution;
        this.requiredOrdering = requiredOrdering;
        this.outputSpecId = writeConf.outputSpecId();
    }

    public Distribution requiredDistribution() {
        return this.requiredDistribution;
    }

    public SortOrder[] requiredOrdering() {
        return this.requiredOrdering;
    }

    BatchWrite asBatchAppend() {
        return new BatchAppend();
    }

    BatchWrite asDynamicOverwrite() {
        return new DynamicOverwrite();
    }

    BatchWrite asOverwriteByFilter(Expression overwriteExpr) {
        return new OverwriteByFilter(overwriteExpr);
    }

    BatchWrite asCopyOnWriteOperation(SparkCopyOnWriteScan scan, IsolationLevel isolationLevel) {
        return new CopyOnWriteOperation(scan, isolationLevel);
    }

    BatchWrite asRewrite(String fileSetID) {
        return new RewriteFiles(fileSetID);
    }

    StreamingWrite asStreamingAppend() {
        return new StreamingAppend();
    }

    StreamingWrite asStreamingOverwrite() {
        return new StreamingOverwrite();
    }

    private WriterFactory createWriterFactory() {
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(this.table));
        return new WriterFactory((Broadcast<Table>)tableBroadcast, this.queryId, this.format, this.outputSpecId, this.targetFileSize, this.writeSchema, this.dsSchema, this.partitionedFanoutEnabled);
    }

    private void commitOperation(SnapshotUpdate<?> operation, String description) {
        LOG.info("Committing {} to table {}", (Object)description, (Object)this.table);
        if (this.applicationId != null) {
            operation.set("spark.app.id", this.applicationId);
        }
        if (!this.extraSnapshotMetadata.isEmpty()) {
            this.extraSnapshotMetadata.forEach((arg_0, arg_1) -> operation.set(arg_0, arg_1));
        }
        if (!CommitMetadata.commitProperties().isEmpty()) {
            CommitMetadata.commitProperties().forEach((arg_0, arg_1) -> operation.set(arg_0, arg_1));
        }
        if (this.wapEnabled && this.wapId != null) {
            operation.set("wap.id", this.wapId);
            operation.stageOnly();
        }
        try {
            long start = System.currentTimeMillis();
            operation.commit();
            long duration = System.currentTimeMillis() - start;
            LOG.info("Committed in {} ms", (Object)duration);
        }
        catch (CommitStateUnknownException commitStateUnknownException) {
            this.cleanupOnAbort = false;
            throw commitStateUnknownException;
        }
    }

    private void abort(WriterCommitMessage[] messages) {
        if (this.cleanupOnAbort) {
            SparkCleanupUtil.deleteFiles("job abort", this.table.io(), this.files(messages));
        } else {
            LOG.warn("Skipping cleanup of written files");
        }
    }

    private List<DataFile> files(WriterCommitMessage[] messages) {
        ArrayList files = Lists.newArrayList();
        for (WriterCommitMessage message : messages) {
            if (message == null) continue;
            TaskCommit taskCommit = (TaskCommit)message;
            files.addAll(Arrays.asList(taskCommit.files()));
        }
        return files;
    }

    public String toString() {
        return String.format("IcebergWrite(table=%s, format=%s)", this.table, this.format);
    }

    private static class PartitionedDataWriter
    implements DataWriter<InternalRow> {
        private final PartitioningWriter<InternalRow, DataWriteResult> delegate;
        private final FileIO io;
        private final PartitionSpec spec;
        private final PartitionKey partitionKey;
        private final InternalRowWrapper internalRowWrapper;

        private PartitionedDataWriter(SparkFileWriterFactory writerFactory, OutputFileFactory fileFactory, FileIO io, PartitionSpec spec, Schema dataSchema, StructType dataSparkType, long targetFileSize, boolean fanoutEnabled) {
            this.delegate = fanoutEnabled ? new FanoutDataWriter((FileWriterFactory)writerFactory, fileFactory, io, targetFileSize) : new ClusteredDataWriter((FileWriterFactory)writerFactory, fileFactory, io, targetFileSize);
            this.io = io;
            this.spec = spec;
            this.partitionKey = new PartitionKey(spec, dataSchema);
            this.internalRowWrapper = new InternalRowWrapper(dataSparkType);
        }

        public void write(InternalRow row) throws IOException {
            this.partitionKey.partition((StructLike)this.internalRowWrapper.wrap(row));
            this.delegate.write((Object)row, this.spec, (StructLike)this.partitionKey);
        }

        public WriterCommitMessage commit() throws IOException {
            this.close();
            DataWriteResult result = (DataWriteResult)this.delegate.result();
            TaskCommit taskCommit = new TaskCommit(result.dataFiles().toArray(new DataFile[0]));
            taskCommit.reportOutputMetrics();
            return taskCommit;
        }

        public void abort() throws IOException {
            this.close();
            DataWriteResult result = (DataWriteResult)this.delegate.result();
            SparkCleanupUtil.deleteTaskFiles(this.io, result.dataFiles());
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static class UnpartitionedDataWriter
    implements DataWriter<InternalRow> {
        private final FileWriter<InternalRow, DataWriteResult> delegate;
        private final FileIO io;

        private UnpartitionedDataWriter(SparkFileWriterFactory writerFactory, OutputFileFactory fileFactory, FileIO io, PartitionSpec spec, long targetFileSize) {
            this.delegate = new RollingDataWriter((FileWriterFactory)writerFactory, fileFactory, io, targetFileSize, spec, null);
            this.io = io;
        }

        public void write(InternalRow record) throws IOException {
            this.delegate.write((Object)record);
        }

        public WriterCommitMessage commit() throws IOException {
            this.close();
            DataWriteResult result = (DataWriteResult)this.delegate.result();
            TaskCommit taskCommit = new TaskCommit(result.dataFiles().toArray(new DataFile[0]));
            taskCommit.reportOutputMetrics();
            return taskCommit;
        }

        public void abort() throws IOException {
            this.close();
            DataWriteResult result = (DataWriteResult)this.delegate.result();
            SparkCleanupUtil.deleteTaskFiles(this.io, result.dataFiles());
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static class WriterFactory
    implements DataWriterFactory,
    StreamingDataWriterFactory {
        private final Broadcast<Table> tableBroadcast;
        private final FileFormat format;
        private final int outputSpecId;
        private final long targetFileSize;
        private final Schema writeSchema;
        private final StructType dsSchema;
        private final boolean partitionedFanoutEnabled;
        private final String queryId;

        protected WriterFactory(Broadcast<Table> tableBroadcast, String queryId, FileFormat format, int outputSpecId, long targetFileSize, Schema writeSchema, StructType dsSchema, boolean partitionedFanoutEnabled) {
            this.tableBroadcast = tableBroadcast;
            this.format = format;
            this.outputSpecId = outputSpecId;
            this.targetFileSize = targetFileSize;
            this.writeSchema = writeSchema;
            this.dsSchema = dsSchema;
            this.partitionedFanoutEnabled = partitionedFanoutEnabled;
            this.queryId = queryId;
        }

        public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
            return this.createWriter(partitionId, taskId, 0L);
        }

        public DataWriter<InternalRow> createWriter(int partitionId, long taskId, long epochId) {
            Table table = (Table)this.tableBroadcast.value();
            PartitionSpec spec = (PartitionSpec)table.specs().get(this.outputSpecId);
            FileIO io = table.io();
            OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).format(this.format).operationId(this.queryId).build();
            SparkFileWriterFactory writerFactory = SparkFileWriterFactory.builderFor(table).dataFileFormat(this.format).dataSchema(this.writeSchema).dataSparkType(this.dsSchema).build();
            if (spec.isUnpartitioned()) {
                return new UnpartitionedDataWriter(writerFactory, fileFactory, io, spec, this.targetFileSize);
            }
            return new PartitionedDataWriter(writerFactory, fileFactory, io, spec, this.writeSchema, this.dsSchema, this.targetFileSize, this.partitionedFanoutEnabled);
        }
    }

    public static class TaskCommit
    implements WriterCommitMessage {
        private final DataFile[] taskFiles;

        TaskCommit(DataFile[] taskFiles) {
            this.taskFiles = taskFiles;
        }

        void reportOutputMetrics() {
            long bytesWritten = 0L;
            long recordsWritten = 0L;
            for (DataFile dataFile : this.taskFiles) {
                bytesWritten += dataFile.fileSizeInBytes();
                recordsWritten += dataFile.recordCount();
            }
            TaskContext taskContext = TaskContext$.MODULE$.get();
            if (taskContext != null) {
                OutputMetrics outputMetrics = taskContext.taskMetrics().outputMetrics();
                outputMetrics.setBytesWritten(bytesWritten);
                outputMetrics.setRecordsWritten(recordsWritten);
            }
        }

        DataFile[] files() {
            return this.taskFiles;
        }
    }

    private class StreamingOverwrite
    extends BaseStreamingWrite {
        private StreamingOverwrite() {
        }

        @Override
        protected String mode() {
            return "complete";
        }

        @Override
        public void doCommit(long epochId, WriterCommitMessage[] messages) {
            OverwriteFiles overwriteFiles = SparkWrite.this.table.newOverwrite();
            overwriteFiles.overwriteByRowFilter((Expression)Expressions.alwaysTrue());
            int numFiles = 0;
            for (DataFile file : SparkWrite.this.files(messages)) {
                overwriteFiles.addFile(file);
                ++numFiles;
            }
            this.commit(overwriteFiles, epochId, String.format("streaming complete overwrite with %d new data files", numFiles));
        }
    }

    private class StreamingAppend
    extends BaseStreamingWrite {
        private StreamingAppend() {
        }

        @Override
        protected String mode() {
            return "append";
        }

        @Override
        protected void doCommit(long epochId, WriterCommitMessage[] messages) {
            AppendFiles append = SparkWrite.this.table.newFastAppend();
            int numFiles = 0;
            for (DataFile file : SparkWrite.this.files(messages)) {
                append.appendFile(file);
                ++numFiles;
            }
            this.commit(append, epochId, String.format("streaming append with %d new data files", numFiles));
        }
    }

    private abstract class BaseStreamingWrite
    implements StreamingWrite {
        private static final String QUERY_ID_PROPERTY = "spark.sql.streaming.queryId";
        private static final String EPOCH_ID_PROPERTY = "spark.sql.streaming.epochId";

        private BaseStreamingWrite() {
        }

        protected abstract String mode();

        public StreamingDataWriterFactory createStreamingWriterFactory(PhysicalWriteInfo info) {
            return SparkWrite.this.createWriterFactory();
        }

        public final void commit(long epochId, WriterCommitMessage[] messages) {
            LOG.info("Committing epoch {} for query {} in {} mode", new Object[]{epochId, SparkWrite.this.queryId, this.mode()});
            SparkWrite.this.table.refresh();
            Long lastCommittedEpochId = this.findLastCommittedEpochId();
            if (lastCommittedEpochId != null && epochId <= lastCommittedEpochId) {
                LOG.info("Skipping epoch {} for query {} as it was already committed", (Object)epochId, (Object)SparkWrite.this.queryId);
                return;
            }
            this.doCommit(epochId, messages);
        }

        protected abstract void doCommit(long var1, WriterCommitMessage[] var3);

        protected <T> void commit(SnapshotUpdate<T> snapshotUpdate, long epochId, String description) {
            snapshotUpdate.set(QUERY_ID_PROPERTY, SparkWrite.this.queryId);
            snapshotUpdate.set(EPOCH_ID_PROPERTY, Long.toString(epochId));
            SparkWrite.this.commitOperation(snapshotUpdate, description);
        }

        private Long findLastCommittedEpochId() {
            Snapshot snapshot = SparkWrite.this.table.currentSnapshot();
            Long lastCommittedEpochId = null;
            while (snapshot != null) {
                Map summary = snapshot.summary();
                String snapshotQueryId = (String)summary.get(QUERY_ID_PROPERTY);
                if (SparkWrite.this.queryId.equals(snapshotQueryId)) {
                    lastCommittedEpochId = Long.valueOf((String)summary.get(EPOCH_ID_PROPERTY));
                    break;
                }
                Long parentSnapshotId = snapshot.parentId();
                snapshot = parentSnapshotId != null ? SparkWrite.this.table.snapshot(parentSnapshotId.longValue()) : null;
            }
            return lastCommittedEpochId;
        }

        public void abort(long epochId, WriterCommitMessage[] messages) {
            SparkWrite.this.abort(messages);
        }

        public String toString() {
            return String.format("IcebergStreamingWrite(table=%s, format=%s)", SparkWrite.this.table, SparkWrite.this.format);
        }
    }

    private class RewriteFiles
    extends BaseBatchWrite {
        private final String fileSetID;

        private RewriteFiles(String fileSetID) {
            this.fileSetID = fileSetID;
        }

        public void commit(WriterCommitMessage[] messages) {
            FileRewriteCoordinator coordinator = FileRewriteCoordinator.get();
            coordinator.stageRewrite(SparkWrite.this.table, this.fileSetID, (Set<DataFile>)ImmutableSet.copyOf((Collection)SparkWrite.this.files(messages)));
        }
    }

    private class CopyOnWriteOperation
    extends BaseBatchWrite {
        private final SparkCopyOnWriteScan scan;
        private final IsolationLevel isolationLevel;

        private CopyOnWriteOperation(SparkCopyOnWriteScan scan, IsolationLevel isolationLevel) {
            this.scan = scan;
            this.isolationLevel = isolationLevel;
        }

        private List<DataFile> overwrittenFiles() {
            return this.scan.files().stream().map(ContentScanTask::file).collect(Collectors.toList());
        }

        private Expression conflictDetectionFilter() {
            List<Expression> scanFilterExpressions = this.scan.filterExpressions();
            True filter = Expressions.alwaysTrue();
            for (Expression expr : scanFilterExpressions) {
                filter = Expressions.and((Expression)filter, (Expression)expr);
            }
            return filter;
        }

        public void commit(WriterCommitMessage[] messages) {
            OverwriteFiles overwriteFiles = SparkWrite.this.table.newOverwrite();
            List<DataFile> overwrittenFiles = this.overwrittenFiles();
            int numOverwrittenFiles = overwrittenFiles.size();
            for (DataFile overwrittenFile : overwrittenFiles) {
                overwriteFiles.deleteFile(overwrittenFile);
            }
            int numAddedFiles = 0;
            for (DataFile file : SparkWrite.this.files(messages)) {
                ++numAddedFiles;
                overwriteFiles.addFile(file);
            }
            if (this.isolationLevel == IsolationLevel.SERIALIZABLE) {
                this.commitWithSerializableIsolation(overwriteFiles, numOverwrittenFiles, numAddedFiles);
            } else if (this.isolationLevel == IsolationLevel.SNAPSHOT) {
                this.commitWithSnapshotIsolation(overwriteFiles, numOverwrittenFiles, numAddedFiles);
            } else {
                throw new IllegalArgumentException("Unsupported isolation level: " + this.isolationLevel);
            }
        }

        private void commitWithSerializableIsolation(OverwriteFiles overwriteFiles, int numOverwrittenFiles, int numAddedFiles) {
            Long scanSnapshotId = this.scan.snapshotId();
            if (scanSnapshotId != null) {
                overwriteFiles.validateFromSnapshot(scanSnapshotId.longValue());
            }
            Expression conflictDetectionFilter = this.conflictDetectionFilter();
            overwriteFiles.conflictDetectionFilter(conflictDetectionFilter);
            overwriteFiles.validateNoConflictingData();
            overwriteFiles.validateNoConflictingDeletes();
            String commitMsg = String.format("overwrite of %d data files with %d new data files, scanSnapshotId: %d, conflictDetectionFilter: %s", numOverwrittenFiles, numAddedFiles, scanSnapshotId, conflictDetectionFilter);
            SparkWrite.this.commitOperation((SnapshotUpdate)overwriteFiles, commitMsg);
        }

        private void commitWithSnapshotIsolation(OverwriteFiles overwriteFiles, int numOverwrittenFiles, int numAddedFiles) {
            Long scanSnapshotId = this.scan.snapshotId();
            if (scanSnapshotId != null) {
                overwriteFiles.validateFromSnapshot(scanSnapshotId.longValue());
            }
            Expression conflictDetectionFilter = this.conflictDetectionFilter();
            overwriteFiles.conflictDetectionFilter(conflictDetectionFilter);
            overwriteFiles.validateNoConflictingDeletes();
            String commitMsg = String.format("overwrite of %d data files with %d new data files", numOverwrittenFiles, numAddedFiles);
            SparkWrite.this.commitOperation((SnapshotUpdate)overwriteFiles, commitMsg);
        }
    }

    private class OverwriteByFilter
    extends BaseBatchWrite {
        private final Expression overwriteExpr;

        private OverwriteByFilter(Expression overwriteExpr) {
            this.overwriteExpr = overwriteExpr;
        }

        public void commit(WriterCommitMessage[] messages) {
            OverwriteFiles overwriteFiles = SparkWrite.this.table.newOverwrite();
            overwriteFiles.overwriteByRowFilter(this.overwriteExpr);
            int numFiles = 0;
            for (DataFile file : SparkWrite.this.files(messages)) {
                ++numFiles;
                overwriteFiles.addFile(file);
            }
            IsolationLevel isolationLevel = SparkWrite.this.writeConf.isolationLevel();
            Long validateFromSnapshotId = SparkWrite.this.writeConf.validateFromSnapshotId();
            if (isolationLevel != null && validateFromSnapshotId != null) {
                overwriteFiles.validateFromSnapshot(validateFromSnapshotId.longValue());
            }
            if (isolationLevel == IsolationLevel.SERIALIZABLE) {
                overwriteFiles.validateNoConflictingDeletes();
                overwriteFiles.validateNoConflictingData();
            } else if (isolationLevel == IsolationLevel.SNAPSHOT) {
                overwriteFiles.validateNoConflictingDeletes();
            }
            String commitMsg = String.format("overwrite by filter %s with %d new data files", this.overwriteExpr, numFiles);
            SparkWrite.this.commitOperation((SnapshotUpdate)overwriteFiles, commitMsg);
        }
    }

    private class DynamicOverwrite
    extends BaseBatchWrite {
        private DynamicOverwrite() {
        }

        public void commit(WriterCommitMessage[] messages) {
            List files = SparkWrite.this.files(messages);
            if (files.isEmpty()) {
                LOG.info("Dynamic overwrite is empty, skipping commit");
                return;
            }
            ReplacePartitions dynamicOverwrite = SparkWrite.this.table.newReplacePartitions();
            IsolationLevel isolationLevel = SparkWrite.this.writeConf.isolationLevel();
            Long validateFromSnapshotId = SparkWrite.this.writeConf.validateFromSnapshotId();
            if (isolationLevel != null && validateFromSnapshotId != null) {
                dynamicOverwrite.validateFromSnapshot(validateFromSnapshotId.longValue());
            }
            if (isolationLevel == IsolationLevel.SERIALIZABLE) {
                dynamicOverwrite.validateNoConflictingData();
                dynamicOverwrite.validateNoConflictingDeletes();
            } else if (isolationLevel == IsolationLevel.SNAPSHOT) {
                dynamicOverwrite.validateNoConflictingDeletes();
            }
            int numFiles = 0;
            for (DataFile file : files) {
                ++numFiles;
                dynamicOverwrite.addFile(file);
            }
            SparkWrite.this.commitOperation((SnapshotUpdate)dynamicOverwrite, String.format("dynamic partition overwrite with %d new data files", numFiles));
        }
    }

    private class BatchAppend
    extends BaseBatchWrite {
        private BatchAppend() {
        }

        public void commit(WriterCommitMessage[] messages) {
            AppendFiles append = SparkWrite.this.table.newAppend();
            int numFiles = 0;
            for (DataFile file : SparkWrite.this.files(messages)) {
                ++numFiles;
                append.appendFile(file);
            }
            SparkWrite.this.commitOperation((SnapshotUpdate)append, String.format("append with %d new data files", numFiles));
        }
    }

    private abstract class BaseBatchWrite
    implements BatchWrite {
        private BaseBatchWrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            return SparkWrite.this.createWriterFactory();
        }

        public void abort(WriterCommitMessage[] messages) {
            SparkWrite.this.abort(messages);
        }

        public String toString() {
            return String.format("IcebergBatchWrite(table=%s, format=%s)", SparkWrite.this.table, SparkWrite.this.format);
        }
    }
}

