/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.deletes.DeleteCounter;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedInputFile;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseReader<T, TaskT extends ScanTask>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseReader.class);
    private final Table table;
    private final Schema expectedSchema;
    private final boolean caseSensitive;
    private final NameMapping nameMapping;
    private final ScanTaskGroup<TaskT> taskGroup;
    private final Iterator<TaskT> tasks;
    private final DeleteCounter counter;
    private Map<String, InputFile> lazyInputFiles;
    private CloseableIterator<T> currentIterator;
    private T current = null;
    private TaskT currentTask = null;

    BaseReader(Table table, ScanTaskGroup<TaskT> taskGroup, Schema expectedSchema, boolean caseSensitive) {
        this.table = table;
        this.taskGroup = taskGroup;
        this.tasks = taskGroup.tasks().iterator();
        this.currentIterator = CloseableIterator.empty();
        this.expectedSchema = expectedSchema;
        this.caseSensitive = caseSensitive;
        String nameMappingString = (String)table.properties().get("schema.name-mapping.default");
        this.nameMapping = nameMappingString != null ? NameMappingParser.fromJson((String)nameMappingString) : null;
        this.counter = new DeleteCounter();
    }

    protected abstract CloseableIterator<T> open(TaskT var1);

    protected abstract Stream<ContentFile<?>> referencedFiles(TaskT var1);

    protected Schema expectedSchema() {
        return this.expectedSchema;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    protected NameMapping nameMapping() {
        return this.nameMapping;
    }

    protected Table table() {
        return this.table;
    }

    protected DeleteCounter counter() {
        return this.counter;
    }

    public boolean next() throws IOException {
        try {
            while (true) {
                if (this.currentIterator.hasNext()) {
                    this.current = this.currentIterator.next();
                    return true;
                }
                if (!this.tasks.hasNext()) break;
                this.currentIterator.close();
                this.currentTask = (ScanTask)this.tasks.next();
                this.currentIterator = this.open(this.currentTask);
            }
            this.currentIterator.close();
            return false;
        }
        catch (IOException | RuntimeException e) {
            if (this.currentTask != null && !this.currentTask.isDataTask()) {
                String filePaths = this.referencedFiles(this.currentTask).map(file -> file.path().toString()).collect(Collectors.joining(", "));
                LOG.error("Error reading file(s): {}", (Object)filePaths, (Object)e);
            }
            throw e;
        }
    }

    public T get() {
        return this.current;
    }

    @Override
    public void close() throws IOException {
        InputFileBlockHolder.unset();
        this.currentIterator.close();
        while (this.tasks.hasNext()) {
            this.tasks.next();
        }
    }

    protected InputFile getInputFile(String location) {
        return this.inputFiles().get(location);
    }

    private Map<String, InputFile> inputFiles() {
        if (this.lazyInputFiles == null) {
            Stream<EncryptedInputFile> encryptedFiles = this.taskGroup.tasks().stream().flatMap(this::referencedFiles).map(this::toEncryptedInputFile);
            Iterable decryptedFiles = this.table.encryption().decrypt(encryptedFiles::iterator);
            HashMap files = Maps.newHashMapWithExpectedSize((int)this.taskGroup.tasks().size());
            decryptedFiles.forEach(decrypted -> files.putIfAbsent(decrypted.location(), decrypted));
            this.lazyInputFiles = ImmutableMap.copyOf((Map)files);
        }
        return this.lazyInputFiles;
    }

    private EncryptedInputFile toEncryptedInputFile(ContentFile<?> file) {
        InputFile inputFile = this.table.io().newInputFile(file.path().toString());
        return EncryptedFiles.encryptedInput((InputFile)inputFile, (ByteBuffer)file.keyMetadata());
    }

    protected Map<Integer, ?> constantsMap(ContentScanTask<?> task, Schema readSchema) {
        if (readSchema.findField(0x7FFFFFFA) != null) {
            Types.StructType partitionType = Partitioning.partitionType((Table)this.table);
            return PartitionUtil.constantsMap(task, (Types.StructType)partitionType, BaseReader::convertConstant);
        }
        return PartitionUtil.constantsMap(task, BaseReader::convertConstant);
    }

    protected static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case DECIMAL: {
                return Decimal.apply((BigDecimal)((BigDecimal)value));
            }
            case STRING: {
                if (value instanceof Utf8) {
                    Utf8 utf8 = (Utf8)value;
                    return UTF8String.fromBytes((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength());
                }
                return UTF8String.fromString((String)value.toString());
            }
            case FIXED: {
                if (value instanceof byte[]) {
                    return value;
                }
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case BINARY: {
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case STRUCT: {
                Types.StructType structType = (Types.StructType)type;
                if (structType.fields().isEmpty()) {
                    return new GenericInternalRow();
                }
                List fields = structType.fields();
                Object[] values = new Object[fields.size()];
                StructLike struct = (StructLike)value;
                for (int index = 0; index < fields.size(); ++index) {
                    Types.NestedField field = (Types.NestedField)fields.get(index);
                    Type fieldType = field.type();
                    values[index] = BaseReader.convertConstant(fieldType, struct.get(index, fieldType.typeId().javaClass()));
                }
                return new GenericInternalRow(values);
            }
        }
        return value;
    }

    protected class SparkDeleteFilter
    extends DeleteFilter<InternalRow> {
        private final InternalRowWrapper asStructLike;

        SparkDeleteFilter(String filePath, List<DeleteFile> deletes, DeleteCounter counter) {
            super(filePath, deletes, BaseReader.this.table.schema(), BaseReader.this.expectedSchema, counter);
            this.asStructLike = new InternalRowWrapper(SparkSchemaUtil.convert(this.requiredSchema()));
        }

        protected StructLike asStructLike(InternalRow row) {
            return this.asStructLike.wrap(row);
        }

        protected InputFile getInputFile(String location) {
            return BaseReader.this.getInputFile(location);
        }

        protected void markRowDeleted(InternalRow row) {
            if (!row.getBoolean(this.columnIsDeletedPosition())) {
                row.setBoolean(this.columnIsDeletedPosition(), true);
                BaseReader.this.counter().increment();
            }
        }
    }
}

