/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.data.ParquetWithSparkSchemaVisitor;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.DecimalUtil;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkParquetWriters {
    private SparkParquetWriters() {
    }

    public static <T> ParquetValueWriter<T> buildWriter(StructType dfSchema, MessageType type) {
        return (ParquetValueWriter)ParquetWithSparkSchemaVisitor.visit((DataType)dfSchema, (Type)type, new WriteBuilder(type));
    }

    private static ParquetValueWriters.PrimitiveWriter<?> ints(DataType type, ColumnDescriptor desc) {
        if (type instanceof ByteType) {
            return ParquetValueWriters.tinyints((ColumnDescriptor)desc);
        }
        if (type instanceof ShortType) {
            return ParquetValueWriters.shorts((ColumnDescriptor)desc);
        }
        return ParquetValueWriters.ints((ColumnDescriptor)desc);
    }

    private static ParquetValueWriters.PrimitiveWriter<UTF8String> utf8Strings(ColumnDescriptor desc) {
        return new UTF8StringWriter(desc);
    }

    private static ParquetValueWriters.PrimitiveWriter<UTF8String> uuids(ColumnDescriptor desc) {
        return new UUIDWriter(desc);
    }

    private static ParquetValueWriters.PrimitiveWriter<Decimal> decimalAsInteger(ColumnDescriptor desc, int precision, int scale) {
        return new IntegerDecimalWriter(desc, precision, scale);
    }

    private static ParquetValueWriters.PrimitiveWriter<Decimal> decimalAsLong(ColumnDescriptor desc, int precision, int scale) {
        return new LongDecimalWriter(desc, precision, scale);
    }

    private static ParquetValueWriters.PrimitiveWriter<Decimal> decimalAsFixed(ColumnDescriptor desc, int precision, int scale) {
        return new FixedDecimalWriter(desc, precision, scale);
    }

    private static ParquetValueWriters.PrimitiveWriter<byte[]> byteArrays(ColumnDescriptor desc) {
        return new ByteArrayWriter(desc);
    }

    private static class InternalRowWriter
    extends ParquetValueWriters.StructWriter<InternalRow> {
        private final DataType[] types;

        private InternalRowWriter(List<ParquetValueWriter<?>> writers, List<DataType> types) {
            super(writers);
            this.types = types.toArray(new DataType[types.size()]);
        }

        protected Object get(InternalRow struct, int index) {
            return struct.get(index, this.types[index]);
        }
    }

    private static class MapDataWriter<K, V>
    extends ParquetValueWriters.RepeatedKeyValueWriter<MapData, K, V> {
        private final DataType keyType;
        private final DataType valueType;

        private MapDataWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter, DataType keyType, DataType valueType) {
            super(definitionLevel, repetitionLevel, keyWriter, valueWriter);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        protected Iterator<Map.Entry<K, V>> pairs(MapData map) {
            return new EntryIterator(map);
        }

        private class EntryIterator<K, V>
        implements Iterator<Map.Entry<K, V>> {
            private final int size;
            private final ArrayData keys;
            private final ArrayData values;
            private final ParquetValueReaders.ReusableEntry<K, V> entry;
            private int index;

            private EntryIterator(MapData map) {
                this.size = map.numElements();
                this.keys = map.keyArray();
                this.values = map.valueArray();
                this.entry = new ParquetValueReaders.ReusableEntry();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index != this.size;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.index >= this.size) {
                    throw new NoSuchElementException();
                }
                if (this.values.isNullAt(this.index)) {
                    this.entry.set(this.keys.get(this.index, MapDataWriter.this.keyType), null);
                } else {
                    this.entry.set(this.keys.get(this.index, MapDataWriter.this.keyType), this.values.get(this.index, MapDataWriter.this.valueType));
                }
                ++this.index;
                return this.entry;
            }
        }
    }

    private static class ArrayDataWriter<E>
    extends ParquetValueWriters.RepeatedWriter<ArrayData, E> {
        private final DataType elementType;

        private ArrayDataWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<E> writer, DataType elementType) {
            super(definitionLevel, repetitionLevel, writer);
            this.elementType = elementType;
        }

        protected Iterator<E> elements(ArrayData list) {
            return new ElementIterator(list);
        }

        private class ElementIterator<E>
        implements Iterator<E> {
            private final int size;
            private final ArrayData list;
            private int index;

            private ElementIterator(ArrayData list) {
                this.list = list;
                this.size = list.numElements();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index != this.size;
            }

            @Override
            public E next() {
                if (this.index >= this.size) {
                    throw new NoSuchElementException();
                }
                Object element = this.list.isNullAt(this.index) ? null : this.list.get(this.index, ArrayDataWriter.this.elementType);
                ++this.index;
                return (E)element;
            }
        }
    }

    private static class ByteArrayWriter
    extends ParquetValueWriters.PrimitiveWriter<byte[]> {
        private ByteArrayWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, byte[] bytes) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])bytes));
        }
    }

    private static class UUIDWriter
    extends ParquetValueWriters.PrimitiveWriter<UTF8String> {
        private static final ThreadLocal<ByteBuffer> BUFFER = ThreadLocal.withInitial(() -> {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        });

        private UUIDWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, UTF8String string) {
            UUID uuid = UUID.fromString(string.toString());
            ByteBuffer buffer = UUIDUtil.convertToByteBuffer((UUID)uuid, (ByteBuffer)BUFFER.get());
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteBuffer((ByteBuffer)buffer));
        }
    }

    private static class FixedDecimalWriter
    extends ParquetValueWriters.PrimitiveWriter<Decimal> {
        private final int precision;
        private final int scale;
        private final ThreadLocal<byte[]> bytes;

        private FixedDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
            this.bytes = ThreadLocal.withInitial(() -> new byte[TypeUtil.decimalRequiredBytes((int)precision)]);
        }

        public void write(int repetitionLevel, Decimal decimal) {
            byte[] binary = DecimalUtil.toReusedFixLengthBytes((int)this.precision, (int)this.scale, (BigDecimal)decimal.toJavaBigDecimal(), (byte[])this.bytes.get());
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])binary));
        }
    }

    private static class LongDecimalWriter
    extends ParquetValueWriters.PrimitiveWriter<Decimal> {
        private final int precision;
        private final int scale;

        private LongDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        public void write(int repetitionLevel, Decimal decimal) {
            Preconditions.checkArgument((decimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument((decimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeLong(repetitionLevel, decimal.toUnscaledLong());
        }
    }

    private static class IntegerDecimalWriter
    extends ParquetValueWriters.PrimitiveWriter<Decimal> {
        private final int precision;
        private final int scale;

        private IntegerDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        public void write(int repetitionLevel, Decimal decimal) {
            Preconditions.checkArgument((decimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument((decimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeInteger(repetitionLevel, (int)decimal.toUnscaledLong());
        }
    }

    private static class UTF8StringWriter
    extends ParquetValueWriters.PrimitiveWriter<UTF8String> {
        private UTF8StringWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, UTF8String value) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])value.getBytes()));
        }
    }

    private static class WriteBuilder
    extends ParquetWithSparkSchemaVisitor<ParquetValueWriter<?>> {
        private final MessageType type;

        WriteBuilder(MessageType type) {
            this.type = type;
        }

        @Override
        public ParquetValueWriter<?> message(StructType sStruct, MessageType message, List<ParquetValueWriter<?>> fieldWriters) {
            return this.struct(sStruct, message.asGroupType(), fieldWriters);
        }

        @Override
        public ParquetValueWriter<?> struct(StructType sStruct, GroupType struct, List<ParquetValueWriter<?>> fieldWriters) {
            List fields = struct.getFields();
            StructField[] sparkFields = sStruct.fields();
            ArrayList writers = Lists.newArrayListWithExpectedSize((int)fieldWriters.size());
            ArrayList sparkTypes = Lists.newArrayList();
            for (int i = 0; i < fields.size(); ++i) {
                writers.add(this.newOption(struct.getType(i), fieldWriters.get(i)));
                sparkTypes.add(sparkFields[i].dataType());
            }
            return new InternalRowWriter(writers, sparkTypes);
        }

        @Override
        public ParquetValueWriter<?> list(ArrayType sArray, GroupType array, ParquetValueWriter<?> elementWriter) {
            GroupType repeated = ((Type)array.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            return new ArrayDataWriter(repeatedD, repeatedR, this.newOption(repeated.getType(0), elementWriter), sArray.elementType());
        }

        @Override
        public ParquetValueWriter<?> map(MapType sMap, GroupType map, ParquetValueWriter<?> keyWriter, ParquetValueWriter<?> valueWriter) {
            GroupType repeatedKeyValue = ((Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            return new MapDataWriter(repeatedD, repeatedR, this.newOption(repeatedKeyValue.getType(0), keyWriter), this.newOption(repeatedKeyValue.getType(1), valueWriter), sMap.keyType(), sMap.valueType());
        }

        private ParquetValueWriter<?> newOption(Type fieldType, ParquetValueWriter<?> writer) {
            int maxD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName()));
            return ParquetValueWriters.option((Type)fieldType, (int)maxD, writer);
        }

        @Override
        public ParquetValueWriter<?> primitive(DataType sType, PrimitiveType primitive) {
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        return SparkParquetWriters.utf8Strings(desc);
                    }
                    case DATE: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        return SparkParquetWriters.ints(sType, desc);
                    }
                    case INT_64: 
                    case TIME_MICROS: 
                    case TIMESTAMP_MICROS: {
                        return ParquetValueWriters.longs((ColumnDescriptor)desc);
                    }
                    case DECIMAL: {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)primitive.getLogicalTypeAnnotation();
                        switch (primitive.getPrimitiveTypeName()) {
                            case INT32: {
                                return SparkParquetWriters.decimalAsInteger(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case INT64: {
                                return SparkParquetWriters.decimalAsLong(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return SparkParquetWriters.decimalAsFixed(desc, decimal.getPrecision(), decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + primitive.getPrimitiveTypeName());
                    }
                    case BSON: {
                        return SparkParquetWriters.byteArrays(desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + primitive.getOriginalType());
            }
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    if (LogicalTypeAnnotation.uuidType().equals(primitive.getLogicalTypeAnnotation())) {
                        return SparkParquetWriters.uuids(desc);
                    }
                    return SparkParquetWriters.byteArrays(desc);
                }
                case BOOLEAN: {
                    return ParquetValueWriters.booleans((ColumnDescriptor)desc);
                }
                case INT32: {
                    return SparkParquetWriters.ints(sType, desc);
                }
                case INT64: {
                    return ParquetValueWriters.longs((ColumnDescriptor)desc);
                }
                case FLOAT: {
                    return ParquetValueWriters.floats((ColumnDescriptor)desc);
                }
                case DOUBLE: {
                    return ParquetValueWriters.doubles((ColumnDescriptor)desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }
    }
}

