/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Pair;

public class FileScanTaskSetManager {
    private static final FileScanTaskSetManager INSTANCE = new FileScanTaskSetManager();
    private final Map<Pair<String, String>, List<FileScanTask>> tasksMap = Maps.newConcurrentMap();

    private FileScanTaskSetManager() {
    }

    public static FileScanTaskSetManager get() {
        return INSTANCE;
    }

    public void stageTasks(Table table, String setID, List<FileScanTask> tasks) {
        Preconditions.checkArgument((tasks != null && tasks.size() > 0 ? 1 : 0) != 0, (Object)"Cannot stage null or empty tasks");
        Pair<String, String> id = this.toID(table, setID);
        this.tasksMap.put(id, tasks);
    }

    public List<FileScanTask> fetchTasks(Table table, String setID) {
        Pair<String, String> id = this.toID(table, setID);
        return this.tasksMap.get(id);
    }

    public List<FileScanTask> removeTasks(Table table, String setID) {
        Pair<String, String> id = this.toID(table, setID);
        return this.tasksMap.remove(id);
    }

    public Set<String> fetchSetIDs(Table table) {
        return this.tasksMap.keySet().stream().filter(e -> ((String)e.first()).equals(this.tableUUID(table))).map(Pair::second).collect(Collectors.toSet());
    }

    private String tableUUID(Table table) {
        TableOperations ops = ((HasTableOperations)table).operations();
        return ops.current().uuid();
    }

    private Pair<String, String> toID(Table table, String setID) {
        return Pair.of((Object)this.tableUUID(table), (Object)setID);
    }
}

