/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.DiskBlockManager$;
import org.apache.spark.storage.ShuffleMergedDataBlockId;
import org.apache.spark.storage.ShuffleMergedIndexBlockId;
import org.apache.spark.storage.ShuffleMergedMetaBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!\u0002\u0017.\u0001=*\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011!\u0003!\u00111A\u0005\u0002%C\u0001\"\u0014\u0001\u0003\u0002\u0004%\tA\u0014\u0005\t)\u0002\u0011\t\u0011)Q\u0005\u0015\"AQ\u000b\u0001B\u0001B\u0003%!\nC\u0003W\u0001\u0011\u0005q\u000b\u0003\u0005^\u0001\t\u0007I\u0011A\u0018_\u0011\u0019\u0011\u0007\u0001)A\u0005?\"A1\r\u0001b\u0001\n\u0003yC\r\u0003\u0004q\u0001\u0001\u0006I!\u001a\u0005\tc\u0002\u0011\r\u0011\"\u00010e\"1q\u0010\u0001Q\u0001\nMD\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005\u001d\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u000f\u00055\u0001\u0001)A\u0005i\"I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\b\u0003'\u0001\u0001\u0015!\u00037\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\u0006\u0001\t\u0003\ti\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005%\u0002\u0001\"\u0003\u0002:!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002~\u0001!I!a \t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003'\u0003A\u0011BAK\u0011!\t9\n\u0001C\u0001_\u0005\u0015\u0005bBAM\u0001\u0011%\u0011QQ\u0004\t\u00037k\u0003\u0012A\u0018\u0002\u001e\u001a9A&\fE\u0001_\u0005}\u0005B\u0002,%\t\u0003\t\t\u000bC\u0005\u0002$\u0012\u0012\r\u0011\"\u0001\u0002&\"A\u0011\u0011\u0017\u0013!\u0002\u0013\t9\u000bC\u0005\u00024\u0012\u0012\r\u0011\"\u0001\u0002&\"A\u0011Q\u0017\u0013!\u0002\u0013\t9\u000bC\u0005\u00028\u0012\u0012\r\u0011\"\u0001\u0002&\"A\u0011\u0011\u0018\u0013!\u0002\u0013\t9K\u0001\tESN\\'\t\\8dW6\u000bg.Y4fe*\u0011afL\u0001\bgR|'/Y4f\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7c\u0001\u00017yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t1\u0011I\\=SK\u001a\u0004\"!\u0010!\u000e\u0003yR!aP\u0018\u0002\u0011%tG/\u001a:oC2L!!\u0011 \u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"!\u0012$\u000e\u0003=J!aR\u0018\u0003\u0013M\u0003\u0018M]6D_:4\u0017!\u00053fY\u0016$XMR5mKN|en\u0015;paV\t!\n\u0005\u00028\u0017&\u0011A\n\u000f\u0002\b\u0005>|G.Z1o\u0003U!W\r\\3uK\u001aKG.Z:P]N#x\u000e]0%KF$\"a\u0014*\u0011\u0005]\u0002\u0016BA)9\u0005\u0011)f.\u001b;\t\u000fM\u001b\u0011\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010J\u0019\u0002%\u0011,G.\u001a;f\r&dWm](o'R|\u0007\u000fI\u0001\tSN$%/\u001b<fe\u00061A(\u001b8jiz\"B\u0001\u0017.\\9B\u0011\u0011\fA\u0007\u0002[!)!I\u0002a\u0001\t\")\u0001J\u0002a\u0001\u0015\")QK\u0002a\u0001\u0015\u0006\u00112/\u001e2ESJ\u001c\b+\u001a:M_\u000e\fG\u000eR5s+\u0005y\u0006CA\u001ca\u0013\t\t\u0007HA\u0002J]R\f1c];c\t&\u00148\u000fU3s\u0019>\u001c\u0017\r\u001c#je\u0002\n\u0011\u0002\\8dC2$\u0015N]:\u0016\u0003\u0015\u00042a\u000e4i\u0013\t9\u0007HA\u0003BeJ\f\u0017\u0010\u0005\u0002j]6\t!N\u0003\u0002lY\u0006\u0011\u0011n\u001c\u0006\u0002[\u0006!!.\u0019<b\u0013\ty'N\u0001\u0003GS2,\u0017A\u00037pG\u0006dG)\u001b:tA\u0005yAn\\2bY\u0012K'o]*ue&tw-F\u0001t!\r9d\r\u001e\t\u0003krt!A\u001e>\u0011\u0005]DT\"\u0001=\u000b\u0005e\u001c\u0015A\u0002\u001fs_>$h(\u0003\u0002|q\u00051\u0001K]3eK\u001aL!! @\u0003\rM#(/\u001b8h\u0015\tY\b(\u0001\tm_\u000e\fG\u000eR5sgN#(/\u001b8hA\u000591/\u001e2ESJ\u001cXCAA\u0003!\r9d-Z\u0001\tgV\u0014G)\u001b:tA\u0005aQ.\u001a:hK\u0012K'OT1nKV\tA/A\u0007nKJ<W\rR5s\u001d\u0006lW\rI\u0001\rg\",H\u000fZ8x]\"{wn[\u000b\u0002m\u0005i1\u000f[;uI><h\u000eS8pW\u0002\nqaZ3u\r&dW\rF\u0002i\u00033Aa!a\u0007\u0014\u0001\u0004!\u0018\u0001\u00034jY\u0016t\u0017-\\3\u0015\u0007!\fy\u0002C\u0004\u0002\"Q\u0001\r!a\t\u0002\u000f\tdwnY6JIB\u0019\u0011,!\n\n\u0007\u0005\u001dRFA\u0004CY>\u001c7.\u00133\u0002)\u001d,G/T3sO\u0016$7\u000b[;gM2,g)\u001b7f)\u0015A\u0017QFA\u0018\u0011\u001d\t\t#\u0006a\u0001\u0003GAq!!\r\u0016\u0001\u0004\t\u0019$\u0001\u0003eSJ\u001c\b\u0003B\u001c\u00026ML1!a\u000e9\u0005\u0019y\u0005\u000f^5p]R)\u0001.a\u000f\u0002>!1\u00111\u0004\fA\u0002QDq!!\r\u0017\u0001\u0004\t\u0019$A\u0007d_:$\u0018-\u001b8t\u00052|7m\u001b\u000b\u0004\u0015\u0006\r\u0003bBA\u0011/\u0001\u0007\u00111E\u0001\fO\u0016$\u0018\t\u001c7GS2,7\u000f\u0006\u0002\u0002JA)\u00111JA+Q:!\u0011QJA)\u001d\r9\u0018qJ\u0005\u0002s%\u0019\u00111\u000b\u001d\u0002\u000fA\f7m[1hK&!\u0011qKA-\u0005\r\u0019V-\u001d\u0006\u0004\u0003'B\u0014\u0001D4fi\u0006cGN\u00117pG.\u001cHCAA0!\u0019\tY%!\u0016\u0002$\u0005!2M]3bi\u0016$V-\u001c9M_\u000e\fGN\u00117pG.$\"!!\u001a\u0011\r]\n9'a\u001bi\u0013\r\tI\u0007\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007e\u000bi'C\u0002\u0002p5\u0012\u0001\u0003V3na2{7-\u00197CY>\u001c7.\u00133\u0002-\r\u0014X-\u0019;f)\u0016l\u0007o\u00155vM\u001adWM\u00117pG.$\"!!\u001e\u0011\r]\n9'a\u001ei!\rI\u0016\u0011P\u0005\u0004\u0003wj#A\u0005+f[B\u001c\u0006.\u001e4gY\u0016\u0014En\\2l\u0013\u0012\fqb\u0019:fCR,Gj\\2bY\u0012K'o\u001d\u000b\u0004K\u0006\u0005\u0005\"\u0002\"\u001d\u0001\u0004!\u0015!J2sK\u0006$X\rT8dC2$\u0015N]:G_JlUM]4fINCWO\u001a4mK\ncwnY6t)\u0005y\u0015AG2sK\u0006$X\rR5s/&$\b\u000eU3s[&\u001c8/[8oo]\u0002DcA(\u0002\f\"1\u0011Q\u0012\u0010A\u0002!\f1\u0002Z5s)>\u001c%/Z1uK\u00069s-\u001a;NKJ<W\rR5sK\u000e$xN]=B]\u0012\fE\u000f^3naRLEIS:p]N#(/\u001b8h)\u0005!\u0018aD1eINCW\u000f\u001e3po:Dun\\6\u0015\u0003Y\nAa\u001d;pa\u00061Am\\*u_B\f\u0001\u0003R5tW\ncwnY6NC:\fw-\u001a:\u0011\u0005e#3C\u0001\u00137)\t\ti*A\bN\u000bJ;Ui\u0018#J%\u0016\u001bEk\u0014*Z+\t\t9\u000b\u0005\u0003\u0002*\u0006=VBAAV\u0015\r\ti\u000b\\\u0001\u0005Y\u0006tw-C\u0002~\u0003W\u000b\u0001#T#S\u000f\u0016{F)\u0013*F\u0007R{%+\u0017\u0011\u0002\u001b5+%kR#`\t&\u0013vlS#Z\u00039iUIU$F?\u0012K%kX&F3\u0002\na\"\u0011+U\u000b6\u0003FkX%E?.+\u0015,A\bB)R+U\n\u0015+`\u0013\u0012{6*R-!\u0001")
public class DiskBlockManager
implements Logging {
    private final SparkConf conf;
    private boolean deleteFilesOnStop;
    private final boolean isDriver;
    private final int subDirsPerLocalDir;
    private final File[] localDirs;
    private final String[] localDirsString;
    private final File[][] subDirs;
    private final String mergeDirName;
    private final Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String ATTEMPT_ID_KEY() {
        return DiskBlockManager$.MODULE$.ATTEMPT_ID_KEY();
    }

    public static String MERGE_DIR_KEY() {
        return DiskBlockManager$.MODULE$.MERGE_DIR_KEY();
    }

    public static String MERGE_DIRECTORY() {
        return DiskBlockManager$.MODULE$.MERGE_DIRECTORY();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean deleteFilesOnStop() {
        return this.deleteFilesOnStop;
    }

    public void deleteFilesOnStop_$eq(boolean x$1) {
        this.deleteFilesOnStop = x$1;
    }

    public int subDirsPerLocalDir() {
        return this.subDirsPerLocalDir;
    }

    public File[] localDirs() {
        return this.localDirs;
    }

    public String[] localDirsString() {
        return this.localDirsString;
    }

    private File[][] subDirs() {
        return this.subDirs;
    }

    private String mergeDirName() {
        return this.mergeDirName;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    public File getFile(String filename) {
        File file;
        int hash = Utils$.MODULE$.nonNegativeHash(filename);
        int dirId = hash % this.localDirs().length;
        int subDirId = hash / this.localDirs().length % this.subDirsPerLocalDir();
        File[] fileArray = this.subDirs()[dirId];
        synchronized (fileArray) {
            File file2;
            File old = this.subDirs()[dirId][subDirId];
            if (old != null) {
                file2 = old;
            } else {
                File newDir = new File(this.localDirs()[dirId], new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)})));
                Object object = !newDir.exists() ? Files.createDirectory(newDir.toPath(), new FileAttribute[0]) : BoxedUnit.UNIT;
                this.subDirs()[dirId][subDirId] = newDir;
                file2 = newDir;
            }
            file = file2;
        }
        File subDir = file;
        return new File(subDir, filename);
    }

    public File getFile(BlockId blockId) {
        return this.getFile(blockId.name());
    }

    public File getMergedShuffleFile(BlockId blockId, Option<String[]> dirs) {
        File file;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleMergedDataBlockId) {
            ShuffleMergedDataBlockId shuffleMergedDataBlockId = (ShuffleMergedDataBlockId)blockId2;
            file = this.getMergedShuffleFile(shuffleMergedDataBlockId.name(), dirs);
        } else if (blockId2 instanceof ShuffleMergedIndexBlockId) {
            ShuffleMergedIndexBlockId shuffleMergedIndexBlockId = (ShuffleMergedIndexBlockId)blockId2;
            file = this.getMergedShuffleFile(shuffleMergedIndexBlockId.name(), dirs);
        } else if (blockId2 instanceof ShuffleMergedMetaBlockId) {
            ShuffleMergedMetaBlockId shuffleMergedMetaBlockId = (ShuffleMergedMetaBlockId)blockId2;
            file = this.getMergedShuffleFile(shuffleMergedMetaBlockId.name(), dirs);
        } else {
            throw new IllegalArgumentException(new StringBuilder(43).append("Only merged block ID is supported, but got ").append(blockId).toString());
        }
        return file;
    }

    private File getMergedShuffleFile(String filename, Option<String[]> dirs) {
        if (!dirs.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DiskBlockManager.$anonfun$getMergedShuffleFile$1(x$2)))) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Cannot read ").append(filename).append(" because merged shuffle dirs is empty").toString());
        }
        return new File(ExecutorDiskUtils.getFilePath((String[])((String[])dirs.get()), (int)this.subDirsPerLocalDir(), (String)filename));
    }

    public boolean containsBlock(BlockId blockId) {
        return this.getFile(blockId.name()).exists();
    }

    public Seq<File> getAllFiles() {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.subDirs())).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(DiskBlockManager.$anonfun$getAllFiles$1(dir)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DiskBlockManager.$anonfun$getAllFiles$2(x$3))))).flatMap((Function1 & Serializable & scala.Serializable)dir -> {
            File[] files = dir.listFiles();
            return files != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).toSeq() : (Seq)Nil$.MODULE$;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<BlockId> getAllBlocks() {
        return (Seq)this.getAllFiles().flatMap((Function1 & Serializable & scala.Serializable)f -> {
            Iterable iterable;
            try {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BlockId$.MODULE$.apply(f.getName())));
            }
            catch (UnrecognizedBlockId unrecognizedBlockId) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<TempLocalBlockId, File> createTempLocalBlock() {
        TempLocalBlockId blockId = new TempLocalBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempLocalBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    public Tuple2<TempShuffleBlockId, File> createTempShuffleBlock() {
        TempShuffleBlockId blockId = new TempShuffleBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempShuffleBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    private File[] createLocalDirs(SparkConf conf) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf))).flatMap((Function1 & Serializable & scala.Serializable)rootDir -> {
            Iterable iterable;
            try {
                File localDir = Utils$.MODULE$.createDirectory((String)rootDir, "blockmgr");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Created local directory at ").append(localDir).toString());
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)localDir));
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to create local dir in ").append((String)rootDir).append(". Ignoring this directory.").toString(), e);
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    private void createLocalDirsForMergedShuffleBlocks() {
        block0: {
            if (!Utils$.MODULE$.isPushBasedShuffleEnabled(this.conf, this.isDriver, false)) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(this.conf))).foreach((Function1 & Serializable & scala.Serializable)rootDir -> {
                DiskBlockManager.$anonfun$createLocalDirsForMergedShuffleBlocks$1(this, rootDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void createDirWithPermission770(File dirToCreate) {
        int attempts = 0;
        int maxAttempts = Utils$.MODULE$.MAX_DIR_CREATION_ATTEMPTS();
        File created = null;
        while (created == null) {
            if (++attempts > maxAttempts) {
                throw new IOException(new StringBuilder(64).append("Failed to create directory ").append(dirToCreate.getAbsolutePath()).append(" with permission ").append("770 after ").append(maxAttempts).append(" attempts!").toString());
            }
            try {
                ProcessBuilder builder = new ProcessBuilder(new String[0]).command("mkdir", "-p", "-m770", dirToCreate.getAbsolutePath());
                Process proc = builder.start();
                int exitCode = proc.waitFor();
                if (dirToCreate.exists()) {
                    created = dirToCreate;
                }
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Created directory at ").append(dirToCreate.getAbsolutePath()).append(" with permission ").append("770 and exitCode ").append(exitCode).toString());
            }
            catch (SecurityException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Failed to create directory ").append(dirToCreate.getAbsolutePath()).append(" ").append("with permission 770").toString(), e);
                created = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getMergeDirectoryAndAttemptIDJsonString() {
        void var3_3;
        HashMap mergedMetaMap = new HashMap();
        mergedMetaMap.put((Object)DiskBlockManager$.MODULE$.MERGE_DIR_KEY(), (Object)this.mergeDirName());
        ((Option)this.conf.get(package$.MODULE$.APP_ATTEMPT_ID())).foreach((Function1 & Serializable & scala.Serializable)attemptId -> mergedMetaMap.put((Object)DiskBlockManager$.MODULE$.ATTEMPT_ID_KEY(), attemptId));
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        String jsonString = mapper.writeValueAsString((Object)mergedMetaMap);
        return var3_3;
    }

    private Object addShutdownHook() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Adding shutdown hook");
        return ShutdownHookManager$.MODULE$.addShutdownHook(ShutdownHookManager$.MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY() + 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown hook called");
            this.doStop();
        });
    }

    public void stop() {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook()));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while removing shutdown hook.", e);
            bl = BoxedUnit.UNIT;
        }
        this.doStop();
    }

    private void doStop() {
        block0: {
            if (!this.deleteFilesOnStop()) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).foreach((Function1 & Serializable & scala.Serializable)localDir -> {
                DiskBlockManager.$anonfun$doStop$1(this, localDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$getMergedShuffleFile$1(String[] x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).nonEmpty();
    }

    public static final /* synthetic */ Object[] $anonfun$getAllFiles$1(File[] dir) {
        File[] fileArray = dir;
        synchronized (dir) {
            File[] fileArray2 = (File[])dir.clone();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Predef$.MODULE$.refArrayOps((Object[])fileArray2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllFiles$2(File x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ void $anonfun$createLocalDirsForMergedShuffleBlocks$1(DiskBlockManager $this, String rootDir) {
        try {
            File mergeDir = new File(rootDir, $this.mergeDirName());
            if (!mergeDir.exists()) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Try to create ").append(mergeDir).append(" and its sub dirs since the ").append($this.mergeDirName()).append(" dir does not exist").toString());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.subDirsPerLocalDir()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)dirNum -> {
                    block0: {
                        File subDir = new File(mergeDir, new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirNum)})));
                        if (subDir.exists()) break block0;
                        $this.createDirWithPermission770(subDir);
                    }
                });
            }
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Merge directory and its sub dirs get created at ").append(mergeDir).toString());
        }
        catch (IOException e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Failed to create ").append($this.mergeDirName()).append(" dir in ").append(rootDir).append(". Ignoring this directory.").toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$doStop$1(DiskBlockManager $this, File localDir) {
        block3: {
            if (!localDir.isDirectory() || !localDir.exists()) break block3;
            try {
                if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(localDir)) {
                    Utils$.MODULE$.deleteRecursively(localDir);
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Exception while deleting local spark dir: ").append(localDir).toString(), e);
            }
        }
    }

    public DiskBlockManager(SparkConf conf, boolean deleteFilesOnStop, boolean isDriver) {
        this.conf = conf;
        this.deleteFilesOnStop = deleteFilesOnStop;
        this.isDriver = isDriver;
        Logging.$init$(this);
        this.subDirsPerLocalDir = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DISKSTORE_SUB_DIRECTORIES()));
        this.localDirs = this.createLocalDirs(conf);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).isEmpty()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create any local dir.");
            System.exit(ExecutorExitCode$.MODULE$.DISK_STORE_FAILED_TO_CREATE_DIR());
        }
        this.localDirsString = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.subDirs = (File[][])Array$.MODULE$.fill(this.localDirs().length, (Function0 & Serializable & scala.Serializable)() -> new File[this.subDirsPerLocalDir()], ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(File.class)));
        this.mergeDirName = new StringBuilder(0).append(DiskBlockManager$.MODULE$.MERGE_DIRECTORY()).append(((Option)conf.get(package$.MODULE$.APP_ATTEMPT_ID())).map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(1).append("_").append((String)id).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        this.createLocalDirsForMergedShuffleBlocks();
        this.shutdownHook = this.addShutdownHook();
    }
}

