/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=f!B\u0017/\u0001A2\u0004\u0002C\"\u0001\u0005\u0003\u0007I\u0011A#\t\u00111\u0003!\u00111A\u0005\u00025C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006KA\u0012\u0005\t)\u0002\u0011\t\u0019!C\u0001\u000b\"AQ\u000b\u0001BA\u0002\u0013\u0005a\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015)\u0003G\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u000b\t\u0004A\u0011A2\t\u000f)\u0004!\u0019!C\u0001W\"1q\u000e\u0001Q\u0001\n1DQ\u0001\u001d\u0001\u0005\u0002EDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fB\u0011\"!\u001e\u0001#\u0003%\t!a\u001e\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003_\u0003A\u0011AAg\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002!9!q\u0001\u0001\u0005\u0002\t%\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005KAqA!\f\u0001\t\u0003\u0011y\u0003C\u0004\u0003<\u0001!\tA!\u0010\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!q\u000b\u0001\u0005\u0002\te\u0003\"\u0003B5\u0001E\u0005I\u0011AA<\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005[BqA! \u0001\t\u0003\u0011y\bC\u0004\u0003\u0002\u0002!IAa!\b\u0011\t=e\u0006#\u00011\u0005#3q!\f\u0018\t\u0002A\u0012\u0019\n\u0003\u0004cO\u0011\u0005!Q\u0013\u0005\n\u0005/;#\u0019!C\u0001\u00053C\u0001B!+(A\u0003%!1\u0014\u0005\n\u0005W;#\u0019!C\u0001\u00053C\u0001B!,(A\u0003%!1\u0014\u0002\u0013\u00052|7m['b]\u0006<WM]'bgR,'O\u0003\u00020a\u000591\u000f^8sC\u001e,'BA\u00193\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\u0014\u0007\u00019T\b\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VM\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001B\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0005~\u0012q\u0001T8hO&tw-\u0001\bee&4XM]#oIB|\u0017N\u001c;\u0004\u0001U\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002Ja\u0005\u0019!\u000f]2\n\u0005-C%A\u0004*qG\u0016sG\r]8j]R\u0014VMZ\u0001\u0013IJLg/\u001a:F]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000f\u0006\u0002O#B\u0011\u0001hT\u0005\u0003!f\u0012A!\u00168ji\"9!KAA\u0001\u0002\u00041\u0015a\u0001=%c\u0005yAM]5wKJ,e\u000e\u001a9pS:$\b%A\fee&4XM\u001d%fCJ$(-Z1u\u000b:$\u0007k\\5oi\u0006YBM]5wKJDU-\u0019:uE\u0016\fG/\u00128e!>Lg\u000e^0%KF$\"AT,\t\u000fI+\u0011\u0011!a\u0001\r\u0006ABM]5wKJDU-\u0019:uE\u0016\fG/\u00128e!>Lg\u000e\u001e\u0011\u0002\t\r|gN\u001a\t\u00037rk\u0011\u0001M\u0005\u0003;B\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0011%\u001cHI]5wKJ\u0004\"\u0001\u000f1\n\u0005\u0005L$a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u00114w\r[5\u0011\u0005\u0015\u0004Q\"\u0001\u0018\t\u000b\rK\u0001\u0019\u0001$\t\u000bQK\u0001\u0019\u0001$\t\u000beK\u0001\u0019\u0001.\t\u000byK\u0001\u0019A0\u0002\u000fQLW.Z8viV\tA\u000e\u0005\u0002H[&\u0011a\u000e\u0013\u0002\u000b%B\u001cG+[7f_V$\u0018\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u001dI,Wn\u001c<f\u000bb,7-\u001e;peR\u0011aJ\u001d\u0005\u0006g2\u0001\r\u0001^\u0001\u0007Kb,7-\u00133\u0011\u0005UdhB\u0001<{!\t9\u0018(D\u0001y\u0015\tIH)\u0001\u0004=e>|GOP\u0005\u0003wf\na\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u001110O\u0001\u001aI\u0016\u001cw.\\7jgNLwN\u001c\"m_\u000e\\W*\u00198bO\u0016\u00148\u000fF\u0002O\u0003\u0007Aq!!\u0002\u000e\u0001\u0004\t9!A\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\b#BA\u0005\u0003'!h\u0002BA\u0006\u0003\u001fq1a^A\u0007\u0013\u0005Q\u0014bAA\ts\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000b\u0003/\u00111aU3r\u0015\r\t\t\"O\u0001\u001dO\u0016$(+\u001a9mS\u000e\fG/Z%oM>4uN\u001d*E\t\ncwnY6t)\u0011\ti\"!\u0010\u0011\r\u0005%\u00111CA\u0010!\u0011\t\t#a\u000e\u000f\t\u0005\r\u00121\u0007\b\u0005\u0003K\t\tD\u0004\u0003\u0002(\u0005=b\u0002BA\u0015\u0003[q1a^A\u0016\u0013\u0005)\u0014BA\u001a5\u0013\t\t$'\u0003\u00020a%\u0019\u0011Q\u0007\u0018\u0002)\tcwnY6NC:\fw-\u001a:NKN\u001c\u0018mZ3t\u0013\u0011\tI$a\u000f\u0003\u001dI+\u0007\u000f\\5dCR,'\t\\8dW*\u0019\u0011Q\u0007\u0018\t\u000f\u0005}b\u00021\u0001\u0002B\u0005q!\r\\8dW6\u000bg.Y4fe&#\u0007cA3\u0002D%\u0019\u0011Q\t\u0018\u0003\u001d\tcwnY6NC:\fw-\u001a:JI\u0006\u0019\"/Z7pm\u0016,\u00050Z2vi>\u0014\u0018i]=oGR\u0019a*a\u0013\t\u000bM|\u0001\u0019\u0001;\u0002)I,w-[:uKJ\u0014En\\2l\u001b\u0006t\u0017mZ3s)9\t\t%!\u0015\u0002V\u0005}\u0013\u0011NA7\u0003cBq!a\u0015\u0011\u0001\u0004\t\t%\u0001\u0002jI\"9\u0011q\u000b\tA\u0002\u0005e\u0013!\u00037pG\u0006dG)\u001b:t!\u0011A\u00141\f;\n\u0007\u0005u\u0013HA\u0003BeJ\f\u0017\u0010C\u0004\u0002bA\u0001\r!a\u0019\u0002!5\f\u0007p\u00148IK\u0006\u0004X*Z7TSj,\u0007c\u0001\u001d\u0002f%\u0019\u0011qM\u001d\u0003\t1{gn\u001a\u0005\b\u0003W\u0002\u0002\u0019AA2\u0003Ei\u0017\r_(gM\"+\u0017\r]'f[NK'0\u001a\u0005\u0007\u0003_\u0002\u0002\u0019\u0001$\u0002\u001fM$xN]1hK\u0016sG\r]8j]RD\u0001\"a\u001d\u0011!\u0003\u0005\raX\u0001\rSN\u0014VMU3hSN$XM]\u0001\u001fe\u0016<\u0017n\u001d;fe\ncwnY6NC:\fw-\u001a:%I\u00164\u0017-\u001e7uIY*\"!!\u001f+\u0007}\u000bYh\u000b\u0002\u0002~A!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015!C;oG\",7m[3e\u0015\r\t9)O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAF\u0003\u0003\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003=)\b\u000fZ1uK\ncwnY6J]\u001a|GcC0\u0002\u0012\u0006M\u0015QTAT\u0003WCq!a\u0010\u0013\u0001\u0004\t\t\u0005C\u0004\u0002\u0016J\u0001\r!a&\u0002\u000f\tdwnY6JIB\u0019Q-!'\n\u0007\u0005meFA\u0004CY>\u001c7.\u00133\t\u000f\u0005}%\u00031\u0001\u0002\"\u0006a1\u000f^8sC\u001e,G*\u001a<fYB\u0019Q-a)\n\u0007\u0005\u0015fF\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0004\u0002*J\u0001\r!a\u0019\u0002\u000f5,WnU5{K\"9\u0011Q\u0016\nA\u0002\u0005\r\u0014\u0001\u00033jg.\u001c\u0016N_3\u0002\u0019\u001d,G\u000fT8dCRLwN\\:\u0015\t\u0005M\u0016Q\u0017\t\u0007\u0003\u0013\t\u0019\"!\u0011\t\u000f\u0005U5\u00031\u0001\u0002\u0018\u0006)r-\u001a;M_\u000e\fG/[8og\u0006sGm\u0015;biV\u001cHCBA^\u0003\u000f\fI\rE\u00039\u0003{\u000b\t-C\u0002\u0002@f\u0012aa\u00149uS>t\u0007\u0003BA\u0011\u0003\u0007LA!!2\u0002<\t9\"\t\\8dW2{7-\u0019;j_:\u001c\u0018I\u001c3Ti\u0006$Xo\u001d\u0005\b\u0003+#\u0002\u0019AAL\u0011\u0019\tY\r\u0006a\u0001i\u0006i!/Z9vKN$XM\u001d%pgR$B!a4\u0002VB1\u0011\u0011BAi\u0003gKA!a5\u0002\u0018\tQ\u0011J\u001c3fq\u0016$7+Z9\t\u000f\u0005]W\u00031\u0001\u0002Z\u0006A!\r\\8dW&#7\u000fE\u00039\u00037\n9*\u0001\u0005d_:$\u0018-\u001b8t)\ry\u0016q\u001c\u0005\b\u0003+3\u0002\u0019AAL\u0003!9W\r\u001e)fKJ\u001cH\u0003BAZ\u0003KDq!a\u0010\u0018\u0001\u0004\t\t%A\u000fhKR\u001c\u0006.\u001e4gY\u0016\u0004Vo\u001d5NKJ<WM\u001d'pG\u0006$\u0018n\u001c8t)\u0019\t\u0019,a;\u0002v\"9\u0011Q\u001e\rA\u0002\u0005=\u0018\u0001\u00058v[6+'oZ3sg:+W\rZ3e!\rA\u0014\u0011_\u0005\u0004\u0003gL$aA%oi\"9\u0011q\u001f\rA\u0002\u0005e\u0018!\u00045pgR\u001cHk\u001c$jYR,'\u000f\u0005\u0003v\u0003w$\u0018bAA\u007f}\n\u00191+\u001a;\u0002?I,Wn\u001c<f'\",hM\u001a7f!V\u001c\b.T3sO\u0016\u0014Hj\\2bi&|g\u000eF\u0002O\u0005\u0007AaA!\u0002\u001a\u0001\u0004!\u0018\u0001\u00025pgR\facZ3u\u000bb,7-\u001e;pe\u0016sG\r]8j]R\u0014VM\u001a\u000b\u0005\u0005\u0017\u0011i\u0001\u0005\u00039\u0003{3\u0005B\u0002B\b5\u0001\u0007A/\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\f1B]3n_Z,'\t\\8dWR\u0019aJ!\u0006\t\u000f\u0005U5\u00041\u0001\u0002\u0018\u0006I!/Z7pm\u0016\u0014F\r\u001a\u000b\u0006\u001d\nm!q\u0004\u0005\b\u0005;a\u0002\u0019AAx\u0003\u0015\u0011H\rZ%e\u0011\u0019\u0011\t\u0003\ba\u0001?\u0006A!\r\\8dW&tw-A\u0007sK6|g/Z*ik\u001a4G.\u001a\u000b\u0006\u001d\n\u001d\"1\u0006\u0005\b\u0005Si\u0002\u0019AAx\u0003%\u0019\b.\u001e4gY\u0016LE\r\u0003\u0004\u0003\"u\u0001\raX\u0001\u0010e\u0016lwN^3Ce>\fGmY1tiR9aJ!\r\u00036\te\u0002b\u0002B\u001a=\u0001\u0007\u00111M\u0001\fEJ|\u0017\rZ2bgRLE\r\u0003\u0004\u00038y\u0001\raX\u0001\u0011e\u0016lwN^3Ge>lW*Y:uKJDaA!\t\u001f\u0001\u0004y\u0016aD4fi6+Wn\u001c:z'R\fG/^:\u0016\u0005\t}\u0002cB;\u0003B\u0005\u0005#QI\u0005\u0004\u0005\u0007r(aA'baB9\u0001Ha\u0012\u0002d\u0005\r\u0014b\u0001B%s\t1A+\u001e9mKJ\n\u0001cZ3u'R|'/Y4f'R\fG/^:\u0016\u0005\t=\u0003#\u0002\u001d\u0002\\\tE\u0003cA3\u0003T%\u0019!Q\u000b\u0018\u0003\u001bM#xN]1hKN#\u0018\r^;t\u000399W\r\u001e\"m_\u000e\\7\u000b^1ukN$bAa\u0017\u0003d\t\u0015\u0004cB;\u0003B\u0005\u0005#Q\f\t\u0004K\n}\u0013b\u0001B1]\tY!\t\\8dWN#\u0018\r^;t\u0011\u001d\t)*\ta\u0001\u0003/C\u0001Ba\u001a\"!\u0003\u0005\raX\u0001\u0014CN\\7\u000b^8sC\u001e,WI\u001c3q_&tGo]\u0001\u0019O\u0016$(\t\\8dWN#\u0018\r^;tI\u0011,g-Y;mi\u0012\u0012\u0014aE4fi6\u000bGo\u00195j]\u001e\u0014En\\2l\u0013\u0012\u001cHC\u0002B8\u0005c\u0012Y\b\u0005\u0004\u0002\n\u0005M\u0011q\u0013\u0005\b\u0005g\u001a\u0003\u0019\u0001B;\u0003\u00191\u0017\u000e\u001c;feB1\u0001Ha\u001e\u0002\u0018~K1A!\u001f:\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\u0003h\r\u0002\raX\u0001\u0005gR|\u0007\u000fF\u0001O\u0003\u0011!X\r\u001c7\u0015\u00079\u0013)\tC\u0004\u0003\b\u0016\u0002\rA!#\u0002\u000f5,7o]1hKB\u0019\u0001Ha#\n\u0007\t5\u0015HA\u0002B]f\f!C\u00117pG.l\u0015M\\1hKJl\u0015m\u001d;feB\u0011QmJ\n\u0003O]\"\"A!%\u0002)\u0011\u0013\u0016JV#S?\u0016sE\tU(J\u001dR{f*Q'F+\t\u0011Y\n\u0005\u0003\u0003\u001e\n\u001dVB\u0001BP\u0015\u0011\u0011\tKa)\u0002\t1\fgn\u001a\u0006\u0003\u0005K\u000bAA[1wC&\u0019QPa(\u0002+\u0011\u0013\u0016JV#S?\u0016sE\tU(J\u001dR{f*Q'FA\u0005qBIU%W\u000bJ{\u0006*R!S)\n+\u0015\tV0F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u0001 \tJKe+\u0012*`\u0011\u0016\u000b%\u000b\u0016\"F\u0003R{VI\u0014#Q\u001f&sEk\u0018(B\u001b\u0016\u0003\u0003")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private RpcEndpointRef driverHeartbeatEndPoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DRIVER_HEARTBEAT_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_HEARTBEAT_ENDPOINT_NAME();
    }

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcEndpointRef driverHeartbeatEndPoint() {
        return this.driverHeartbeatEndPoint;
    }

    public void driverHeartbeatEndPoint_$eq(RpcEndpointRef x$1) {
        this.driverHeartbeatEndPoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed ").append(execId).append(" successfully in removeExecutor").toString());
    }

    public void decommissionBlockManagers(Seq<String> executorIds) {
        this.driverEndpoint().ask(new BlockManagerMessages.DecommissionBlockManagers(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public Seq<BlockManagerMessages.ReplicateBlock> getReplicateInfoForRDDBlocks(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetReplicateInfoForRDDBlocks(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Removal of executor ").append(execId).append(" requested").toString());
    }

    public BlockManagerId registerBlockManager(BlockManagerId id, String[] localDirs, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef storageEndpoint, boolean isReRegister) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Registering BlockManager ").append(id).toString());
        BlockManagerId updatedId = (BlockManagerId)this.driverEndpoint().askSync(new BlockManagerMessages.RegisterBlockManager(id, localDirs, maxOnHeapMemSize, maxOffHeapMemSize, storageEndpoint, isReRegister), ClassTag$.MODULE$.apply(BlockManagerId.class));
        String string = updatedId.executorId();
        String string2 = BlockManagerId$.MODULE$.INVALID_EXECUTOR_ID();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.assert(isReRegister, (Function0 & Serializable & scala.Serializable)() -> "Got invalid executor id from non re-register case");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Re-register BlockManager ").append(id).append(" failed").toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Registered BlockManager ").append(updatedId).toString());
        }
        return updatedId;
    }

    public boolean registerBlockManager$default$6() {
        return false;
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Updated info of block ").append(blockId).toString());
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> getLocationsAndStatus(BlockId blockId, String requesterHost) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsAndStatus(blockId, requesterHost), ClassTag$.MODULE$.apply(Option.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Seq<BlockManagerId> getShufflePushMergerLocations(int numMergersNeeded, Set<String> hostsToFilter) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetShufflePushMergerLocations(numMergersNeeded, hostsToFilter), ClassTag$.MODULE$.apply(Seq.class));
    }

    public void removeShufflePushMergerLocation(String host) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShufflePushMergerLocation(host), ClassTag$.MODULE$.Unit());
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Failed to remove RDD ").append(rddId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            RpcUtils$.MODULE$.INFINITE_TIMEOUT().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to remove shuffle ").append(shuffleId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            RpcUtils$.MODULE$.INFINITE_TIMEOUT().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Failed to remove broadcast ").append(broadcastId$1).append(" with removeFromMaster = ").append(removeFromMaster$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            RpcUtils$.MODULE$.INFINITE_TIMEOUT().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        if (this.driverEndpoint() == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)this.driverEndpoint().askSync(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        if (this.driverEndpoint() == null) {
            return (StorageStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StorageStatus.class));
        }
        return (StorageStatus[])this.driverEndpoint().askSync(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askStorageEndpoints) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askStorageEndpoints);
        Map response = (Map)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
        scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
        scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
        ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
        CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable blockStatus = (scala.collection.immutable.Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
        if (blockStatus == null) {
            throw new SparkException(new StringBuilder(50).append("BlockManager returned null for BlockStatus query: ").append(blockId).toString());
        }
        return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            Option status = (Option)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)blockManagerId, s)));
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askStorageEndpoints) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter, askStorageEndpoints);
        Future future = (Future)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public void stop() {
        block2: {
            if (this.driverEndpoint() == null || !this.isDriver) break block2;
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            if (BoxesRunTime.unboxToBoolean(this.driverHeartbeatEndPoint().askSync(BlockManagerMessages$StopBlockManagerMaster$.MODULE$, ClassTag$.MODULE$.Boolean()))) {
                this.driverHeartbeatEndPoint_$eq(null);
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to stop BlockManagerMasterHeartbeatEndpoint");
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockManagerMaster stopped");
        }
    }

    private void tell(Object message) {
        if (!BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(message, ClassTag$.MODULE$.Boolean()))) {
            throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
        }
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, RpcEndpointRef driverHeartbeatEndPoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.driverHeartbeatEndPoint = driverHeartbeatEndPoint;
        this.isDriver = isDriver;
        Logging.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

