/*
 * This file was generated by the Gradle 'init' task.
 *
 * This generated file contains a sample Java library project to get you started.
 * For more details take a look at the 'Building Java & JVM projects' chapter in the Gradle
 * User Manual available at https://docs.gradle.org/7.0/userguide/building_java_projects.html
 */

plugins {
    `java-library`
    antlr
}

repositories {
    mavenCentral()
}

dependencies {
    implementation("org.postgresql:postgresql:42.2.20")
    api("org.apache.commons:commons-text:1.9")
    antlr("org.antlr:antlr4:4.9.2")

    testImplementation("org.junit.jupiter:junit-jupiter-api:5.7.1")
    testRuntimeOnly("org.junit.jupiter:junit-jupiter-engine")

    testImplementation("org.testcontainers:testcontainers:1.15.3")
    testImplementation("org.postgresql:postgresql:42.2.20")
}

tasks.generateGrammarSource {
    maxHeapSize = "64m"
    source = project.objects
        .sourceDirectorySet("antlr", "antlr")
        .srcDir("${projectDir}/../../").apply {
            include("*.g4")
        }
    arguments.addAll(arrayOf("-package", "org.apache.age.jdbc.antlr4"))
    outputDirectory = file("$outputDirectory/org/apache/age/jdbc/antlr4")
}

tasks.test {
    useJUnitPlatform()
}
