/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.CipherHandler;
import com.amazonaws.encryptionsdk.internal.CryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.CipherFrameHeaders;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.crypto.SecretKey;

class FrameEncryptionHandler
implements CryptoHandler {
    private final SecretKey encryptionKey_;
    private final CryptoAlgorithm cryptoAlgo_;
    private final CipherHandler cipherHandler_;
    private final int nonceLen_;
    private final byte[] messageId_;
    private final int frameSize_;
    private final int tagLenBytes_;
    private long frameNumber_ = 1L;
    private boolean isFinalFrame_;
    private final byte[] bytesToFrame_;
    private int bytesToFrameLen_;
    private boolean complete_ = false;

    public FrameEncryptionHandler(SecretKey encryptionKey, int nonceLen, CryptoAlgorithm cryptoAlgo, byte[] messageId, int frameSize) {
        this.encryptionKey_ = encryptionKey;
        this.cryptoAlgo_ = cryptoAlgo;
        this.nonceLen_ = nonceLen;
        this.messageId_ = (byte[])messageId.clone();
        this.frameSize_ = frameSize;
        this.tagLenBytes_ = this.cryptoAlgo_.getTagLen();
        this.bytesToFrame_ = new byte[this.frameSize_];
        this.bytesToFrameLen_ = 0;
        this.cipherHandler_ = new CipherHandler(this.encryptionKey_, 1, this.cryptoAlgo_);
    }

    @Override
    public ProcessingSummary processBytes(byte[] in, int off, int len, byte[] out, int outOff) throws BadCiphertextException {
        int actualOutLen = 0;
        int size = len;
        int offset = off;
        while (size > 0) {
            int currentFrameCapacity = this.frameSize_ - this.bytesToFrameLen_;
            size = Math.min(currentFrameCapacity, size);
            System.arraycopy(in, offset, this.bytesToFrame_, this.bytesToFrameLen_, size);
            this.bytesToFrameLen_ += size;
            if (this.bytesToFrameLen_ == this.frameSize_) {
                actualOutLen += this.writeEncryptedFrame(this.bytesToFrame_, 0, this.bytesToFrameLen_, out, outOff + actualOutLen);
                this.bytesToFrameLen_ = 0;
            }
            offset += size;
            size = len - offset;
        }
        return new ProcessingSummary(actualOutLen, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws BadCiphertextException {
        this.isFinalFrame_ = true;
        this.complete_ = true;
        return this.writeEncryptedFrame(this.bytesToFrame_, 0, this.bytesToFrameLen_, out, outOff);
    }

    @Override
    public int estimateOutputSize(int inLen) {
        int outSize = 0;
        int frames = 0;
        int totalContent = this.bytesToFrameLen_ + inLen;
        frames = totalContent / this.frameSize_;
        outSize += this.frameSize_ * frames;
        int leftover = totalContent % this.frameSize_;
        outSize += leftover;
        outSize += ++frames * (this.nonceLen_ + this.tagLenBytes_);
        outSize += frames * 4;
        outSize += 4;
        return outSize += 4;
    }

    @Override
    public int estimatePartialOutputSize(int inLen) {
        int outSize = 0;
        int frames = 0;
        int totalContent = this.bytesToFrameLen_;
        if (inLen >= 0) {
            totalContent += inLen;
        }
        frames = totalContent / this.frameSize_;
        outSize += this.frameSize_ * frames;
        outSize += frames * (this.nonceLen_ + this.tagLenBytes_);
        return outSize += frames * 4;
    }

    @Override
    public int estimateFinalOutputSize() {
        int outSize = 0;
        int frames = 0;
        int totalContent = this.bytesToFrameLen_;
        frames = totalContent / this.frameSize_;
        outSize += this.frameSize_ * frames;
        int leftover = totalContent % this.frameSize_;
        outSize += leftover;
        outSize += ++frames * (this.nonceLen_ + this.tagLenBytes_);
        outSize += frames * 4;
        outSize += 4;
        return outSize += 4;
    }

    private int writeEncryptedFrame(byte[] input, int off, int len, byte[] out, int outOff) throws BadCiphertextException, AwsCryptoException {
        if (this.frameNumber_ > 0xFFFFFFFFL || this.frameNumber_ == 0xFFFFFFFFL && !this.isFinalFrame_) {
            throw new AwsCryptoException("Frame number exceeded the maximum allowed value.");
        }
        if (out.length == 0) {
            return 0;
        }
        int outLen = 0;
        byte[] contentAad = this.isFinalFrame_ ? Utils.generateContentAad(this.messageId_, "AWSKMSEncryptionClient Final Frame", (int)this.frameNumber_, len) : Utils.generateContentAad(this.messageId_, "AWSKMSEncryptionClient Frame", (int)this.frameNumber_, this.frameSize_);
        byte[] nonce = this.getNonce();
        byte[] encryptedBytes = this.cipherHandler_.cipherData(nonce, contentAad, input, off, len);
        int encryptedContentLen = encryptedBytes.length - this.tagLenBytes_;
        CipherFrameHeaders cipherFrameHeaders = new CipherFrameHeaders((int)this.frameNumber_, nonce, encryptedContentLen, this.isFinalFrame_);
        byte[] cipherFrameHeaderBytes = cipherFrameHeaders.toByteArray();
        System.arraycopy(cipherFrameHeaderBytes, 0, out, outOff + outLen, cipherFrameHeaderBytes.length);
        System.arraycopy(encryptedBytes, 0, out, outOff + (outLen += cipherFrameHeaderBytes.length), encryptedBytes.length);
        ++this.frameNumber_;
        return outLen += encryptedBytes.length;
    }

    private byte[] getNonce() {
        if (this.frameNumber_ < 1L) {
            throw new IllegalStateException("Illegal frame number");
        }
        if ((int)this.frameNumber_ == -1 && !this.isFinalFrame_) {
            throw new IllegalStateException("Too many frames");
        }
        byte[] nonce = new byte[this.nonceLen_];
        ByteBuffer buf = ByteBuffer.wrap(nonce);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.position(buf.limit() - 8);
        buf.putLong(this.frameNumber_);
        return nonce;
    }

    @Override
    public boolean isComplete() {
        return this.complete_;
    }
}

